/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.transfer.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ExecutionErrorType {
    PERMISSION_DENIED("PERMISSION_DENIED"),
    CUSTOM_STEP_FAILED("CUSTOM_STEP_FAILED"),
    THROTTLED("THROTTLED"),
    ALREADY_EXISTS("ALREADY_EXISTS"),
    NOT_FOUND("NOT_FOUND"),
    BAD_REQUEST("BAD_REQUEST"),
    TIMEOUT("TIMEOUT"),
    INTERNAL_SERVER_ERROR("INTERNAL_SERVER_ERROR"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ExecutionErrorType> VALUE_MAP;
    private final String value;

    private ExecutionErrorType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ExecutionErrorType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ExecutionErrorType> knownValues() {
        EnumSet<ExecutionErrorType> knownValues = EnumSet.allOf(ExecutionErrorType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ExecutionErrorType.class, ExecutionErrorType::toString);
    }
}

