/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.transfer.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.transfer.model.TransferResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateHostKeyResponse
extends TransferResponse
implements ToCopyableBuilder<Builder, UpdateHostKeyResponse> {
    private static final SdkField<String> SERVER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ServerId").getter(UpdateHostKeyResponse.getter(UpdateHostKeyResponse::serverId)).setter(UpdateHostKeyResponse.setter(Builder::serverId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServerId").build()}).build();
    private static final SdkField<String> HOST_KEY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("HostKeyId").getter(UpdateHostKeyResponse.getter(UpdateHostKeyResponse::hostKeyId)).setter(UpdateHostKeyResponse.setter(Builder::hostKeyId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HostKeyId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SERVER_ID_FIELD, HOST_KEY_ID_FIELD));
    private final String serverId;
    private final String hostKeyId;

    private UpdateHostKeyResponse(BuilderImpl builder) {
        super(builder);
        this.serverId = builder.serverId;
        this.hostKeyId = builder.hostKeyId;
    }

    public final String serverId() {
        return this.serverId;
    }

    public final String hostKeyId() {
        return this.hostKeyId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.serverId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hostKeyId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateHostKeyResponse)) {
            return false;
        }
        UpdateHostKeyResponse other = (UpdateHostKeyResponse)((Object)obj);
        return Objects.equals(this.serverId(), other.serverId()) && Objects.equals(this.hostKeyId(), other.hostKeyId());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateHostKeyResponse").add("ServerId", (Object)this.serverId()).add("HostKeyId", (Object)this.hostKeyId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ServerId": {
                return Optional.ofNullable(clazz.cast(this.serverId()));
            }
            case "HostKeyId": {
                return Optional.ofNullable(clazz.cast(this.hostKeyId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateHostKeyResponse, T> g) {
        return obj -> g.apply((UpdateHostKeyResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends TransferResponse.BuilderImpl
    implements Builder {
        private String serverId;
        private String hostKeyId;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateHostKeyResponse model) {
            super(model);
            this.serverId(model.serverId);
            this.hostKeyId(model.hostKeyId);
        }

        public final String getServerId() {
            return this.serverId;
        }

        public final void setServerId(String serverId) {
            this.serverId = serverId;
        }

        @Override
        public final Builder serverId(String serverId) {
            this.serverId = serverId;
            return this;
        }

        public final String getHostKeyId() {
            return this.hostKeyId;
        }

        public final void setHostKeyId(String hostKeyId) {
            this.hostKeyId = hostKeyId;
        }

        @Override
        public final Builder hostKeyId(String hostKeyId) {
            this.hostKeyId = hostKeyId;
            return this;
        }

        @Override
        public UpdateHostKeyResponse build() {
            return new UpdateHostKeyResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends TransferResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateHostKeyResponse> {
        public Builder serverId(String var1);

        public Builder hostKeyId(String var1);
    }
}

