/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.transfer.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.transfer.model.As2ConnectorConfig;
import software.amazon.awssdk.services.transfer.model.Tag;
import software.amazon.awssdk.services.transfer.model.TagsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribedConnector
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DescribedConnector> {
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Arn").getter(DescribedConnector.getter(DescribedConnector::arn)).setter(DescribedConnector.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()}).build();
    private static final SdkField<String> CONNECTOR_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ConnectorId").getter(DescribedConnector.getter(DescribedConnector::connectorId)).setter(DescribedConnector.setter(Builder::connectorId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConnectorId").build()}).build();
    private static final SdkField<String> URL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Url").getter(DescribedConnector.getter(DescribedConnector::url)).setter(DescribedConnector.setter(Builder::url)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Url").build()}).build();
    private static final SdkField<As2ConnectorConfig> AS2_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("As2Config").getter(DescribedConnector.getter(DescribedConnector::as2Config)).setter(DescribedConnector.setter(Builder::as2Config)).constructor(As2ConnectorConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("As2Config").build()}).build();
    private static final SdkField<String> ACCESS_ROLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AccessRole").getter(DescribedConnector.getter(DescribedConnector::accessRole)).setter(DescribedConnector.setter(Builder::accessRole)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccessRole").build()}).build();
    private static final SdkField<String> LOGGING_ROLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LoggingRole").getter(DescribedConnector.getter(DescribedConnector::loggingRole)).setter(DescribedConnector.setter(Builder::loggingRole)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LoggingRole").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Tags").getter(DescribedConnector.getter(DescribedConnector::tags)).setter(DescribedConnector.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, CONNECTOR_ID_FIELD, URL_FIELD, AS2_CONFIG_FIELD, ACCESS_ROLE_FIELD, LOGGING_ROLE_FIELD, TAGS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String arn;
    private final String connectorId;
    private final String url;
    private final As2ConnectorConfig as2Config;
    private final String accessRole;
    private final String loggingRole;
    private final List<Tag> tags;

    private DescribedConnector(BuilderImpl builder) {
        this.arn = builder.arn;
        this.connectorId = builder.connectorId;
        this.url = builder.url;
        this.as2Config = builder.as2Config;
        this.accessRole = builder.accessRole;
        this.loggingRole = builder.loggingRole;
        this.tags = builder.tags;
    }

    public final String arn() {
        return this.arn;
    }

    public final String connectorId() {
        return this.connectorId;
    }

    public final String url() {
        return this.url;
    }

    public final As2ConnectorConfig as2Config() {
        return this.as2Config;
    }

    public final String accessRole() {
        return this.accessRole;
    }

    public final String loggingRole() {
        return this.loggingRole;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.connectorId());
        hashCode = 31 * hashCode + Objects.hashCode(this.url());
        hashCode = 31 * hashCode + Objects.hashCode(this.as2Config());
        hashCode = 31 * hashCode + Objects.hashCode(this.accessRole());
        hashCode = 31 * hashCode + Objects.hashCode(this.loggingRole());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribedConnector)) {
            return false;
        }
        DescribedConnector other = (DescribedConnector)obj;
        return Objects.equals(this.arn(), other.arn()) && Objects.equals(this.connectorId(), other.connectorId()) && Objects.equals(this.url(), other.url()) && Objects.equals(this.as2Config(), other.as2Config()) && Objects.equals(this.accessRole(), other.accessRole()) && Objects.equals(this.loggingRole(), other.loggingRole()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"DescribedConnector").add("Arn", (Object)this.arn()).add("ConnectorId", (Object)this.connectorId()).add("Url", (Object)this.url()).add("As2Config", (Object)this.as2Config()).add("AccessRole", (Object)this.accessRole()).add("LoggingRole", (Object)this.loggingRole()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "ConnectorId": {
                return Optional.ofNullable(clazz.cast(this.connectorId()));
            }
            case "Url": {
                return Optional.ofNullable(clazz.cast(this.url()));
            }
            case "As2Config": {
                return Optional.ofNullable(clazz.cast(this.as2Config()));
            }
            case "AccessRole": {
                return Optional.ofNullable(clazz.cast(this.accessRole()));
            }
            case "LoggingRole": {
                return Optional.ofNullable(clazz.cast(this.loggingRole()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribedConnector, T> g) {
        return obj -> g.apply((DescribedConnector)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String arn;
        private String connectorId;
        private String url;
        private As2ConnectorConfig as2Config;
        private String accessRole;
        private String loggingRole;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribedConnector model) {
            this.arn(model.arn);
            this.connectorId(model.connectorId);
            this.url(model.url);
            this.as2Config(model.as2Config);
            this.accessRole(model.accessRole);
            this.loggingRole(model.loggingRole);
            this.tags(model.tags);
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getConnectorId() {
            return this.connectorId;
        }

        public final void setConnectorId(String connectorId) {
            this.connectorId = connectorId;
        }

        @Override
        public final Builder connectorId(String connectorId) {
            this.connectorId = connectorId;
            return this;
        }

        public final String getUrl() {
            return this.url;
        }

        public final void setUrl(String url) {
            this.url = url;
        }

        @Override
        public final Builder url(String url) {
            this.url = url;
            return this;
        }

        public final As2ConnectorConfig.Builder getAs2Config() {
            return this.as2Config != null ? this.as2Config.toBuilder() : null;
        }

        public final void setAs2Config(As2ConnectorConfig.BuilderImpl as2Config) {
            this.as2Config = as2Config != null ? as2Config.build() : null;
        }

        @Override
        public final Builder as2Config(As2ConnectorConfig as2Config) {
            this.as2Config = as2Config;
            return this;
        }

        public final String getAccessRole() {
            return this.accessRole;
        }

        public final void setAccessRole(String accessRole) {
            this.accessRole = accessRole;
        }

        @Override
        public final Builder accessRole(String accessRole) {
            this.accessRole = accessRole;
            return this;
        }

        public final String getLoggingRole() {
            return this.loggingRole;
        }

        public final void setLoggingRole(String loggingRole) {
            this.loggingRole = loggingRole;
        }

        @Override
        public final Builder loggingRole(String loggingRole) {
            this.loggingRole = loggingRole;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagsCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagsCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public DescribedConnector build() {
            return new DescribedConnector(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DescribedConnector> {
        public Builder arn(String var1);

        public Builder connectorId(String var1);

        public Builder url(String var1);

        public Builder as2Config(As2ConnectorConfig var1);

        default public Builder as2Config(Consumer<As2ConnectorConfig.Builder> as2Config) {
            return this.as2Config((As2ConnectorConfig)((As2ConnectorConfig.Builder)As2ConnectorConfig.builder().applyMutation(as2Config)).build());
        }

        public Builder accessRole(String var1);

        public Builder loggingRole(String var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);
    }
}

