/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.transfer.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.transfer.model.HomeDirectoryType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListedAccess
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ListedAccess> {
    private static final SdkField<String> HOME_DIRECTORY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("HomeDirectory").getter(ListedAccess.getter(ListedAccess::homeDirectory)).setter(ListedAccess.setter(Builder::homeDirectory)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HomeDirectory").build()}).build();
    private static final SdkField<String> HOME_DIRECTORY_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("HomeDirectoryType").getter(ListedAccess.getter(ListedAccess::homeDirectoryTypeAsString)).setter(ListedAccess.setter(Builder::homeDirectoryType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HomeDirectoryType").build()}).build();
    private static final SdkField<String> ROLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Role").getter(ListedAccess.getter(ListedAccess::role)).setter(ListedAccess.setter(Builder::role)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Role").build()}).build();
    private static final SdkField<String> EXTERNAL_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ExternalId").getter(ListedAccess.getter(ListedAccess::externalId)).setter(ListedAccess.setter(Builder::externalId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExternalId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(HOME_DIRECTORY_FIELD, HOME_DIRECTORY_TYPE_FIELD, ROLE_FIELD, EXTERNAL_ID_FIELD));
    private static final long serialVersionUID = 1L;
    private final String homeDirectory;
    private final String homeDirectoryType;
    private final String role;
    private final String externalId;

    private ListedAccess(BuilderImpl builder) {
        this.homeDirectory = builder.homeDirectory;
        this.homeDirectoryType = builder.homeDirectoryType;
        this.role = builder.role;
        this.externalId = builder.externalId;
    }

    public final String homeDirectory() {
        return this.homeDirectory;
    }

    public final HomeDirectoryType homeDirectoryType() {
        return HomeDirectoryType.fromValue(this.homeDirectoryType);
    }

    public final String homeDirectoryTypeAsString() {
        return this.homeDirectoryType;
    }

    public final String role() {
        return this.role;
    }

    public final String externalId() {
        return this.externalId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.homeDirectory());
        hashCode = 31 * hashCode + Objects.hashCode(this.homeDirectoryTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.role());
        hashCode = 31 * hashCode + Objects.hashCode(this.externalId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListedAccess)) {
            return false;
        }
        ListedAccess other = (ListedAccess)obj;
        return Objects.equals(this.homeDirectory(), other.homeDirectory()) && Objects.equals(this.homeDirectoryTypeAsString(), other.homeDirectoryTypeAsString()) && Objects.equals(this.role(), other.role()) && Objects.equals(this.externalId(), other.externalId());
    }

    public final String toString() {
        return ToString.builder((String)"ListedAccess").add("HomeDirectory", (Object)this.homeDirectory()).add("HomeDirectoryType", (Object)this.homeDirectoryTypeAsString()).add("Role", (Object)this.role()).add("ExternalId", (Object)this.externalId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "HomeDirectory": {
                return Optional.ofNullable(clazz.cast(this.homeDirectory()));
            }
            case "HomeDirectoryType": {
                return Optional.ofNullable(clazz.cast(this.homeDirectoryTypeAsString()));
            }
            case "Role": {
                return Optional.ofNullable(clazz.cast(this.role()));
            }
            case "ExternalId": {
                return Optional.ofNullable(clazz.cast(this.externalId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListedAccess, T> g) {
        return obj -> g.apply((ListedAccess)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String homeDirectory;
        private String homeDirectoryType;
        private String role;
        private String externalId;

        private BuilderImpl() {
        }

        private BuilderImpl(ListedAccess model) {
            this.homeDirectory(model.homeDirectory);
            this.homeDirectoryType(model.homeDirectoryType);
            this.role(model.role);
            this.externalId(model.externalId);
        }

        public final String getHomeDirectory() {
            return this.homeDirectory;
        }

        @Override
        public final Builder homeDirectory(String homeDirectory) {
            this.homeDirectory = homeDirectory;
            return this;
        }

        public final void setHomeDirectory(String homeDirectory) {
            this.homeDirectory = homeDirectory;
        }

        public final String getHomeDirectoryType() {
            return this.homeDirectoryType;
        }

        @Override
        public final Builder homeDirectoryType(String homeDirectoryType) {
            this.homeDirectoryType = homeDirectoryType;
            return this;
        }

        @Override
        public final Builder homeDirectoryType(HomeDirectoryType homeDirectoryType) {
            this.homeDirectoryType(homeDirectoryType == null ? null : homeDirectoryType.toString());
            return this;
        }

        public final void setHomeDirectoryType(String homeDirectoryType) {
            this.homeDirectoryType = homeDirectoryType;
        }

        public final String getRole() {
            return this.role;
        }

        @Override
        public final Builder role(String role) {
            this.role = role;
            return this;
        }

        public final void setRole(String role) {
            this.role = role;
        }

        public final String getExternalId() {
            return this.externalId;
        }

        @Override
        public final Builder externalId(String externalId) {
            this.externalId = externalId;
            return this;
        }

        public final void setExternalId(String externalId) {
            this.externalId = externalId;
        }

        public ListedAccess build() {
            return new ListedAccess(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ListedAccess> {
        public Builder homeDirectory(String var1);

        public Builder homeDirectoryType(String var1);

        public Builder homeDirectoryType(HomeDirectoryType var1);

        public Builder role(String var1);

        public Builder externalId(String var1);
    }
}

