/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.transfer.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;

/**
 * <p>
 * Describes the condition of a file transfer protocol-enabled server with respect to its ability to perform file
 * operations. There are six possible states: <code>OFFLINE</code>, <code>ONLINE</code>, <code>STARTING</code>,
 * <code>STOPPING</code>, <code>START_FAILED</code>, and <code>STOP_FAILED</code>.
 * </p>
 * <p>
 * <code>OFFLINE</code> indicates that the server exists, but that it is not available for file operations.
 * <code>ONLINE</code> indicates that the server is available to perform file operations. <code>STARTING</code>
 * indicates that the server's was instantiated, but the server is not yet available to perform file operations. Under
 * normal conditions, it can take a couple of minutes for the server to be completely operational. Both
 * <code>START_FAILED</code> and <code>STOP_FAILED</code> are error conditions.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public enum State {
    OFFLINE("OFFLINE"),

    ONLINE("ONLINE"),

    STARTING("STARTING"),

    STOPPING("STOPPING"),

    START_FAILED("START_FAILED"),

    STOP_FAILED("STOP_FAILED"),

    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private State(String value) {
        this.value = value;
    }

    @Override
    public String toString() {
        return String.valueOf(value);
    }

    /**
     * Use this in place of valueOf to convert the raw string returned by the service into the enum value.
     *
     * @param value
     *        real value
     * @return State corresponding to the value
     */
    public static State fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(State.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    /**
     * Use this in place of {@link #values()} to return a {@link Set} of all values known to the SDK. This will return
     * all known enum values except {@link #UNKNOWN_TO_SDK_VERSION}.
     *
     * @return a {@link Set} of known {@link State}s
     */
    public static Set<State> knownValues() {
        return Stream.of(values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}
