/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.transfer.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeUserResponse extends TransferResponse implements
        ToCopyableBuilder<DescribeUserResponse.Builder, DescribeUserResponse> {
    private static final SdkField<String> SERVER_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ServerId").getter(getter(DescribeUserResponse::serverId)).setter(setter(Builder::serverId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServerId").build()).build();

    private static final SdkField<DescribedUser> USER_FIELD = SdkField.<DescribedUser> builder(MarshallingType.SDK_POJO)
            .memberName("User").getter(getter(DescribeUserResponse::user)).setter(setter(Builder::user))
            .constructor(DescribedUser::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("User").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SERVER_ID_FIELD, USER_FIELD));

    private final String serverId;

    private final DescribedUser user;

    private DescribeUserResponse(BuilderImpl builder) {
        super(builder);
        this.serverId = builder.serverId;
        this.user = builder.user;
    }

    /**
     * <p>
     * A system-assigned unique identifier for a server that has this user assigned.
     * </p>
     * 
     * @return A system-assigned unique identifier for a server that has this user assigned.
     */
    public final String serverId() {
        return serverId;
    }

    /**
     * <p>
     * An array containing the properties of the user account for the <code>ServerID</code> value that you specified.
     * </p>
     * 
     * @return An array containing the properties of the user account for the <code>ServerID</code> value that you
     *         specified.
     */
    public final DescribedUser user() {
        return user;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(serverId());
        hashCode = 31 * hashCode + Objects.hashCode(user());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeUserResponse)) {
            return false;
        }
        DescribeUserResponse other = (DescribeUserResponse) obj;
        return Objects.equals(serverId(), other.serverId()) && Objects.equals(user(), other.user());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeUserResponse").add("ServerId", serverId()).add("User", user()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ServerId":
            return Optional.ofNullable(clazz.cast(serverId()));
        case "User":
            return Optional.ofNullable(clazz.cast(user()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeUserResponse, T> g) {
        return obj -> g.apply((DescribeUserResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends TransferResponse.Builder, SdkPojo, CopyableBuilder<Builder, DescribeUserResponse> {
        /**
         * <p>
         * A system-assigned unique identifier for a server that has this user assigned.
         * </p>
         * 
         * @param serverId
         *        A system-assigned unique identifier for a server that has this user assigned.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serverId(String serverId);

        /**
         * <p>
         * An array containing the properties of the user account for the <code>ServerID</code> value that you
         * specified.
         * </p>
         * 
         * @param user
         *        An array containing the properties of the user account for the <code>ServerID</code> value that you
         *        specified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder user(DescribedUser user);

        /**
         * <p>
         * An array containing the properties of the user account for the <code>ServerID</code> value that you
         * specified.
         * </p>
         * This is a convenience that creates an instance of the {@link DescribedUser.Builder} avoiding the need to
         * create one manually via {@link DescribedUser#builder()}.
         *
         * When the {@link Consumer} completes, {@link DescribedUser.Builder#build()} is called immediately and its
         * result is passed to {@link #user(DescribedUser)}.
         * 
         * @param user
         *        a consumer that will call methods on {@link DescribedUser.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #user(DescribedUser)
         */
        default Builder user(Consumer<DescribedUser.Builder> user) {
            return user(DescribedUser.builder().applyMutation(user).build());
        }
    }

    static final class BuilderImpl extends TransferResponse.BuilderImpl implements Builder {
        private String serverId;

        private DescribedUser user;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeUserResponse model) {
            super(model);
            serverId(model.serverId);
            user(model.user);
        }

        public final String getServerId() {
            return serverId;
        }

        @Override
        public final Builder serverId(String serverId) {
            this.serverId = serverId;
            return this;
        }

        public final void setServerId(String serverId) {
            this.serverId = serverId;
        }

        public final DescribedUser.Builder getUser() {
            return user != null ? user.toBuilder() : null;
        }

        @Override
        public final Builder user(DescribedUser user) {
            this.user = user;
            return this;
        }

        public final void setUser(DescribedUser.BuilderImpl user) {
            this.user = user != null ? user.build() : null;
        }

        @Override
        public DescribeUserResponse build() {
            return new DescribeUserResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
