/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.transfer.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.transfer.model.AddressAllocationIdsCopier;
import software.amazon.awssdk.services.transfer.model.SubnetIdsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class EndpointDetails
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, EndpointDetails> {
    private static final SdkField<List<String>> ADDRESS_ALLOCATION_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AddressAllocationIds").getter(EndpointDetails.getter(EndpointDetails::addressAllocationIds)).setter(EndpointDetails.setter(Builder::addressAllocationIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AddressAllocationIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> SUBNET_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SubnetIds").getter(EndpointDetails.getter(EndpointDetails::subnetIds)).setter(EndpointDetails.setter(Builder::subnetIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubnetIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> VPC_ENDPOINT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("VpcEndpointId").getter(EndpointDetails.getter(EndpointDetails::vpcEndpointId)).setter(EndpointDetails.setter(Builder::vpcEndpointId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcEndpointId").build()}).build();
    private static final SdkField<String> VPC_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("VpcId").getter(EndpointDetails.getter(EndpointDetails::vpcId)).setter(EndpointDetails.setter(Builder::vpcId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ADDRESS_ALLOCATION_IDS_FIELD, SUBNET_IDS_FIELD, VPC_ENDPOINT_ID_FIELD, VPC_ID_FIELD));
    private static final long serialVersionUID = 1L;
    private final List<String> addressAllocationIds;
    private final List<String> subnetIds;
    private final String vpcEndpointId;
    private final String vpcId;

    private EndpointDetails(BuilderImpl builder) {
        this.addressAllocationIds = builder.addressAllocationIds;
        this.subnetIds = builder.subnetIds;
        this.vpcEndpointId = builder.vpcEndpointId;
        this.vpcId = builder.vpcId;
    }

    public boolean hasAddressAllocationIds() {
        return this.addressAllocationIds != null && !(this.addressAllocationIds instanceof SdkAutoConstructList);
    }

    public List<String> addressAllocationIds() {
        return this.addressAllocationIds;
    }

    public boolean hasSubnetIds() {
        return this.subnetIds != null && !(this.subnetIds instanceof SdkAutoConstructList);
    }

    public List<String> subnetIds() {
        return this.subnetIds;
    }

    public String vpcEndpointId() {
        return this.vpcEndpointId;
    }

    public String vpcId() {
        return this.vpcId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.addressAllocationIds());
        hashCode = 31 * hashCode + Objects.hashCode(this.subnetIds());
        hashCode = 31 * hashCode + Objects.hashCode(this.vpcEndpointId());
        hashCode = 31 * hashCode + Objects.hashCode(this.vpcId());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EndpointDetails)) {
            return false;
        }
        EndpointDetails other = (EndpointDetails)obj;
        return Objects.equals(this.addressAllocationIds(), other.addressAllocationIds()) && Objects.equals(this.subnetIds(), other.subnetIds()) && Objects.equals(this.vpcEndpointId(), other.vpcEndpointId()) && Objects.equals(this.vpcId(), other.vpcId());
    }

    public String toString() {
        return ToString.builder((String)"EndpointDetails").add("AddressAllocationIds", this.addressAllocationIds()).add("SubnetIds", this.subnetIds()).add("VpcEndpointId", (Object)this.vpcEndpointId()).add("VpcId", (Object)this.vpcId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AddressAllocationIds": {
                return Optional.ofNullable(clazz.cast(this.addressAllocationIds()));
            }
            case "SubnetIds": {
                return Optional.ofNullable(clazz.cast(this.subnetIds()));
            }
            case "VpcEndpointId": {
                return Optional.ofNullable(clazz.cast(this.vpcEndpointId()));
            }
            case "VpcId": {
                return Optional.ofNullable(clazz.cast(this.vpcId()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<EndpointDetails, T> g) {
        return obj -> g.apply((EndpointDetails)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> addressAllocationIds = DefaultSdkAutoConstructList.getInstance();
        private List<String> subnetIds = DefaultSdkAutoConstructList.getInstance();
        private String vpcEndpointId;
        private String vpcId;

        private BuilderImpl() {
        }

        private BuilderImpl(EndpointDetails model) {
            this.addressAllocationIds(model.addressAllocationIds);
            this.subnetIds(model.subnetIds);
            this.vpcEndpointId(model.vpcEndpointId);
            this.vpcId(model.vpcId);
        }

        public final Collection<String> getAddressAllocationIds() {
            return this.addressAllocationIds;
        }

        @Override
        public final Builder addressAllocationIds(Collection<String> addressAllocationIds) {
            this.addressAllocationIds = AddressAllocationIdsCopier.copy(addressAllocationIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder addressAllocationIds(String ... addressAllocationIds) {
            this.addressAllocationIds(Arrays.asList(addressAllocationIds));
            return this;
        }

        public final void setAddressAllocationIds(Collection<String> addressAllocationIds) {
            this.addressAllocationIds = AddressAllocationIdsCopier.copy(addressAllocationIds);
        }

        public final Collection<String> getSubnetIds() {
            return this.subnetIds;
        }

        @Override
        public final Builder subnetIds(Collection<String> subnetIds) {
            this.subnetIds = SubnetIdsCopier.copy(subnetIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder subnetIds(String ... subnetIds) {
            this.subnetIds(Arrays.asList(subnetIds));
            return this;
        }

        public final void setSubnetIds(Collection<String> subnetIds) {
            this.subnetIds = SubnetIdsCopier.copy(subnetIds);
        }

        public final String getVpcEndpointId() {
            return this.vpcEndpointId;
        }

        @Override
        public final Builder vpcEndpointId(String vpcEndpointId) {
            this.vpcEndpointId = vpcEndpointId;
            return this;
        }

        public final void setVpcEndpointId(String vpcEndpointId) {
            this.vpcEndpointId = vpcEndpointId;
        }

        public final String getVpcId() {
            return this.vpcId;
        }

        @Override
        public final Builder vpcId(String vpcId) {
            this.vpcId = vpcId;
            return this;
        }

        public final void setVpcId(String vpcId) {
            this.vpcId = vpcId;
        }

        public EndpointDetails build() {
            return new EndpointDetails(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, EndpointDetails> {
        public Builder addressAllocationIds(Collection<String> var1);

        public Builder addressAllocationIds(String ... var1);

        public Builder subnetIds(Collection<String> var1);

        public Builder subnetIds(String ... var1);

        public Builder vpcEndpointId(String var1);

        public Builder vpcId(String var1);
    }
}

