/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.transfer.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Returns information related to the type of user authentication that is in use for a server's users. A server can have
 * only one method of authentication.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class IdentityProviderDetails implements SdkPojo, Serializable,
        ToCopyableBuilder<IdentityProviderDetails.Builder, IdentityProviderDetails> {
    private static final SdkField<String> URL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(IdentityProviderDetails::url)).setter(setter(Builder::url))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Url").build()).build();

    private static final SdkField<String> INVOCATION_ROLE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(IdentityProviderDetails::invocationRole)).setter(setter(Builder::invocationRole))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InvocationRole").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(URL_FIELD,
            INVOCATION_ROLE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String url;

    private final String invocationRole;

    private IdentityProviderDetails(BuilderImpl builder) {
        this.url = builder.url;
        this.invocationRole = builder.invocationRole;
    }

    /**
     * <p>
     * The <code>Url</code> parameter provides contains the location of the service endpoint used to authenticate users.
     * </p>
     * 
     * @return The <code>Url</code> parameter provides contains the location of the service endpoint used to
     *         authenticate users.
     */
    public String url() {
        return url;
    }

    /**
     * <p>
     * The <code>InvocationRole</code> parameter provides the type of <code>InvocationRole</code> used to authenticate
     * the user account.
     * </p>
     * 
     * @return The <code>InvocationRole</code> parameter provides the type of <code>InvocationRole</code> used to
     *         authenticate the user account.
     */
    public String invocationRole() {
        return invocationRole;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(url());
        hashCode = 31 * hashCode + Objects.hashCode(invocationRole());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IdentityProviderDetails)) {
            return false;
        }
        IdentityProviderDetails other = (IdentityProviderDetails) obj;
        return Objects.equals(url(), other.url()) && Objects.equals(invocationRole(), other.invocationRole());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("IdentityProviderDetails").add("Url", url()).add("InvocationRole", invocationRole()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Url":
            return Optional.ofNullable(clazz.cast(url()));
        case "InvocationRole":
            return Optional.ofNullable(clazz.cast(invocationRole()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<IdentityProviderDetails, T> g) {
        return obj -> g.apply((IdentityProviderDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, IdentityProviderDetails> {
        /**
         * <p>
         * The <code>Url</code> parameter provides contains the location of the service endpoint used to authenticate
         * users.
         * </p>
         * 
         * @param url
         *        The <code>Url</code> parameter provides contains the location of the service endpoint used to
         *        authenticate users.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder url(String url);

        /**
         * <p>
         * The <code>InvocationRole</code> parameter provides the type of <code>InvocationRole</code> used to
         * authenticate the user account.
         * </p>
         * 
         * @param invocationRole
         *        The <code>InvocationRole</code> parameter provides the type of <code>InvocationRole</code> used to
         *        authenticate the user account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder invocationRole(String invocationRole);
    }

    static final class BuilderImpl implements Builder {
        private String url;

        private String invocationRole;

        private BuilderImpl() {
        }

        private BuilderImpl(IdentityProviderDetails model) {
            url(model.url);
            invocationRole(model.invocationRole);
        }

        public final String getUrl() {
            return url;
        }

        @Override
        public final Builder url(String url) {
            this.url = url;
            return this;
        }

        public final void setUrl(String url) {
            this.url = url;
        }

        public final String getInvocationRole() {
            return invocationRole;
        }

        @Override
        public final Builder invocationRole(String invocationRole) {
            this.invocationRole = invocationRole;
            return this;
        }

        public final void setInvocationRole(String invocationRole) {
            this.invocationRole = invocationRole;
        }

        @Override
        public IdentityProviderDetails build() {
            return new IdentityProviderDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
