/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.transcribestreaming.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.transcribestreaming.model.Alternative;
import software.amazon.awssdk.services.transcribestreaming.model.AlternativeListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Result
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Result> {
    private static final SdkField<String> RESULT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Result.getter(Result::resultId)).setter(Result.setter(Builder::resultId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResultId").build()}).build();
    private static final SdkField<Double> START_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).getter(Result.getter(Result::startTime)).setter(Result.setter(Builder::startTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartTime").build()}).build();
    private static final SdkField<Double> END_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).getter(Result.getter(Result::endTime)).setter(Result.setter(Builder::endTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndTime").build()}).build();
    private static final SdkField<Boolean> IS_PARTIAL_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).getter(Result.getter(Result::isPartial)).setter(Result.setter(Builder::isPartial)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IsPartial").build()}).build();
    private static final SdkField<List<Alternative>> ALTERNATIVES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(Result.getter(Result::alternatives)).setter(Result.setter(Builder::alternatives)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Alternatives").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Alternative::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESULT_ID_FIELD, START_TIME_FIELD, END_TIME_FIELD, IS_PARTIAL_FIELD, ALTERNATIVES_FIELD));
    private static final long serialVersionUID = 1L;
    private final String resultId;
    private final Double startTime;
    private final Double endTime;
    private final Boolean isPartial;
    private final List<Alternative> alternatives;

    private Result(BuilderImpl builder) {
        this.resultId = builder.resultId;
        this.startTime = builder.startTime;
        this.endTime = builder.endTime;
        this.isPartial = builder.isPartial;
        this.alternatives = builder.alternatives;
    }

    public String resultId() {
        return this.resultId;
    }

    public Double startTime() {
        return this.startTime;
    }

    public Double endTime() {
        return this.endTime;
    }

    public Boolean isPartial() {
        return this.isPartial;
    }

    public List<Alternative> alternatives() {
        return this.alternatives;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.resultId());
        hashCode = 31 * hashCode + Objects.hashCode(this.startTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.endTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.isPartial());
        hashCode = 31 * hashCode + Objects.hashCode(this.alternatives());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Result)) {
            return false;
        }
        Result other = (Result)obj;
        return Objects.equals(this.resultId(), other.resultId()) && Objects.equals(this.startTime(), other.startTime()) && Objects.equals(this.endTime(), other.endTime()) && Objects.equals(this.isPartial(), other.isPartial()) && Objects.equals(this.alternatives(), other.alternatives());
    }

    public String toString() {
        return ToString.builder((String)"Result").add("ResultId", (Object)this.resultId()).add("StartTime", (Object)this.startTime()).add("EndTime", (Object)this.endTime()).add("IsPartial", (Object)this.isPartial()).add("Alternatives", this.alternatives()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ResultId": {
                return Optional.ofNullable(clazz.cast(this.resultId()));
            }
            case "StartTime": {
                return Optional.ofNullable(clazz.cast(this.startTime()));
            }
            case "EndTime": {
                return Optional.ofNullable(clazz.cast(this.endTime()));
            }
            case "IsPartial": {
                return Optional.ofNullable(clazz.cast(this.isPartial()));
            }
            case "Alternatives": {
                return Optional.ofNullable(clazz.cast(this.alternatives()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Result, T> g) {
        return obj -> g.apply((Result)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String resultId;
        private Double startTime;
        private Double endTime;
        private Boolean isPartial;
        private List<Alternative> alternatives = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(Result model) {
            this.resultId(model.resultId);
            this.startTime(model.startTime);
            this.endTime(model.endTime);
            this.isPartial(model.isPartial);
            this.alternatives(model.alternatives);
        }

        public final String getResultId() {
            return this.resultId;
        }

        @Override
        public final Builder resultId(String resultId) {
            this.resultId = resultId;
            return this;
        }

        public final void setResultId(String resultId) {
            this.resultId = resultId;
        }

        public final Double getStartTime() {
            return this.startTime;
        }

        @Override
        public final Builder startTime(Double startTime) {
            this.startTime = startTime;
            return this;
        }

        public final void setStartTime(Double startTime) {
            this.startTime = startTime;
        }

        public final Double getEndTime() {
            return this.endTime;
        }

        @Override
        public final Builder endTime(Double endTime) {
            this.endTime = endTime;
            return this;
        }

        public final void setEndTime(Double endTime) {
            this.endTime = endTime;
        }

        public final Boolean getIsPartial() {
            return this.isPartial;
        }

        @Override
        public final Builder isPartial(Boolean isPartial) {
            this.isPartial = isPartial;
            return this;
        }

        public final void setIsPartial(Boolean isPartial) {
            this.isPartial = isPartial;
        }

        public final Collection<Alternative.Builder> getAlternatives() {
            return this.alternatives != null ? (Collection)this.alternatives.stream().map(Alternative::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder alternatives(Collection<Alternative> alternatives) {
            this.alternatives = AlternativeListCopier.copy(alternatives);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder alternatives(Alternative ... alternatives) {
            this.alternatives(Arrays.asList(alternatives));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder alternatives(Consumer<Alternative.Builder> ... alternatives) {
            this.alternatives(Stream.of(alternatives).map(c -> (Alternative)((Alternative.Builder)Alternative.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setAlternatives(Collection<Alternative.BuilderImpl> alternatives) {
            this.alternatives = AlternativeListCopier.copyFromBuilder(alternatives);
        }

        public Result build() {
            return new Result(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Result> {
        public Builder resultId(String var1);

        public Builder startTime(Double var1);

        public Builder endTime(Double var1);

        public Builder isPartial(Boolean var1);

        public Builder alternatives(Collection<Alternative> var1);

        public Builder alternatives(Alternative ... var1);

        public Builder alternatives(Consumer<Alternative.Builder> ... var1);
    }
}

