/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.transcribestreaming.model;

import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;

@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
final class DefaultStartMedicalScribeStreamVisitorBuilder implements StartMedicalScribeStreamResponseHandler.Visitor.Builder {
    private Consumer<MedicalScribeResultStream> onDefault;

    private Consumer<MedicalScribeTranscriptEvent> onTranscriptEvent;

    @Override
    public StartMedicalScribeStreamResponseHandler.Visitor.Builder onDefault(Consumer<MedicalScribeResultStream> c) {
        this.onDefault = c;
        return this;
    }

    @Override
    public StartMedicalScribeStreamResponseHandler.Visitor build() {
        return new VisitorFromBuilder(this);
    }

    @Override
    public StartMedicalScribeStreamResponseHandler.Visitor.Builder onTranscriptEvent(Consumer<MedicalScribeTranscriptEvent> c) {
        this.onTranscriptEvent = c;
        return this;
    }

    @Generated("software.amazon.awssdk:codegen")
    static class VisitorFromBuilder implements StartMedicalScribeStreamResponseHandler.Visitor {
        private final Consumer<MedicalScribeResultStream> onDefault;

        private final Consumer<MedicalScribeTranscriptEvent> onTranscriptEvent;

        VisitorFromBuilder(DefaultStartMedicalScribeStreamVisitorBuilder builder) {
            this.onDefault = builder.onDefault != null ? builder.onDefault
                    : StartMedicalScribeStreamResponseHandler.Visitor.super::visitDefault;
            this.onTranscriptEvent = builder.onTranscriptEvent != null ? builder.onTranscriptEvent
                    : StartMedicalScribeStreamResponseHandler.Visitor.super::visitTranscriptEvent;
        }

        @Override
        public void visitDefault(MedicalScribeResultStream event) {
            onDefault.accept(event);
        }

        @Override
        public void visitTranscriptEvent(MedicalScribeTranscriptEvent event) {
            onTranscriptEvent.accept(event);
        }
    }
}
