/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.transcribestreaming.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains entities identified as personally identifiable information (PII) in your transcription output, along with
 * various associated attributes. Examples include category, confidence score, content, type, and start and end times.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CallAnalyticsEntity implements SdkPojo, Serializable,
        ToCopyableBuilder<CallAnalyticsEntity.Builder, CallAnalyticsEntity> {
    private static final SdkField<Long> BEGIN_OFFSET_MILLIS_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("BeginOffsetMillis").getter(getter(CallAnalyticsEntity::beginOffsetMillis))
            .setter(setter(Builder::beginOffsetMillis))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BeginOffsetMillis").build()).build();

    private static final SdkField<Long> END_OFFSET_MILLIS_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("EndOffsetMillis").getter(getter(CallAnalyticsEntity::endOffsetMillis))
            .setter(setter(Builder::endOffsetMillis))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndOffsetMillis").build()).build();

    private static final SdkField<String> CATEGORY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Category").getter(getter(CallAnalyticsEntity::category)).setter(setter(Builder::category))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Category").build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Type")
            .getter(getter(CallAnalyticsEntity::type)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()).build();

    private static final SdkField<String> CONTENT_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Content")
            .getter(getter(CallAnalyticsEntity::content)).setter(setter(Builder::content))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Content").build()).build();

    private static final SdkField<Double> CONFIDENCE_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .memberName("Confidence").getter(getter(CallAnalyticsEntity::confidence)).setter(setter(Builder::confidence))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Confidence").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BEGIN_OFFSET_MILLIS_FIELD,
            END_OFFSET_MILLIS_FIELD, CATEGORY_FIELD, TYPE_FIELD, CONTENT_FIELD, CONFIDENCE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Long beginOffsetMillis;

    private final Long endOffsetMillis;

    private final String category;

    private final String type;

    private final String content;

    private final Double confidence;

    private CallAnalyticsEntity(BuilderImpl builder) {
        this.beginOffsetMillis = builder.beginOffsetMillis;
        this.endOffsetMillis = builder.endOffsetMillis;
        this.category = builder.category;
        this.type = builder.type;
        this.content = builder.content;
        this.confidence = builder.confidence;
    }

    /**
     * <p>
     * The time, in milliseconds, from the beginning of the audio stream to the start of the identified entity.
     * </p>
     * 
     * @return The time, in milliseconds, from the beginning of the audio stream to the start of the identified entity.
     */
    public final Long beginOffsetMillis() {
        return beginOffsetMillis;
    }

    /**
     * <p>
     * The time, in milliseconds, from the beginning of the audio stream to the end of the identified entity.
     * </p>
     * 
     * @return The time, in milliseconds, from the beginning of the audio stream to the end of the identified entity.
     */
    public final Long endOffsetMillis() {
        return endOffsetMillis;
    }

    /**
     * <p>
     * The category of information identified. For example, <code>PII</code>.
     * </p>
     * 
     * @return The category of information identified. For example, <code>PII</code>.
     */
    public final String category() {
        return category;
    }

    /**
     * <p>
     * The type of PII identified. For example, <code>NAME</code> or <code>CREDIT_DEBIT_NUMBER</code>.
     * </p>
     * 
     * @return The type of PII identified. For example, <code>NAME</code> or <code>CREDIT_DEBIT_NUMBER</code>.
     */
    public final String type() {
        return type;
    }

    /**
     * <p>
     * The word or words that represent the identified entity.
     * </p>
     * 
     * @return The word or words that represent the identified entity.
     */
    public final String content() {
        return content;
    }

    /**
     * <p>
     * The confidence score associated with the identification of an entity in your transcript.
     * </p>
     * <p>
     * Confidence scores are values between 0 and 1. A larger value indicates a higher probability that the identified
     * entity correctly matches the entity spoken in your media.
     * </p>
     * 
     * @return The confidence score associated with the identification of an entity in your transcript.</p>
     *         <p>
     *         Confidence scores are values between 0 and 1. A larger value indicates a higher probability that the
     *         identified entity correctly matches the entity spoken in your media.
     */
    public final Double confidence() {
        return confidence;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(beginOffsetMillis());
        hashCode = 31 * hashCode + Objects.hashCode(endOffsetMillis());
        hashCode = 31 * hashCode + Objects.hashCode(category());
        hashCode = 31 * hashCode + Objects.hashCode(type());
        hashCode = 31 * hashCode + Objects.hashCode(content());
        hashCode = 31 * hashCode + Objects.hashCode(confidence());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CallAnalyticsEntity)) {
            return false;
        }
        CallAnalyticsEntity other = (CallAnalyticsEntity) obj;
        return Objects.equals(beginOffsetMillis(), other.beginOffsetMillis())
                && Objects.equals(endOffsetMillis(), other.endOffsetMillis()) && Objects.equals(category(), other.category())
                && Objects.equals(type(), other.type()) && Objects.equals(content(), other.content())
                && Objects.equals(confidence(), other.confidence());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CallAnalyticsEntity").add("BeginOffsetMillis", beginOffsetMillis())
                .add("EndOffsetMillis", endOffsetMillis()).add("Category", category()).add("Type", type())
                .add("Content", content()).add("Confidence", confidence()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "BeginOffsetMillis":
            return Optional.ofNullable(clazz.cast(beginOffsetMillis()));
        case "EndOffsetMillis":
            return Optional.ofNullable(clazz.cast(endOffsetMillis()));
        case "Category":
            return Optional.ofNullable(clazz.cast(category()));
        case "Type":
            return Optional.ofNullable(clazz.cast(type()));
        case "Content":
            return Optional.ofNullable(clazz.cast(content()));
        case "Confidence":
            return Optional.ofNullable(clazz.cast(confidence()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("BeginOffsetMillis", BEGIN_OFFSET_MILLIS_FIELD);
        map.put("EndOffsetMillis", END_OFFSET_MILLIS_FIELD);
        map.put("Category", CATEGORY_FIELD);
        map.put("Type", TYPE_FIELD);
        map.put("Content", CONTENT_FIELD);
        map.put("Confidence", CONFIDENCE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CallAnalyticsEntity, T> g) {
        return obj -> g.apply((CallAnalyticsEntity) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CallAnalyticsEntity> {
        /**
         * <p>
         * The time, in milliseconds, from the beginning of the audio stream to the start of the identified entity.
         * </p>
         * 
         * @param beginOffsetMillis
         *        The time, in milliseconds, from the beginning of the audio stream to the start of the identified
         *        entity.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder beginOffsetMillis(Long beginOffsetMillis);

        /**
         * <p>
         * The time, in milliseconds, from the beginning of the audio stream to the end of the identified entity.
         * </p>
         * 
         * @param endOffsetMillis
         *        The time, in milliseconds, from the beginning of the audio stream to the end of the identified entity.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endOffsetMillis(Long endOffsetMillis);

        /**
         * <p>
         * The category of information identified. For example, <code>PII</code>.
         * </p>
         * 
         * @param category
         *        The category of information identified. For example, <code>PII</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder category(String category);

        /**
         * <p>
         * The type of PII identified. For example, <code>NAME</code> or <code>CREDIT_DEBIT_NUMBER</code>.
         * </p>
         * 
         * @param type
         *        The type of PII identified. For example, <code>NAME</code> or <code>CREDIT_DEBIT_NUMBER</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder type(String type);

        /**
         * <p>
         * The word or words that represent the identified entity.
         * </p>
         * 
         * @param content
         *        The word or words that represent the identified entity.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder content(String content);

        /**
         * <p>
         * The confidence score associated with the identification of an entity in your transcript.
         * </p>
         * <p>
         * Confidence scores are values between 0 and 1. A larger value indicates a higher probability that the
         * identified entity correctly matches the entity spoken in your media.
         * </p>
         * 
         * @param confidence
         *        The confidence score associated with the identification of an entity in your transcript.</p>
         *        <p>
         *        Confidence scores are values between 0 and 1. A larger value indicates a higher probability that the
         *        identified entity correctly matches the entity spoken in your media.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder confidence(Double confidence);
    }

    static final class BuilderImpl implements Builder {
        private Long beginOffsetMillis;

        private Long endOffsetMillis;

        private String category;

        private String type;

        private String content;

        private Double confidence;

        private BuilderImpl() {
        }

        private BuilderImpl(CallAnalyticsEntity model) {
            beginOffsetMillis(model.beginOffsetMillis);
            endOffsetMillis(model.endOffsetMillis);
            category(model.category);
            type(model.type);
            content(model.content);
            confidence(model.confidence);
        }

        public final Long getBeginOffsetMillis() {
            return beginOffsetMillis;
        }

        public final void setBeginOffsetMillis(Long beginOffsetMillis) {
            this.beginOffsetMillis = beginOffsetMillis;
        }

        @Override
        public final Builder beginOffsetMillis(Long beginOffsetMillis) {
            this.beginOffsetMillis = beginOffsetMillis;
            return this;
        }

        public final Long getEndOffsetMillis() {
            return endOffsetMillis;
        }

        public final void setEndOffsetMillis(Long endOffsetMillis) {
            this.endOffsetMillis = endOffsetMillis;
        }

        @Override
        public final Builder endOffsetMillis(Long endOffsetMillis) {
            this.endOffsetMillis = endOffsetMillis;
            return this;
        }

        public final String getCategory() {
            return category;
        }

        public final void setCategory(String category) {
            this.category = category;
        }

        @Override
        public final Builder category(String category) {
            this.category = category;
            return this;
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        public final String getContent() {
            return content;
        }

        public final void setContent(String content) {
            this.content = content;
        }

        @Override
        public final Builder content(String content) {
            this.content = content;
            return this;
        }

        public final Double getConfidence() {
            return confidence;
        }

        public final void setConfidence(Double confidence) {
            this.confidence = confidence;
        }

        @Override
        public final Builder confidence(Double confidence) {
            this.confidence = confidence;
            return this;
        }

        @Override
        public CallAnalyticsEntity build() {
            return new CallAnalyticsEntity(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
