/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.transcribestreaming.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.transcribestreaming.model.MedicalScribeTranscriptItemType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class MedicalScribeTranscriptItem
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, MedicalScribeTranscriptItem> {
    private static final SdkField<Double> BEGIN_AUDIO_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("BeginAudioTime").getter(MedicalScribeTranscriptItem.getter(MedicalScribeTranscriptItem::beginAudioTime)).setter(MedicalScribeTranscriptItem.setter(Builder::beginAudioTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BeginAudioTime").build()}).build();
    private static final SdkField<Double> END_AUDIO_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("EndAudioTime").getter(MedicalScribeTranscriptItem.getter(MedicalScribeTranscriptItem::endAudioTime)).setter(MedicalScribeTranscriptItem.setter(Builder::endAudioTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndAudioTime").build()}).build();
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Type").getter(MedicalScribeTranscriptItem.getter(MedicalScribeTranscriptItem::typeAsString)).setter(MedicalScribeTranscriptItem.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()}).build();
    private static final SdkField<Double> CONFIDENCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("Confidence").getter(MedicalScribeTranscriptItem.getter(MedicalScribeTranscriptItem::confidence)).setter(MedicalScribeTranscriptItem.setter(Builder::confidence)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Confidence").build()}).build();
    private static final SdkField<String> CONTENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Content").getter(MedicalScribeTranscriptItem.getter(MedicalScribeTranscriptItem::content)).setter(MedicalScribeTranscriptItem.setter(Builder::content)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Content").build()}).build();
    private static final SdkField<Boolean> VOCABULARY_FILTER_MATCH_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("VocabularyFilterMatch").getter(MedicalScribeTranscriptItem.getter(MedicalScribeTranscriptItem::vocabularyFilterMatch)).setter(MedicalScribeTranscriptItem.setter(Builder::vocabularyFilterMatch)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VocabularyFilterMatch").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BEGIN_AUDIO_TIME_FIELD, END_AUDIO_TIME_FIELD, TYPE_FIELD, CONFIDENCE_FIELD, CONTENT_FIELD, VOCABULARY_FILTER_MATCH_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = MedicalScribeTranscriptItem.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Double beginAudioTime;
    private final Double endAudioTime;
    private final String type;
    private final Double confidence;
    private final String content;
    private final Boolean vocabularyFilterMatch;

    private MedicalScribeTranscriptItem(BuilderImpl builder) {
        this.beginAudioTime = builder.beginAudioTime;
        this.endAudioTime = builder.endAudioTime;
        this.type = builder.type;
        this.confidence = builder.confidence;
        this.content = builder.content;
        this.vocabularyFilterMatch = builder.vocabularyFilterMatch;
    }

    public final Double beginAudioTime() {
        return this.beginAudioTime;
    }

    public final Double endAudioTime() {
        return this.endAudioTime;
    }

    public final MedicalScribeTranscriptItemType type() {
        return MedicalScribeTranscriptItemType.fromValue(this.type);
    }

    public final String typeAsString() {
        return this.type;
    }

    public final Double confidence() {
        return this.confidence;
    }

    public final String content() {
        return this.content;
    }

    public final Boolean vocabularyFilterMatch() {
        return this.vocabularyFilterMatch;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.beginAudioTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.endAudioTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.confidence());
        hashCode = 31 * hashCode + Objects.hashCode(this.content());
        hashCode = 31 * hashCode + Objects.hashCode(this.vocabularyFilterMatch());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MedicalScribeTranscriptItem)) {
            return false;
        }
        MedicalScribeTranscriptItem other = (MedicalScribeTranscriptItem)obj;
        return Objects.equals(this.beginAudioTime(), other.beginAudioTime()) && Objects.equals(this.endAudioTime(), other.endAudioTime()) && Objects.equals(this.typeAsString(), other.typeAsString()) && Objects.equals(this.confidence(), other.confidence()) && Objects.equals(this.content(), other.content()) && Objects.equals(this.vocabularyFilterMatch(), other.vocabularyFilterMatch());
    }

    public final String toString() {
        return ToString.builder((String)"MedicalScribeTranscriptItem").add("BeginAudioTime", (Object)this.beginAudioTime()).add("EndAudioTime", (Object)this.endAudioTime()).add("Type", (Object)this.typeAsString()).add("Confidence", (Object)this.confidence()).add("Content", (Object)this.content()).add("VocabularyFilterMatch", (Object)this.vocabularyFilterMatch()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "BeginAudioTime": {
                return Optional.ofNullable(clazz.cast(this.beginAudioTime()));
            }
            case "EndAudioTime": {
                return Optional.ofNullable(clazz.cast(this.endAudioTime()));
            }
            case "Type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
            case "Confidence": {
                return Optional.ofNullable(clazz.cast(this.confidence()));
            }
            case "Content": {
                return Optional.ofNullable(clazz.cast(this.content()));
            }
            case "VocabularyFilterMatch": {
                return Optional.ofNullable(clazz.cast(this.vocabularyFilterMatch()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("BeginAudioTime", BEGIN_AUDIO_TIME_FIELD);
        map.put("EndAudioTime", END_AUDIO_TIME_FIELD);
        map.put("Type", TYPE_FIELD);
        map.put("Confidence", CONFIDENCE_FIELD);
        map.put("Content", CONTENT_FIELD);
        map.put("VocabularyFilterMatch", VOCABULARY_FILTER_MATCH_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<MedicalScribeTranscriptItem, T> g) {
        return obj -> g.apply((MedicalScribeTranscriptItem)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Double beginAudioTime;
        private Double endAudioTime;
        private String type;
        private Double confidence;
        private String content;
        private Boolean vocabularyFilterMatch;

        private BuilderImpl() {
        }

        private BuilderImpl(MedicalScribeTranscriptItem model) {
            this.beginAudioTime(model.beginAudioTime);
            this.endAudioTime(model.endAudioTime);
            this.type(model.type);
            this.confidence(model.confidence);
            this.content(model.content);
            this.vocabularyFilterMatch(model.vocabularyFilterMatch);
        }

        public final Double getBeginAudioTime() {
            return this.beginAudioTime;
        }

        public final void setBeginAudioTime(Double beginAudioTime) {
            this.beginAudioTime = beginAudioTime;
        }

        @Override
        public final Builder beginAudioTime(Double beginAudioTime) {
            this.beginAudioTime = beginAudioTime;
            return this;
        }

        public final Double getEndAudioTime() {
            return this.endAudioTime;
        }

        public final void setEndAudioTime(Double endAudioTime) {
            this.endAudioTime = endAudioTime;
        }

        @Override
        public final Builder endAudioTime(Double endAudioTime) {
            this.endAudioTime = endAudioTime;
            return this;
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(MedicalScribeTranscriptItemType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final Double getConfidence() {
            return this.confidence;
        }

        public final void setConfidence(Double confidence) {
            this.confidence = confidence;
        }

        @Override
        public final Builder confidence(Double confidence) {
            this.confidence = confidence;
            return this;
        }

        public final String getContent() {
            return this.content;
        }

        public final void setContent(String content) {
            this.content = content;
        }

        @Override
        public final Builder content(String content) {
            this.content = content;
            return this;
        }

        public final Boolean getVocabularyFilterMatch() {
            return this.vocabularyFilterMatch;
        }

        public final void setVocabularyFilterMatch(Boolean vocabularyFilterMatch) {
            this.vocabularyFilterMatch = vocabularyFilterMatch;
        }

        @Override
        public final Builder vocabularyFilterMatch(Boolean vocabularyFilterMatch) {
            this.vocabularyFilterMatch = vocabularyFilterMatch;
            return this;
        }

        public MedicalScribeTranscriptItem build() {
            return new MedicalScribeTranscriptItem(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, MedicalScribeTranscriptItem> {
        public Builder beginAudioTime(Double var1);

        public Builder endAudioTime(Double var1);

        public Builder type(String var1);

        public Builder type(MedicalScribeTranscriptItemType var1);

        public Builder confidence(Double var1);

        public Builder content(String var1);

        public Builder vocabularyFilterMatch(Boolean var1);
    }
}

