/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.transcribestreaming.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.transcribestreaming.model.MedicalScribeTranscriptItem;
import software.amazon.awssdk.services.transcribestreaming.model.MedicalScribeTranscriptItemListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class MedicalScribeTranscriptSegment
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, MedicalScribeTranscriptSegment> {
    private static final SdkField<String> SEGMENT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SegmentId").getter(MedicalScribeTranscriptSegment.getter(MedicalScribeTranscriptSegment::segmentId)).setter(MedicalScribeTranscriptSegment.setter(Builder::segmentId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SegmentId").build()}).build();
    private static final SdkField<Double> BEGIN_AUDIO_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("BeginAudioTime").getter(MedicalScribeTranscriptSegment.getter(MedicalScribeTranscriptSegment::beginAudioTime)).setter(MedicalScribeTranscriptSegment.setter(Builder::beginAudioTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BeginAudioTime").build()}).build();
    private static final SdkField<Double> END_AUDIO_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("EndAudioTime").getter(MedicalScribeTranscriptSegment.getter(MedicalScribeTranscriptSegment::endAudioTime)).setter(MedicalScribeTranscriptSegment.setter(Builder::endAudioTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndAudioTime").build()}).build();
    private static final SdkField<String> CONTENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Content").getter(MedicalScribeTranscriptSegment.getter(MedicalScribeTranscriptSegment::content)).setter(MedicalScribeTranscriptSegment.setter(Builder::content)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Content").build()}).build();
    private static final SdkField<List<MedicalScribeTranscriptItem>> ITEMS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Items").getter(MedicalScribeTranscriptSegment.getter(MedicalScribeTranscriptSegment::items)).setter(MedicalScribeTranscriptSegment.setter(Builder::items)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Items").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(MedicalScribeTranscriptItem::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Boolean> IS_PARTIAL_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("IsPartial").getter(MedicalScribeTranscriptSegment.getter(MedicalScribeTranscriptSegment::isPartial)).setter(MedicalScribeTranscriptSegment.setter(Builder::isPartial)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IsPartial").build()}).build();
    private static final SdkField<String> CHANNEL_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ChannelId").getter(MedicalScribeTranscriptSegment.getter(MedicalScribeTranscriptSegment::channelId)).setter(MedicalScribeTranscriptSegment.setter(Builder::channelId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ChannelId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SEGMENT_ID_FIELD, BEGIN_AUDIO_TIME_FIELD, END_AUDIO_TIME_FIELD, CONTENT_FIELD, ITEMS_FIELD, IS_PARTIAL_FIELD, CHANNEL_ID_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = MedicalScribeTranscriptSegment.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String segmentId;
    private final Double beginAudioTime;
    private final Double endAudioTime;
    private final String content;
    private final List<MedicalScribeTranscriptItem> items;
    private final Boolean isPartial;
    private final String channelId;

    private MedicalScribeTranscriptSegment(BuilderImpl builder) {
        this.segmentId = builder.segmentId;
        this.beginAudioTime = builder.beginAudioTime;
        this.endAudioTime = builder.endAudioTime;
        this.content = builder.content;
        this.items = builder.items;
        this.isPartial = builder.isPartial;
        this.channelId = builder.channelId;
    }

    public final String segmentId() {
        return this.segmentId;
    }

    public final Double beginAudioTime() {
        return this.beginAudioTime;
    }

    public final Double endAudioTime() {
        return this.endAudioTime;
    }

    public final String content() {
        return this.content;
    }

    public final boolean hasItems() {
        return this.items != null && !(this.items instanceof SdkAutoConstructList);
    }

    public final List<MedicalScribeTranscriptItem> items() {
        return this.items;
    }

    public final Boolean isPartial() {
        return this.isPartial;
    }

    public final String channelId() {
        return this.channelId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.segmentId());
        hashCode = 31 * hashCode + Objects.hashCode(this.beginAudioTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.endAudioTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.content());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasItems() ? this.items() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.isPartial());
        hashCode = 31 * hashCode + Objects.hashCode(this.channelId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MedicalScribeTranscriptSegment)) {
            return false;
        }
        MedicalScribeTranscriptSegment other = (MedicalScribeTranscriptSegment)obj;
        return Objects.equals(this.segmentId(), other.segmentId()) && Objects.equals(this.beginAudioTime(), other.beginAudioTime()) && Objects.equals(this.endAudioTime(), other.endAudioTime()) && Objects.equals(this.content(), other.content()) && this.hasItems() == other.hasItems() && Objects.equals(this.items(), other.items()) && Objects.equals(this.isPartial(), other.isPartial()) && Objects.equals(this.channelId(), other.channelId());
    }

    public final String toString() {
        return ToString.builder((String)"MedicalScribeTranscriptSegment").add("SegmentId", (Object)this.segmentId()).add("BeginAudioTime", (Object)this.beginAudioTime()).add("EndAudioTime", (Object)this.endAudioTime()).add("Content", (Object)this.content()).add("Items", this.hasItems() ? this.items() : null).add("IsPartial", (Object)this.isPartial()).add("ChannelId", (Object)this.channelId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SegmentId": {
                return Optional.ofNullable(clazz.cast(this.segmentId()));
            }
            case "BeginAudioTime": {
                return Optional.ofNullable(clazz.cast(this.beginAudioTime()));
            }
            case "EndAudioTime": {
                return Optional.ofNullable(clazz.cast(this.endAudioTime()));
            }
            case "Content": {
                return Optional.ofNullable(clazz.cast(this.content()));
            }
            case "Items": {
                return Optional.ofNullable(clazz.cast(this.items()));
            }
            case "IsPartial": {
                return Optional.ofNullable(clazz.cast(this.isPartial()));
            }
            case "ChannelId": {
                return Optional.ofNullable(clazz.cast(this.channelId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("SegmentId", SEGMENT_ID_FIELD);
        map.put("BeginAudioTime", BEGIN_AUDIO_TIME_FIELD);
        map.put("EndAudioTime", END_AUDIO_TIME_FIELD);
        map.put("Content", CONTENT_FIELD);
        map.put("Items", ITEMS_FIELD);
        map.put("IsPartial", IS_PARTIAL_FIELD);
        map.put("ChannelId", CHANNEL_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<MedicalScribeTranscriptSegment, T> g) {
        return obj -> g.apply((MedicalScribeTranscriptSegment)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String segmentId;
        private Double beginAudioTime;
        private Double endAudioTime;
        private String content;
        private List<MedicalScribeTranscriptItem> items = DefaultSdkAutoConstructList.getInstance();
        private Boolean isPartial;
        private String channelId;

        private BuilderImpl() {
        }

        private BuilderImpl(MedicalScribeTranscriptSegment model) {
            this.segmentId(model.segmentId);
            this.beginAudioTime(model.beginAudioTime);
            this.endAudioTime(model.endAudioTime);
            this.content(model.content);
            this.items(model.items);
            this.isPartial(model.isPartial);
            this.channelId(model.channelId);
        }

        public final String getSegmentId() {
            return this.segmentId;
        }

        public final void setSegmentId(String segmentId) {
            this.segmentId = segmentId;
        }

        @Override
        public final Builder segmentId(String segmentId) {
            this.segmentId = segmentId;
            return this;
        }

        public final Double getBeginAudioTime() {
            return this.beginAudioTime;
        }

        public final void setBeginAudioTime(Double beginAudioTime) {
            this.beginAudioTime = beginAudioTime;
        }

        @Override
        public final Builder beginAudioTime(Double beginAudioTime) {
            this.beginAudioTime = beginAudioTime;
            return this;
        }

        public final Double getEndAudioTime() {
            return this.endAudioTime;
        }

        public final void setEndAudioTime(Double endAudioTime) {
            this.endAudioTime = endAudioTime;
        }

        @Override
        public final Builder endAudioTime(Double endAudioTime) {
            this.endAudioTime = endAudioTime;
            return this;
        }

        public final String getContent() {
            return this.content;
        }

        public final void setContent(String content) {
            this.content = content;
        }

        @Override
        public final Builder content(String content) {
            this.content = content;
            return this;
        }

        public final List<MedicalScribeTranscriptItem.Builder> getItems() {
            List<MedicalScribeTranscriptItem.Builder> result = MedicalScribeTranscriptItemListCopier.copyToBuilder(this.items);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setItems(Collection<MedicalScribeTranscriptItem.BuilderImpl> items) {
            this.items = MedicalScribeTranscriptItemListCopier.copyFromBuilder(items);
        }

        @Override
        public final Builder items(Collection<MedicalScribeTranscriptItem> items) {
            this.items = MedicalScribeTranscriptItemListCopier.copy(items);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder items(MedicalScribeTranscriptItem ... items) {
            this.items(Arrays.asList(items));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder items(Consumer<MedicalScribeTranscriptItem.Builder> ... items) {
            this.items(Stream.of(items).map(c -> (MedicalScribeTranscriptItem)((MedicalScribeTranscriptItem.Builder)MedicalScribeTranscriptItem.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Boolean getIsPartial() {
            return this.isPartial;
        }

        public final void setIsPartial(Boolean isPartial) {
            this.isPartial = isPartial;
        }

        @Override
        public final Builder isPartial(Boolean isPartial) {
            this.isPartial = isPartial;
            return this;
        }

        public final String getChannelId() {
            return this.channelId;
        }

        public final void setChannelId(String channelId) {
            this.channelId = channelId;
        }

        @Override
        public final Builder channelId(String channelId) {
            this.channelId = channelId;
            return this;
        }

        public MedicalScribeTranscriptSegment build() {
            return new MedicalScribeTranscriptSegment(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, MedicalScribeTranscriptSegment> {
        public Builder segmentId(String var1);

        public Builder beginAudioTime(Double var1);

        public Builder endAudioTime(Double var1);

        public Builder content(String var1);

        public Builder items(Collection<MedicalScribeTranscriptItem> var1);

        public Builder items(MedicalScribeTranscriptItem ... var1);

        public Builder items(Consumer<MedicalScribeTranscriptItem.Builder> ... var1);

        public Builder isPartial(Boolean var1);

        public Builder channelId(String var1);
    }
}

