/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.transcribestreaming.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.transcribestreaming.model.CallAnalyticsEntity;
import software.amazon.awssdk.services.transcribestreaming.model.CallAnalyticsEntityListCopier;
import software.amazon.awssdk.services.transcribestreaming.model.CallAnalyticsItem;
import software.amazon.awssdk.services.transcribestreaming.model.CallAnalyticsItemListCopier;
import software.amazon.awssdk.services.transcribestreaming.model.CallAnalyticsTranscriptResultStream;
import software.amazon.awssdk.services.transcribestreaming.model.IssueDetected;
import software.amazon.awssdk.services.transcribestreaming.model.IssuesDetectedCopier;
import software.amazon.awssdk.services.transcribestreaming.model.ParticipantRole;
import software.amazon.awssdk.services.transcribestreaming.model.Sentiment;
import software.amazon.awssdk.services.transcribestreaming.model.StartCallAnalyticsStreamTranscriptionResponseHandler;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class UtteranceEvent
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, UtteranceEvent>,
CallAnalyticsTranscriptResultStream {
    private static final SdkField<String> UTTERANCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("UtteranceId").getter(UtteranceEvent.getter(UtteranceEvent::utteranceId)).setter(UtteranceEvent.setter(Builder::utteranceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UtteranceId").build()}).build();
    private static final SdkField<Boolean> IS_PARTIAL_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("IsPartial").getter(UtteranceEvent.getter(UtteranceEvent::isPartial)).setter(UtteranceEvent.setter(Builder::isPartial)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IsPartial").build()}).build();
    private static final SdkField<String> PARTICIPANT_ROLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ParticipantRole").getter(UtteranceEvent.getter(UtteranceEvent::participantRoleAsString)).setter(UtteranceEvent.setter(Builder::participantRole)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ParticipantRole").build()}).build();
    private static final SdkField<Long> BEGIN_OFFSET_MILLIS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("BeginOffsetMillis").getter(UtteranceEvent.getter(UtteranceEvent::beginOffsetMillis)).setter(UtteranceEvent.setter(Builder::beginOffsetMillis)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BeginOffsetMillis").build()}).build();
    private static final SdkField<Long> END_OFFSET_MILLIS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("EndOffsetMillis").getter(UtteranceEvent.getter(UtteranceEvent::endOffsetMillis)).setter(UtteranceEvent.setter(Builder::endOffsetMillis)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndOffsetMillis").build()}).build();
    private static final SdkField<String> TRANSCRIPT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Transcript").getter(UtteranceEvent.getter(UtteranceEvent::transcript)).setter(UtteranceEvent.setter(Builder::transcript)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Transcript").build()}).build();
    private static final SdkField<List<CallAnalyticsItem>> ITEMS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Items").getter(UtteranceEvent.getter(UtteranceEvent::items)).setter(UtteranceEvent.setter(Builder::items)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Items").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(CallAnalyticsItem::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<CallAnalyticsEntity>> ENTITIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Entities").getter(UtteranceEvent.getter(UtteranceEvent::entities)).setter(UtteranceEvent.setter(Builder::entities)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Entities").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(CallAnalyticsEntity::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> SENTIMENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Sentiment").getter(UtteranceEvent.getter(UtteranceEvent::sentimentAsString)).setter(UtteranceEvent.setter(Builder::sentiment)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Sentiment").build()}).build();
    private static final SdkField<List<IssueDetected>> ISSUES_DETECTED_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("IssuesDetected").getter(UtteranceEvent.getter(UtteranceEvent::issuesDetected)).setter(UtteranceEvent.setter(Builder::issuesDetected)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IssuesDetected").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(IssueDetected::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(UTTERANCE_ID_FIELD, IS_PARTIAL_FIELD, PARTICIPANT_ROLE_FIELD, BEGIN_OFFSET_MILLIS_FIELD, END_OFFSET_MILLIS_FIELD, TRANSCRIPT_FIELD, ITEMS_FIELD, ENTITIES_FIELD, SENTIMENT_FIELD, ISSUES_DETECTED_FIELD));
    private static final long serialVersionUID = 1L;
    private final String utteranceId;
    private final Boolean isPartial;
    private final String participantRole;
    private final Long beginOffsetMillis;
    private final Long endOffsetMillis;
    private final String transcript;
    private final List<CallAnalyticsItem> items;
    private final List<CallAnalyticsEntity> entities;
    private final String sentiment;
    private final List<IssueDetected> issuesDetected;

    protected UtteranceEvent(BuilderImpl builder) {
        this.utteranceId = builder.utteranceId;
        this.isPartial = builder.isPartial;
        this.participantRole = builder.participantRole;
        this.beginOffsetMillis = builder.beginOffsetMillis;
        this.endOffsetMillis = builder.endOffsetMillis;
        this.transcript = builder.transcript;
        this.items = builder.items;
        this.entities = builder.entities;
        this.sentiment = builder.sentiment;
        this.issuesDetected = builder.issuesDetected;
    }

    public final String utteranceId() {
        return this.utteranceId;
    }

    public final Boolean isPartial() {
        return this.isPartial;
    }

    public final ParticipantRole participantRole() {
        return ParticipantRole.fromValue(this.participantRole);
    }

    public final String participantRoleAsString() {
        return this.participantRole;
    }

    public final Long beginOffsetMillis() {
        return this.beginOffsetMillis;
    }

    public final Long endOffsetMillis() {
        return this.endOffsetMillis;
    }

    public final String transcript() {
        return this.transcript;
    }

    public final boolean hasItems() {
        return this.items != null && !(this.items instanceof SdkAutoConstructList);
    }

    public final List<CallAnalyticsItem> items() {
        return this.items;
    }

    public final boolean hasEntities() {
        return this.entities != null && !(this.entities instanceof SdkAutoConstructList);
    }

    public final List<CallAnalyticsEntity> entities() {
        return this.entities;
    }

    public final Sentiment sentiment() {
        return Sentiment.fromValue(this.sentiment);
    }

    public final String sentimentAsString() {
        return this.sentiment;
    }

    public final boolean hasIssuesDetected() {
        return this.issuesDetected != null && !(this.issuesDetected instanceof SdkAutoConstructList);
    }

    public final List<IssueDetected> issuesDetected() {
        return this.issuesDetected;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.utteranceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.isPartial());
        hashCode = 31 * hashCode + Objects.hashCode(this.participantRoleAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.beginOffsetMillis());
        hashCode = 31 * hashCode + Objects.hashCode(this.endOffsetMillis());
        hashCode = 31 * hashCode + Objects.hashCode(this.transcript());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasItems() ? this.items() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasEntities() ? this.entities() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.sentimentAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasIssuesDetected() ? this.issuesDetected() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UtteranceEvent)) {
            return false;
        }
        UtteranceEvent other = (UtteranceEvent)obj;
        return Objects.equals(this.utteranceId(), other.utteranceId()) && Objects.equals(this.isPartial(), other.isPartial()) && Objects.equals(this.participantRoleAsString(), other.participantRoleAsString()) && Objects.equals(this.beginOffsetMillis(), other.beginOffsetMillis()) && Objects.equals(this.endOffsetMillis(), other.endOffsetMillis()) && Objects.equals(this.transcript(), other.transcript()) && this.hasItems() == other.hasItems() && Objects.equals(this.items(), other.items()) && this.hasEntities() == other.hasEntities() && Objects.equals(this.entities(), other.entities()) && Objects.equals(this.sentimentAsString(), other.sentimentAsString()) && this.hasIssuesDetected() == other.hasIssuesDetected() && Objects.equals(this.issuesDetected(), other.issuesDetected());
    }

    public final String toString() {
        return ToString.builder((String)"UtteranceEvent").add("UtteranceId", (Object)this.utteranceId()).add("IsPartial", (Object)this.isPartial()).add("ParticipantRole", (Object)this.participantRoleAsString()).add("BeginOffsetMillis", (Object)this.beginOffsetMillis()).add("EndOffsetMillis", (Object)this.endOffsetMillis()).add("Transcript", (Object)this.transcript()).add("Items", this.hasItems() ? this.items() : null).add("Entities", this.hasEntities() ? this.entities() : null).add("Sentiment", (Object)this.sentimentAsString()).add("IssuesDetected", this.hasIssuesDetected() ? this.issuesDetected() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "UtteranceId": {
                return Optional.ofNullable(clazz.cast(this.utteranceId()));
            }
            case "IsPartial": {
                return Optional.ofNullable(clazz.cast(this.isPartial()));
            }
            case "ParticipantRole": {
                return Optional.ofNullable(clazz.cast(this.participantRoleAsString()));
            }
            case "BeginOffsetMillis": {
                return Optional.ofNullable(clazz.cast(this.beginOffsetMillis()));
            }
            case "EndOffsetMillis": {
                return Optional.ofNullable(clazz.cast(this.endOffsetMillis()));
            }
            case "Transcript": {
                return Optional.ofNullable(clazz.cast(this.transcript()));
            }
            case "Items": {
                return Optional.ofNullable(clazz.cast(this.items()));
            }
            case "Entities": {
                return Optional.ofNullable(clazz.cast(this.entities()));
            }
            case "Sentiment": {
                return Optional.ofNullable(clazz.cast(this.sentimentAsString()));
            }
            case "IssuesDetected": {
                return Optional.ofNullable(clazz.cast(this.issuesDetected()));
            }
        }
        return Optional.empty();
    }

    public final UtteranceEvent copy(Consumer<? super Builder> modifier) {
        return (UtteranceEvent)super.copy(modifier);
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UtteranceEvent, T> g) {
        return obj -> g.apply((UtteranceEvent)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    @Override
    public void accept(StartCallAnalyticsStreamTranscriptionResponseHandler.Visitor visitor) {
        throw new UnsupportedOperationException();
    }

    protected static class BuilderImpl
    implements Builder {
        private String utteranceId;
        private Boolean isPartial;
        private String participantRole;
        private Long beginOffsetMillis;
        private Long endOffsetMillis;
        private String transcript;
        private List<CallAnalyticsItem> items = DefaultSdkAutoConstructList.getInstance();
        private List<CallAnalyticsEntity> entities = DefaultSdkAutoConstructList.getInstance();
        private String sentiment;
        private List<IssueDetected> issuesDetected = DefaultSdkAutoConstructList.getInstance();

        protected BuilderImpl() {
        }

        protected BuilderImpl(UtteranceEvent model) {
            this.utteranceId(model.utteranceId);
            this.isPartial(model.isPartial);
            this.participantRole(model.participantRole);
            this.beginOffsetMillis(model.beginOffsetMillis);
            this.endOffsetMillis(model.endOffsetMillis);
            this.transcript(model.transcript);
            this.items(model.items);
            this.entities(model.entities);
            this.sentiment(model.sentiment);
            this.issuesDetected(model.issuesDetected);
        }

        public final String getUtteranceId() {
            return this.utteranceId;
        }

        public final void setUtteranceId(String utteranceId) {
            this.utteranceId = utteranceId;
        }

        @Override
        public final Builder utteranceId(String utteranceId) {
            this.utteranceId = utteranceId;
            return this;
        }

        public final Boolean getIsPartial() {
            return this.isPartial;
        }

        public final void setIsPartial(Boolean isPartial) {
            this.isPartial = isPartial;
        }

        @Override
        public final Builder isPartial(Boolean isPartial) {
            this.isPartial = isPartial;
            return this;
        }

        public final String getParticipantRole() {
            return this.participantRole;
        }

        public final void setParticipantRole(String participantRole) {
            this.participantRole = participantRole;
        }

        @Override
        public final Builder participantRole(String participantRole) {
            this.participantRole = participantRole;
            return this;
        }

        @Override
        public final Builder participantRole(ParticipantRole participantRole) {
            this.participantRole(participantRole == null ? null : participantRole.toString());
            return this;
        }

        public final Long getBeginOffsetMillis() {
            return this.beginOffsetMillis;
        }

        public final void setBeginOffsetMillis(Long beginOffsetMillis) {
            this.beginOffsetMillis = beginOffsetMillis;
        }

        @Override
        public final Builder beginOffsetMillis(Long beginOffsetMillis) {
            this.beginOffsetMillis = beginOffsetMillis;
            return this;
        }

        public final Long getEndOffsetMillis() {
            return this.endOffsetMillis;
        }

        public final void setEndOffsetMillis(Long endOffsetMillis) {
            this.endOffsetMillis = endOffsetMillis;
        }

        @Override
        public final Builder endOffsetMillis(Long endOffsetMillis) {
            this.endOffsetMillis = endOffsetMillis;
            return this;
        }

        public final String getTranscript() {
            return this.transcript;
        }

        public final void setTranscript(String transcript) {
            this.transcript = transcript;
        }

        @Override
        public final Builder transcript(String transcript) {
            this.transcript = transcript;
            return this;
        }

        public final List<CallAnalyticsItem.Builder> getItems() {
            List<CallAnalyticsItem.Builder> result = CallAnalyticsItemListCopier.copyToBuilder(this.items);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setItems(Collection<CallAnalyticsItem.BuilderImpl> items) {
            this.items = CallAnalyticsItemListCopier.copyFromBuilder(items);
        }

        @Override
        public final Builder items(Collection<CallAnalyticsItem> items) {
            this.items = CallAnalyticsItemListCopier.copy(items);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder items(CallAnalyticsItem ... items) {
            this.items(Arrays.asList(items));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder items(Consumer<CallAnalyticsItem.Builder> ... items) {
            this.items(Stream.of(items).map(c -> (CallAnalyticsItem)((CallAnalyticsItem.Builder)CallAnalyticsItem.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<CallAnalyticsEntity.Builder> getEntities() {
            List<CallAnalyticsEntity.Builder> result = CallAnalyticsEntityListCopier.copyToBuilder(this.entities);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setEntities(Collection<CallAnalyticsEntity.BuilderImpl> entities) {
            this.entities = CallAnalyticsEntityListCopier.copyFromBuilder(entities);
        }

        @Override
        public final Builder entities(Collection<CallAnalyticsEntity> entities) {
            this.entities = CallAnalyticsEntityListCopier.copy(entities);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder entities(CallAnalyticsEntity ... entities) {
            this.entities(Arrays.asList(entities));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder entities(Consumer<CallAnalyticsEntity.Builder> ... entities) {
            this.entities(Stream.of(entities).map(c -> (CallAnalyticsEntity)((CallAnalyticsEntity.Builder)CallAnalyticsEntity.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getSentiment() {
            return this.sentiment;
        }

        public final void setSentiment(String sentiment) {
            this.sentiment = sentiment;
        }

        @Override
        public final Builder sentiment(String sentiment) {
            this.sentiment = sentiment;
            return this;
        }

        @Override
        public final Builder sentiment(Sentiment sentiment) {
            this.sentiment(sentiment == null ? null : sentiment.toString());
            return this;
        }

        public final List<IssueDetected.Builder> getIssuesDetected() {
            List<IssueDetected.Builder> result = IssuesDetectedCopier.copyToBuilder(this.issuesDetected);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setIssuesDetected(Collection<IssueDetected.BuilderImpl> issuesDetected) {
            this.issuesDetected = IssuesDetectedCopier.copyFromBuilder(issuesDetected);
        }

        @Override
        public final Builder issuesDetected(Collection<IssueDetected> issuesDetected) {
            this.issuesDetected = IssuesDetectedCopier.copy(issuesDetected);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder issuesDetected(IssueDetected ... issuesDetected) {
            this.issuesDetected(Arrays.asList(issuesDetected));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder issuesDetected(Consumer<IssueDetected.Builder> ... issuesDetected) {
            this.issuesDetected(Stream.of(issuesDetected).map(c -> (IssueDetected)((IssueDetected.Builder)IssueDetected.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public UtteranceEvent build() {
            return new UtteranceEvent(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, UtteranceEvent> {
        public Builder utteranceId(String var1);

        public Builder isPartial(Boolean var1);

        public Builder participantRole(String var1);

        public Builder participantRole(ParticipantRole var1);

        public Builder beginOffsetMillis(Long var1);

        public Builder endOffsetMillis(Long var1);

        public Builder transcript(String var1);

        public Builder items(Collection<CallAnalyticsItem> var1);

        public Builder items(CallAnalyticsItem ... var1);

        public Builder items(Consumer<CallAnalyticsItem.Builder> ... var1);

        public Builder entities(Collection<CallAnalyticsEntity> var1);

        public Builder entities(CallAnalyticsEntity ... var1);

        public Builder entities(Consumer<CallAnalyticsEntity.Builder> ... var1);

        public Builder sentiment(String var1);

        public Builder sentiment(Sentiment var1);

        public Builder issuesDetected(Collection<IssueDetected> var1);

        public Builder issuesDetected(IssueDetected ... var1);

        public Builder issuesDetected(Consumer<IssueDetected.Builder> ... var1);
    }
}

