/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.transcribestreaming;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.endpoints.EndpointProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.transcribestreaming.DefaultTranscribeStreamingAsyncClient;
import software.amazon.awssdk.services.transcribestreaming.DefaultTranscribeStreamingBaseClientBuilder;
import software.amazon.awssdk.services.transcribestreaming.TranscribeStreamingAsyncClient;
import software.amazon.awssdk.services.transcribestreaming.TranscribeStreamingAsyncClientBuilder;
import software.amazon.awssdk.services.transcribestreaming.TranscribeStreamingServiceClientConfiguration;
import software.amazon.awssdk.services.transcribestreaming.endpoints.TranscribeStreamingEndpointProvider;

@SdkInternalApi
final class DefaultTranscribeStreamingAsyncClientBuilder
extends DefaultTranscribeStreamingBaseClientBuilder<TranscribeStreamingAsyncClientBuilder, TranscribeStreamingAsyncClient>
implements TranscribeStreamingAsyncClientBuilder {
    DefaultTranscribeStreamingAsyncClientBuilder() {
    }

    @Override
    public DefaultTranscribeStreamingAsyncClientBuilder endpointProvider(TranscribeStreamingEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final TranscribeStreamingAsyncClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.asyncClientConfiguration();
        DefaultTranscribeStreamingAsyncClientBuilder.validateClientOptions(clientConfiguration);
        TranscribeStreamingServiceClientConfiguration serviceClientConfiguration = this.initializeServiceClientConfig(clientConfiguration);
        DefaultTranscribeStreamingAsyncClient client = new DefaultTranscribeStreamingAsyncClient(serviceClientConfiguration, clientConfiguration);
        return client;
    }

    private TranscribeStreamingServiceClientConfiguration initializeServiceClientConfig(SdkClientConfiguration clientConfig) {
        URI endpointOverride = null;
        EndpointProvider endpointProvider = (EndpointProvider)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER);
        if (clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN) != null && Boolean.TRUE.equals(clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        return TranscribeStreamingServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfig.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).endpointProvider(endpointProvider).build();
    }
}

