/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.transcribestreaming.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.http.SdkHttpFullRequest;
import software.amazon.awssdk.http.SdkHttpMethod;
import software.amazon.awssdk.protocols.core.OperationInfo;
import software.amazon.awssdk.protocols.core.ProtocolMarshaller;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.services.transcribestreaming.model.AudioEvent;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class AudioEventMarshaller
implements Marshaller<AudioEvent> {
    private static final OperationInfo SDK_OPERATION_BINDING = OperationInfo.builder().hasExplicitPayloadMember(true).hasPayloadMembers(true).httpMethod(SdkHttpMethod.GET).hasEvent(true).build();
    private final BaseAwsJsonProtocolFactory protocolFactory;

    public AudioEventMarshaller(BaseAwsJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    public SdkHttpFullRequest marshall(AudioEvent audioEvent) {
        Validate.paramNotNull((Object)audioEvent, (String)"audioEvent");
        try {
            ProtocolMarshaller protocolMarshaller = this.protocolFactory.createProtocolMarshaller(SDK_OPERATION_BINDING);
            return ((SdkHttpFullRequest)protocolMarshaller.marshall((SdkPojo)audioEvent)).toBuilder().putHeader(":message-type", "event").putHeader(":event-type", audioEvent.sdkEventType().toString()).putHeader(":content-type", "application/octet-stream").build();
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

