/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.transcribestreaming.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.transcribestreaming.model.LanguageCode;
import software.amazon.awssdk.services.transcribestreaming.model.MediaEncoding;
import software.amazon.awssdk.services.transcribestreaming.model.TranscribeStreamingResponse;
import software.amazon.awssdk.services.transcribestreaming.model.VocabularyFilterMethod;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class StartStreamTranscriptionResponse
extends TranscribeStreamingResponse
implements ToCopyableBuilder<Builder, StartStreamTranscriptionResponse> {
    private static final SdkField<String> REQUEST_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RequestId").getter(StartStreamTranscriptionResponse.getter(StartStreamTranscriptionResponse::requestId)).setter(StartStreamTranscriptionResponse.setter(Builder::requestId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.HEADER).locationName("x-amzn-request-id").build()}).build();
    private static final SdkField<String> LANGUAGE_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LanguageCode").getter(StartStreamTranscriptionResponse.getter(StartStreamTranscriptionResponse::languageCodeAsString)).setter(StartStreamTranscriptionResponse.setter(Builder::languageCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.HEADER).locationName("x-amzn-transcribe-language-code").build()}).build();
    private static final SdkField<Integer> MEDIA_SAMPLE_RATE_HERTZ_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MediaSampleRateHertz").getter(StartStreamTranscriptionResponse.getter(StartStreamTranscriptionResponse::mediaSampleRateHertz)).setter(StartStreamTranscriptionResponse.setter(Builder::mediaSampleRateHertz)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.HEADER).locationName("x-amzn-transcribe-sample-rate").build()}).build();
    private static final SdkField<String> MEDIA_ENCODING_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MediaEncoding").getter(StartStreamTranscriptionResponse.getter(StartStreamTranscriptionResponse::mediaEncodingAsString)).setter(StartStreamTranscriptionResponse.setter(Builder::mediaEncoding)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.HEADER).locationName("x-amzn-transcribe-media-encoding").build()}).build();
    private static final SdkField<String> VOCABULARY_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("VocabularyName").getter(StartStreamTranscriptionResponse.getter(StartStreamTranscriptionResponse::vocabularyName)).setter(StartStreamTranscriptionResponse.setter(Builder::vocabularyName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.HEADER).locationName("x-amzn-transcribe-vocabulary-name").build()}).build();
    private static final SdkField<String> SESSION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SessionId").getter(StartStreamTranscriptionResponse.getter(StartStreamTranscriptionResponse::sessionId)).setter(StartStreamTranscriptionResponse.setter(Builder::sessionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.HEADER).locationName("x-amzn-transcribe-session-id").build()}).build();
    private static final SdkField<String> VOCABULARY_FILTER_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("VocabularyFilterName").getter(StartStreamTranscriptionResponse.getter(StartStreamTranscriptionResponse::vocabularyFilterName)).setter(StartStreamTranscriptionResponse.setter(Builder::vocabularyFilterName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.HEADER).locationName("x-amzn-transcribe-vocabulary-filter-name").build()}).build();
    private static final SdkField<String> VOCABULARY_FILTER_METHOD_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("VocabularyFilterMethod").getter(StartStreamTranscriptionResponse.getter(StartStreamTranscriptionResponse::vocabularyFilterMethodAsString)).setter(StartStreamTranscriptionResponse.setter(Builder::vocabularyFilterMethod)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.HEADER).locationName("x-amzn-transcribe-vocabulary-filter-method").build()}).build();
    private static final SdkField<Boolean> SHOW_SPEAKER_LABEL_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("ShowSpeakerLabel").getter(StartStreamTranscriptionResponse.getter(StartStreamTranscriptionResponse::showSpeakerLabel)).setter(StartStreamTranscriptionResponse.setter(Builder::showSpeakerLabel)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.HEADER).locationName("x-amzn-transcribe-show-speaker-label").build()}).build();
    private static final SdkField<Boolean> ENABLE_CHANNEL_IDENTIFICATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("EnableChannelIdentification").getter(StartStreamTranscriptionResponse.getter(StartStreamTranscriptionResponse::enableChannelIdentification)).setter(StartStreamTranscriptionResponse.setter(Builder::enableChannelIdentification)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.HEADER).locationName("x-amzn-transcribe-enable-channel-identification").build()}).build();
    private static final SdkField<Integer> NUMBER_OF_CHANNELS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("NumberOfChannels").getter(StartStreamTranscriptionResponse.getter(StartStreamTranscriptionResponse::numberOfChannels)).setter(StartStreamTranscriptionResponse.setter(Builder::numberOfChannels)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.HEADER).locationName("x-amzn-transcribe-number-of-channels").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REQUEST_ID_FIELD, LANGUAGE_CODE_FIELD, MEDIA_SAMPLE_RATE_HERTZ_FIELD, MEDIA_ENCODING_FIELD, VOCABULARY_NAME_FIELD, SESSION_ID_FIELD, VOCABULARY_FILTER_NAME_FIELD, VOCABULARY_FILTER_METHOD_FIELD, SHOW_SPEAKER_LABEL_FIELD, ENABLE_CHANNEL_IDENTIFICATION_FIELD, NUMBER_OF_CHANNELS_FIELD));
    private final String requestId;
    private final String languageCode;
    private final Integer mediaSampleRateHertz;
    private final String mediaEncoding;
    private final String vocabularyName;
    private final String sessionId;
    private final String vocabularyFilterName;
    private final String vocabularyFilterMethod;
    private final Boolean showSpeakerLabel;
    private final Boolean enableChannelIdentification;
    private final Integer numberOfChannels;

    private StartStreamTranscriptionResponse(BuilderImpl builder) {
        super(builder);
        this.requestId = builder.requestId;
        this.languageCode = builder.languageCode;
        this.mediaSampleRateHertz = builder.mediaSampleRateHertz;
        this.mediaEncoding = builder.mediaEncoding;
        this.vocabularyName = builder.vocabularyName;
        this.sessionId = builder.sessionId;
        this.vocabularyFilterName = builder.vocabularyFilterName;
        this.vocabularyFilterMethod = builder.vocabularyFilterMethod;
        this.showSpeakerLabel = builder.showSpeakerLabel;
        this.enableChannelIdentification = builder.enableChannelIdentification;
        this.numberOfChannels = builder.numberOfChannels;
    }

    public final String requestId() {
        return this.requestId;
    }

    public final LanguageCode languageCode() {
        return LanguageCode.fromValue(this.languageCode);
    }

    public final String languageCodeAsString() {
        return this.languageCode;
    }

    public final Integer mediaSampleRateHertz() {
        return this.mediaSampleRateHertz;
    }

    public final MediaEncoding mediaEncoding() {
        return MediaEncoding.fromValue(this.mediaEncoding);
    }

    public final String mediaEncodingAsString() {
        return this.mediaEncoding;
    }

    public final String vocabularyName() {
        return this.vocabularyName;
    }

    public final String sessionId() {
        return this.sessionId;
    }

    public final String vocabularyFilterName() {
        return this.vocabularyFilterName;
    }

    public final VocabularyFilterMethod vocabularyFilterMethod() {
        return VocabularyFilterMethod.fromValue(this.vocabularyFilterMethod);
    }

    public final String vocabularyFilterMethodAsString() {
        return this.vocabularyFilterMethod;
    }

    public final Boolean showSpeakerLabel() {
        return this.showSpeakerLabel;
    }

    public final Boolean enableChannelIdentification() {
        return this.enableChannelIdentification;
    }

    public final Integer numberOfChannels() {
        return this.numberOfChannels;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.requestId());
        hashCode = 31 * hashCode + Objects.hashCode(this.languageCodeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.mediaSampleRateHertz());
        hashCode = 31 * hashCode + Objects.hashCode(this.mediaEncodingAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.vocabularyName());
        hashCode = 31 * hashCode + Objects.hashCode(this.sessionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.vocabularyFilterName());
        hashCode = 31 * hashCode + Objects.hashCode(this.vocabularyFilterMethodAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.showSpeakerLabel());
        hashCode = 31 * hashCode + Objects.hashCode(this.enableChannelIdentification());
        hashCode = 31 * hashCode + Objects.hashCode(this.numberOfChannels());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartStreamTranscriptionResponse)) {
            return false;
        }
        StartStreamTranscriptionResponse other = (StartStreamTranscriptionResponse)((Object)obj);
        return Objects.equals(this.requestId(), other.requestId()) && Objects.equals(this.languageCodeAsString(), other.languageCodeAsString()) && Objects.equals(this.mediaSampleRateHertz(), other.mediaSampleRateHertz()) && Objects.equals(this.mediaEncodingAsString(), other.mediaEncodingAsString()) && Objects.equals(this.vocabularyName(), other.vocabularyName()) && Objects.equals(this.sessionId(), other.sessionId()) && Objects.equals(this.vocabularyFilterName(), other.vocabularyFilterName()) && Objects.equals(this.vocabularyFilterMethodAsString(), other.vocabularyFilterMethodAsString()) && Objects.equals(this.showSpeakerLabel(), other.showSpeakerLabel()) && Objects.equals(this.enableChannelIdentification(), other.enableChannelIdentification()) && Objects.equals(this.numberOfChannels(), other.numberOfChannels());
    }

    public final String toString() {
        return ToString.builder((String)"StartStreamTranscriptionResponse").add("RequestId", (Object)this.requestId()).add("LanguageCode", (Object)this.languageCodeAsString()).add("MediaSampleRateHertz", (Object)this.mediaSampleRateHertz()).add("MediaEncoding", (Object)this.mediaEncodingAsString()).add("VocabularyName", (Object)this.vocabularyName()).add("SessionId", (Object)this.sessionId()).add("VocabularyFilterName", (Object)this.vocabularyFilterName()).add("VocabularyFilterMethod", (Object)this.vocabularyFilterMethodAsString()).add("ShowSpeakerLabel", (Object)this.showSpeakerLabel()).add("EnableChannelIdentification", (Object)this.enableChannelIdentification()).add("NumberOfChannels", (Object)this.numberOfChannels()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "RequestId": {
                return Optional.ofNullable(clazz.cast(this.requestId()));
            }
            case "LanguageCode": {
                return Optional.ofNullable(clazz.cast(this.languageCodeAsString()));
            }
            case "MediaSampleRateHertz": {
                return Optional.ofNullable(clazz.cast(this.mediaSampleRateHertz()));
            }
            case "MediaEncoding": {
                return Optional.ofNullable(clazz.cast(this.mediaEncodingAsString()));
            }
            case "VocabularyName": {
                return Optional.ofNullable(clazz.cast(this.vocabularyName()));
            }
            case "SessionId": {
                return Optional.ofNullable(clazz.cast(this.sessionId()));
            }
            case "VocabularyFilterName": {
                return Optional.ofNullable(clazz.cast(this.vocabularyFilterName()));
            }
            case "VocabularyFilterMethod": {
                return Optional.ofNullable(clazz.cast(this.vocabularyFilterMethodAsString()));
            }
            case "ShowSpeakerLabel": {
                return Optional.ofNullable(clazz.cast(this.showSpeakerLabel()));
            }
            case "EnableChannelIdentification": {
                return Optional.ofNullable(clazz.cast(this.enableChannelIdentification()));
            }
            case "NumberOfChannels": {
                return Optional.ofNullable(clazz.cast(this.numberOfChannels()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StartStreamTranscriptionResponse, T> g) {
        return obj -> g.apply((StartStreamTranscriptionResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends TranscribeStreamingResponse.BuilderImpl
    implements Builder {
        private String requestId;
        private String languageCode;
        private Integer mediaSampleRateHertz;
        private String mediaEncoding;
        private String vocabularyName;
        private String sessionId;
        private String vocabularyFilterName;
        private String vocabularyFilterMethod;
        private Boolean showSpeakerLabel;
        private Boolean enableChannelIdentification;
        private Integer numberOfChannels;

        private BuilderImpl() {
        }

        private BuilderImpl(StartStreamTranscriptionResponse model) {
            super(model);
            this.requestId(model.requestId);
            this.languageCode(model.languageCode);
            this.mediaSampleRateHertz(model.mediaSampleRateHertz);
            this.mediaEncoding(model.mediaEncoding);
            this.vocabularyName(model.vocabularyName);
            this.sessionId(model.sessionId);
            this.vocabularyFilterName(model.vocabularyFilterName);
            this.vocabularyFilterMethod(model.vocabularyFilterMethod);
            this.showSpeakerLabel(model.showSpeakerLabel);
            this.enableChannelIdentification(model.enableChannelIdentification);
            this.numberOfChannels(model.numberOfChannels);
        }

        public final String getRequestId() {
            return this.requestId;
        }

        @Override
        public final Builder requestId(String requestId) {
            this.requestId = requestId;
            return this;
        }

        public final void setRequestId(String requestId) {
            this.requestId = requestId;
        }

        public final String getLanguageCode() {
            return this.languageCode;
        }

        @Override
        public final Builder languageCode(String languageCode) {
            this.languageCode = languageCode;
            return this;
        }

        @Override
        public final Builder languageCode(LanguageCode languageCode) {
            this.languageCode(languageCode == null ? null : languageCode.toString());
            return this;
        }

        public final void setLanguageCode(String languageCode) {
            this.languageCode = languageCode;
        }

        public final Integer getMediaSampleRateHertz() {
            return this.mediaSampleRateHertz;
        }

        @Override
        public final Builder mediaSampleRateHertz(Integer mediaSampleRateHertz) {
            this.mediaSampleRateHertz = mediaSampleRateHertz;
            return this;
        }

        public final void setMediaSampleRateHertz(Integer mediaSampleRateHertz) {
            this.mediaSampleRateHertz = mediaSampleRateHertz;
        }

        public final String getMediaEncoding() {
            return this.mediaEncoding;
        }

        @Override
        public final Builder mediaEncoding(String mediaEncoding) {
            this.mediaEncoding = mediaEncoding;
            return this;
        }

        @Override
        public final Builder mediaEncoding(MediaEncoding mediaEncoding) {
            this.mediaEncoding(mediaEncoding == null ? null : mediaEncoding.toString());
            return this;
        }

        public final void setMediaEncoding(String mediaEncoding) {
            this.mediaEncoding = mediaEncoding;
        }

        public final String getVocabularyName() {
            return this.vocabularyName;
        }

        @Override
        public final Builder vocabularyName(String vocabularyName) {
            this.vocabularyName = vocabularyName;
            return this;
        }

        public final void setVocabularyName(String vocabularyName) {
            this.vocabularyName = vocabularyName;
        }

        public final String getSessionId() {
            return this.sessionId;
        }

        @Override
        public final Builder sessionId(String sessionId) {
            this.sessionId = sessionId;
            return this;
        }

        public final void setSessionId(String sessionId) {
            this.sessionId = sessionId;
        }

        public final String getVocabularyFilterName() {
            return this.vocabularyFilterName;
        }

        @Override
        public final Builder vocabularyFilterName(String vocabularyFilterName) {
            this.vocabularyFilterName = vocabularyFilterName;
            return this;
        }

        public final void setVocabularyFilterName(String vocabularyFilterName) {
            this.vocabularyFilterName = vocabularyFilterName;
        }

        public final String getVocabularyFilterMethod() {
            return this.vocabularyFilterMethod;
        }

        @Override
        public final Builder vocabularyFilterMethod(String vocabularyFilterMethod) {
            this.vocabularyFilterMethod = vocabularyFilterMethod;
            return this;
        }

        @Override
        public final Builder vocabularyFilterMethod(VocabularyFilterMethod vocabularyFilterMethod) {
            this.vocabularyFilterMethod(vocabularyFilterMethod == null ? null : vocabularyFilterMethod.toString());
            return this;
        }

        public final void setVocabularyFilterMethod(String vocabularyFilterMethod) {
            this.vocabularyFilterMethod = vocabularyFilterMethod;
        }

        public final Boolean getShowSpeakerLabel() {
            return this.showSpeakerLabel;
        }

        @Override
        public final Builder showSpeakerLabel(Boolean showSpeakerLabel) {
            this.showSpeakerLabel = showSpeakerLabel;
            return this;
        }

        public final void setShowSpeakerLabel(Boolean showSpeakerLabel) {
            this.showSpeakerLabel = showSpeakerLabel;
        }

        public final Boolean getEnableChannelIdentification() {
            return this.enableChannelIdentification;
        }

        @Override
        public final Builder enableChannelIdentification(Boolean enableChannelIdentification) {
            this.enableChannelIdentification = enableChannelIdentification;
            return this;
        }

        public final void setEnableChannelIdentification(Boolean enableChannelIdentification) {
            this.enableChannelIdentification = enableChannelIdentification;
        }

        public final Integer getNumberOfChannels() {
            return this.numberOfChannels;
        }

        @Override
        public final Builder numberOfChannels(Integer numberOfChannels) {
            this.numberOfChannels = numberOfChannels;
            return this;
        }

        public final void setNumberOfChannels(Integer numberOfChannels) {
            this.numberOfChannels = numberOfChannels;
        }

        @Override
        public StartStreamTranscriptionResponse build() {
            return new StartStreamTranscriptionResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends TranscribeStreamingResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, StartStreamTranscriptionResponse> {
        public Builder requestId(String var1);

        public Builder languageCode(String var1);

        public Builder languageCode(LanguageCode var1);

        public Builder mediaSampleRateHertz(Integer var1);

        public Builder mediaEncoding(String var1);

        public Builder mediaEncoding(MediaEncoding var1);

        public Builder vocabularyName(String var1);

        public Builder sessionId(String var1);

        public Builder vocabularyFilterName(String var1);

        public Builder vocabularyFilterMethod(String var1);

        public Builder vocabularyFilterMethod(VocabularyFilterMethod var1);

        public Builder showSpeakerLabel(Boolean var1);

        public Builder enableChannelIdentification(Boolean var1);

        public Builder numberOfChannels(Integer var1);
    }
}

