/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.transcribestreaming.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.transcribestreaming.model.MedicalEntity;
import software.amazon.awssdk.services.transcribestreaming.model.MedicalEntityListCopier;
import software.amazon.awssdk.services.transcribestreaming.model.MedicalItem;
import software.amazon.awssdk.services.transcribestreaming.model.MedicalItemListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class MedicalAlternative
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, MedicalAlternative> {
    private static final SdkField<String> TRANSCRIPT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Transcript").getter(MedicalAlternative.getter(MedicalAlternative::transcript)).setter(MedicalAlternative.setter(Builder::transcript)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Transcript").build()}).build();
    private static final SdkField<List<MedicalItem>> ITEMS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Items").getter(MedicalAlternative.getter(MedicalAlternative::items)).setter(MedicalAlternative.setter(Builder::items)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Items").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(MedicalItem::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<MedicalEntity>> ENTITIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Entities").getter(MedicalAlternative.getter(MedicalAlternative::entities)).setter(MedicalAlternative.setter(Builder::entities)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Entities").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(MedicalEntity::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TRANSCRIPT_FIELD, ITEMS_FIELD, ENTITIES_FIELD));
    private static final long serialVersionUID = 1L;
    private final String transcript;
    private final List<MedicalItem> items;
    private final List<MedicalEntity> entities;

    private MedicalAlternative(BuilderImpl builder) {
        this.transcript = builder.transcript;
        this.items = builder.items;
        this.entities = builder.entities;
    }

    public final String transcript() {
        return this.transcript;
    }

    public final boolean hasItems() {
        return this.items != null && !(this.items instanceof SdkAutoConstructList);
    }

    public final List<MedicalItem> items() {
        return this.items;
    }

    public final boolean hasEntities() {
        return this.entities != null && !(this.entities instanceof SdkAutoConstructList);
    }

    public final List<MedicalEntity> entities() {
        return this.entities;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.transcript());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasItems() ? this.items() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasEntities() ? this.entities() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MedicalAlternative)) {
            return false;
        }
        MedicalAlternative other = (MedicalAlternative)obj;
        return Objects.equals(this.transcript(), other.transcript()) && this.hasItems() == other.hasItems() && Objects.equals(this.items(), other.items()) && this.hasEntities() == other.hasEntities() && Objects.equals(this.entities(), other.entities());
    }

    public final String toString() {
        return ToString.builder((String)"MedicalAlternative").add("Transcript", (Object)this.transcript()).add("Items", this.hasItems() ? this.items() : null).add("Entities", this.hasEntities() ? this.entities() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Transcript": {
                return Optional.ofNullable(clazz.cast(this.transcript()));
            }
            case "Items": {
                return Optional.ofNullable(clazz.cast(this.items()));
            }
            case "Entities": {
                return Optional.ofNullable(clazz.cast(this.entities()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<MedicalAlternative, T> g) {
        return obj -> g.apply((MedicalAlternative)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String transcript;
        private List<MedicalItem> items = DefaultSdkAutoConstructList.getInstance();
        private List<MedicalEntity> entities = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(MedicalAlternative model) {
            this.transcript(model.transcript);
            this.items(model.items);
            this.entities(model.entities);
        }

        public final String getTranscript() {
            return this.transcript;
        }

        @Override
        public final Builder transcript(String transcript) {
            this.transcript = transcript;
            return this;
        }

        public final void setTranscript(String transcript) {
            this.transcript = transcript;
        }

        public final Collection<MedicalItem.Builder> getItems() {
            if (this.items instanceof SdkAutoConstructList) {
                return null;
            }
            return this.items != null ? (Collection)this.items.stream().map(MedicalItem::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder items(Collection<MedicalItem> items) {
            this.items = MedicalItemListCopier.copy(items);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder items(MedicalItem ... items) {
            this.items(Arrays.asList(items));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder items(Consumer<MedicalItem.Builder> ... items) {
            this.items(Stream.of(items).map(c -> (MedicalItem)((MedicalItem.Builder)MedicalItem.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setItems(Collection<MedicalItem.BuilderImpl> items) {
            this.items = MedicalItemListCopier.copyFromBuilder(items);
        }

        public final Collection<MedicalEntity.Builder> getEntities() {
            if (this.entities instanceof SdkAutoConstructList) {
                return null;
            }
            return this.entities != null ? (Collection)this.entities.stream().map(MedicalEntity::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder entities(Collection<MedicalEntity> entities) {
            this.entities = MedicalEntityListCopier.copy(entities);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder entities(MedicalEntity ... entities) {
            this.entities(Arrays.asList(entities));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder entities(Consumer<MedicalEntity.Builder> ... entities) {
            this.entities(Stream.of(entities).map(c -> (MedicalEntity)((MedicalEntity.Builder)MedicalEntity.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setEntities(Collection<MedicalEntity.BuilderImpl> entities) {
            this.entities = MedicalEntityListCopier.copyFromBuilder(entities);
        }

        public MedicalAlternative build() {
            return new MedicalAlternative(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, MedicalAlternative> {
        public Builder transcript(String var1);

        public Builder items(Collection<MedicalItem> var1);

        public Builder items(MedicalItem ... var1);

        public Builder items(Consumer<MedicalItem.Builder> ... var1);

        public Builder entities(Collection<MedicalEntity> var1);

        public Builder entities(MedicalEntity ... var1);

        public Builder entities(Consumer<MedicalEntity.Builder> ... var1);
    }
}

