/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.transcribe.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class MedicalScribeOutput
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, MedicalScribeOutput> {
    private static final SdkField<String> TRANSCRIPT_FILE_URI_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TranscriptFileUri").getter(MedicalScribeOutput.getter(MedicalScribeOutput::transcriptFileUri)).setter(MedicalScribeOutput.setter(Builder::transcriptFileUri)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TranscriptFileUri").build()}).build();
    private static final SdkField<String> CLINICAL_DOCUMENT_URI_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClinicalDocumentUri").getter(MedicalScribeOutput.getter(MedicalScribeOutput::clinicalDocumentUri)).setter(MedicalScribeOutput.setter(Builder::clinicalDocumentUri)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClinicalDocumentUri").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TRANSCRIPT_FILE_URI_FIELD, CLINICAL_DOCUMENT_URI_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("TranscriptFileUri", TRANSCRIPT_FILE_URI_FIELD);
            this.put("ClinicalDocumentUri", CLINICAL_DOCUMENT_URI_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String transcriptFileUri;
    private final String clinicalDocumentUri;

    private MedicalScribeOutput(BuilderImpl builder) {
        this.transcriptFileUri = builder.transcriptFileUri;
        this.clinicalDocumentUri = builder.clinicalDocumentUri;
    }

    public final String transcriptFileUri() {
        return this.transcriptFileUri;
    }

    public final String clinicalDocumentUri() {
        return this.clinicalDocumentUri;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.transcriptFileUri());
        hashCode = 31 * hashCode + Objects.hashCode(this.clinicalDocumentUri());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MedicalScribeOutput)) {
            return false;
        }
        MedicalScribeOutput other = (MedicalScribeOutput)obj;
        return Objects.equals(this.transcriptFileUri(), other.transcriptFileUri()) && Objects.equals(this.clinicalDocumentUri(), other.clinicalDocumentUri());
    }

    public final String toString() {
        return ToString.builder((String)"MedicalScribeOutput").add("TranscriptFileUri", (Object)this.transcriptFileUri()).add("ClinicalDocumentUri", (Object)this.clinicalDocumentUri()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TranscriptFileUri": {
                return Optional.ofNullable(clazz.cast(this.transcriptFileUri()));
            }
            case "ClinicalDocumentUri": {
                return Optional.ofNullable(clazz.cast(this.clinicalDocumentUri()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<MedicalScribeOutput, T> g) {
        return obj -> g.apply((MedicalScribeOutput)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String transcriptFileUri;
        private String clinicalDocumentUri;

        private BuilderImpl() {
        }

        private BuilderImpl(MedicalScribeOutput model) {
            this.transcriptFileUri(model.transcriptFileUri);
            this.clinicalDocumentUri(model.clinicalDocumentUri);
        }

        public final String getTranscriptFileUri() {
            return this.transcriptFileUri;
        }

        public final void setTranscriptFileUri(String transcriptFileUri) {
            this.transcriptFileUri = transcriptFileUri;
        }

        @Override
        public final Builder transcriptFileUri(String transcriptFileUri) {
            this.transcriptFileUri = transcriptFileUri;
            return this;
        }

        public final String getClinicalDocumentUri() {
            return this.clinicalDocumentUri;
        }

        public final void setClinicalDocumentUri(String clinicalDocumentUri) {
            this.clinicalDocumentUri = clinicalDocumentUri;
        }

        @Override
        public final Builder clinicalDocumentUri(String clinicalDocumentUri) {
            this.clinicalDocumentUri = clinicalDocumentUri;
            return this;
        }

        public MedicalScribeOutput build() {
            return new MedicalScribeOutput(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, MedicalScribeOutput> {
        public Builder transcriptFileUri(String var1);

        public Builder clinicalDocumentUri(String var1);
    }
}

