/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.transcribe.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.transcribe.model.InterruptionFilter;
import software.amazon.awssdk.services.transcribe.model.NonTalkTimeFilter;
import software.amazon.awssdk.services.transcribe.model.SentimentFilter;
import software.amazon.awssdk.services.transcribe.model.TranscriptFilter;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Rule
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Rule> {
    private static final SdkField<NonTalkTimeFilter> NON_TALK_TIME_FILTER_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("NonTalkTimeFilter").getter(Rule.getter(Rule::nonTalkTimeFilter)).setter(Rule.setter(Builder::nonTalkTimeFilter)).constructor(NonTalkTimeFilter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NonTalkTimeFilter").build()}).build();
    private static final SdkField<InterruptionFilter> INTERRUPTION_FILTER_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("InterruptionFilter").getter(Rule.getter(Rule::interruptionFilter)).setter(Rule.setter(Builder::interruptionFilter)).constructor(InterruptionFilter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InterruptionFilter").build()}).build();
    private static final SdkField<TranscriptFilter> TRANSCRIPT_FILTER_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("TranscriptFilter").getter(Rule.getter(Rule::transcriptFilter)).setter(Rule.setter(Builder::transcriptFilter)).constructor(TranscriptFilter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TranscriptFilter").build()}).build();
    private static final SdkField<SentimentFilter> SENTIMENT_FILTER_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("SentimentFilter").getter(Rule.getter(Rule::sentimentFilter)).setter(Rule.setter(Builder::sentimentFilter)).constructor(SentimentFilter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SentimentFilter").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NON_TALK_TIME_FILTER_FIELD, INTERRUPTION_FILTER_FIELD, TRANSCRIPT_FILTER_FIELD, SENTIMENT_FILTER_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Rule.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final NonTalkTimeFilter nonTalkTimeFilter;
    private final InterruptionFilter interruptionFilter;
    private final TranscriptFilter transcriptFilter;
    private final SentimentFilter sentimentFilter;
    private final Type type;

    private Rule(BuilderImpl builder) {
        this.nonTalkTimeFilter = builder.nonTalkTimeFilter;
        this.interruptionFilter = builder.interruptionFilter;
        this.transcriptFilter = builder.transcriptFilter;
        this.sentimentFilter = builder.sentimentFilter;
        this.type = builder.type;
    }

    public final NonTalkTimeFilter nonTalkTimeFilter() {
        return this.nonTalkTimeFilter;
    }

    public final InterruptionFilter interruptionFilter() {
        return this.interruptionFilter;
    }

    public final TranscriptFilter transcriptFilter() {
        return this.transcriptFilter;
    }

    public final SentimentFilter sentimentFilter() {
        return this.sentimentFilter;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.nonTalkTimeFilter());
        hashCode = 31 * hashCode + Objects.hashCode(this.interruptionFilter());
        hashCode = 31 * hashCode + Objects.hashCode(this.transcriptFilter());
        hashCode = 31 * hashCode + Objects.hashCode(this.sentimentFilter());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Rule)) {
            return false;
        }
        Rule other = (Rule)obj;
        return Objects.equals(this.nonTalkTimeFilter(), other.nonTalkTimeFilter()) && Objects.equals(this.interruptionFilter(), other.interruptionFilter()) && Objects.equals(this.transcriptFilter(), other.transcriptFilter()) && Objects.equals(this.sentimentFilter(), other.sentimentFilter());
    }

    public final String toString() {
        return ToString.builder((String)"Rule").add("NonTalkTimeFilter", (Object)this.nonTalkTimeFilter()).add("InterruptionFilter", (Object)this.interruptionFilter()).add("TranscriptFilter", (Object)this.transcriptFilter()).add("SentimentFilter", (Object)this.sentimentFilter()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NonTalkTimeFilter": {
                return Optional.ofNullable(clazz.cast(this.nonTalkTimeFilter()));
            }
            case "InterruptionFilter": {
                return Optional.ofNullable(clazz.cast(this.interruptionFilter()));
            }
            case "TranscriptFilter": {
                return Optional.ofNullable(clazz.cast(this.transcriptFilter()));
            }
            case "SentimentFilter": {
                return Optional.ofNullable(clazz.cast(this.sentimentFilter()));
            }
        }
        return Optional.empty();
    }

    public static Rule fromNonTalkTimeFilter(NonTalkTimeFilter nonTalkTimeFilter) {
        return (Rule)Rule.builder().nonTalkTimeFilter(nonTalkTimeFilter).build();
    }

    public static Rule fromNonTalkTimeFilter(Consumer<NonTalkTimeFilter.Builder> nonTalkTimeFilter) {
        NonTalkTimeFilter.Builder builder = NonTalkTimeFilter.builder();
        nonTalkTimeFilter.accept(builder);
        return Rule.fromNonTalkTimeFilter((NonTalkTimeFilter)builder.build());
    }

    public static Rule fromInterruptionFilter(InterruptionFilter interruptionFilter) {
        return (Rule)Rule.builder().interruptionFilter(interruptionFilter).build();
    }

    public static Rule fromInterruptionFilter(Consumer<InterruptionFilter.Builder> interruptionFilter) {
        InterruptionFilter.Builder builder = InterruptionFilter.builder();
        interruptionFilter.accept(builder);
        return Rule.fromInterruptionFilter((InterruptionFilter)builder.build());
    }

    public static Rule fromTranscriptFilter(TranscriptFilter transcriptFilter) {
        return (Rule)Rule.builder().transcriptFilter(transcriptFilter).build();
    }

    public static Rule fromTranscriptFilter(Consumer<TranscriptFilter.Builder> transcriptFilter) {
        TranscriptFilter.Builder builder = TranscriptFilter.builder();
        transcriptFilter.accept(builder);
        return Rule.fromTranscriptFilter((TranscriptFilter)builder.build());
    }

    public static Rule fromSentimentFilter(SentimentFilter sentimentFilter) {
        return (Rule)Rule.builder().sentimentFilter(sentimentFilter).build();
    }

    public static Rule fromSentimentFilter(Consumer<SentimentFilter.Builder> sentimentFilter) {
        SentimentFilter.Builder builder = SentimentFilter.builder();
        sentimentFilter.accept(builder);
        return Rule.fromSentimentFilter((SentimentFilter)builder.build());
    }

    public Type type() {
        return this.type;
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("NonTalkTimeFilter", NON_TALK_TIME_FILTER_FIELD);
        map.put("InterruptionFilter", INTERRUPTION_FILTER_FIELD);
        map.put("TranscriptFilter", TRANSCRIPT_FILTER_FIELD);
        map.put("SentimentFilter", SENTIMENT_FILTER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Rule, T> g) {
        return obj -> g.apply((Rule)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    public static enum Type {
        NON_TALK_TIME_FILTER,
        INTERRUPTION_FILTER,
        TRANSCRIPT_FILTER,
        SENTIMENT_FILTER,
        UNKNOWN_TO_SDK_VERSION;

    }

    static final class BuilderImpl
    implements Builder {
        private NonTalkTimeFilter nonTalkTimeFilter;
        private InterruptionFilter interruptionFilter;
        private TranscriptFilter transcriptFilter;
        private SentimentFilter sentimentFilter;
        private Type type = Type.UNKNOWN_TO_SDK_VERSION;
        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(Rule model) {
            this.nonTalkTimeFilter(model.nonTalkTimeFilter);
            this.interruptionFilter(model.interruptionFilter);
            this.transcriptFilter(model.transcriptFilter);
            this.sentimentFilter(model.sentimentFilter);
        }

        public final NonTalkTimeFilter.Builder getNonTalkTimeFilter() {
            return this.nonTalkTimeFilter != null ? this.nonTalkTimeFilter.toBuilder() : null;
        }

        public final void setNonTalkTimeFilter(NonTalkTimeFilter.BuilderImpl nonTalkTimeFilter) {
            NonTalkTimeFilter oldValue = this.nonTalkTimeFilter;
            this.nonTalkTimeFilter = nonTalkTimeFilter != null ? nonTalkTimeFilter.build() : null;
            this.handleUnionValueChange(Type.NON_TALK_TIME_FILTER, oldValue, this.nonTalkTimeFilter);
        }

        @Override
        public final Builder nonTalkTimeFilter(NonTalkTimeFilter nonTalkTimeFilter) {
            NonTalkTimeFilter oldValue = this.nonTalkTimeFilter;
            this.nonTalkTimeFilter = nonTalkTimeFilter;
            this.handleUnionValueChange(Type.NON_TALK_TIME_FILTER, oldValue, this.nonTalkTimeFilter);
            return this;
        }

        public final InterruptionFilter.Builder getInterruptionFilter() {
            return this.interruptionFilter != null ? this.interruptionFilter.toBuilder() : null;
        }

        public final void setInterruptionFilter(InterruptionFilter.BuilderImpl interruptionFilter) {
            InterruptionFilter oldValue = this.interruptionFilter;
            this.interruptionFilter = interruptionFilter != null ? interruptionFilter.build() : null;
            this.handleUnionValueChange(Type.INTERRUPTION_FILTER, oldValue, this.interruptionFilter);
        }

        @Override
        public final Builder interruptionFilter(InterruptionFilter interruptionFilter) {
            InterruptionFilter oldValue = this.interruptionFilter;
            this.interruptionFilter = interruptionFilter;
            this.handleUnionValueChange(Type.INTERRUPTION_FILTER, oldValue, this.interruptionFilter);
            return this;
        }

        public final TranscriptFilter.Builder getTranscriptFilter() {
            return this.transcriptFilter != null ? this.transcriptFilter.toBuilder() : null;
        }

        public final void setTranscriptFilter(TranscriptFilter.BuilderImpl transcriptFilter) {
            TranscriptFilter oldValue = this.transcriptFilter;
            this.transcriptFilter = transcriptFilter != null ? transcriptFilter.build() : null;
            this.handleUnionValueChange(Type.TRANSCRIPT_FILTER, oldValue, this.transcriptFilter);
        }

        @Override
        public final Builder transcriptFilter(TranscriptFilter transcriptFilter) {
            TranscriptFilter oldValue = this.transcriptFilter;
            this.transcriptFilter = transcriptFilter;
            this.handleUnionValueChange(Type.TRANSCRIPT_FILTER, oldValue, this.transcriptFilter);
            return this;
        }

        public final SentimentFilter.Builder getSentimentFilter() {
            return this.sentimentFilter != null ? this.sentimentFilter.toBuilder() : null;
        }

        public final void setSentimentFilter(SentimentFilter.BuilderImpl sentimentFilter) {
            SentimentFilter oldValue = this.sentimentFilter;
            this.sentimentFilter = sentimentFilter != null ? sentimentFilter.build() : null;
            this.handleUnionValueChange(Type.SENTIMENT_FILTER, oldValue, this.sentimentFilter);
        }

        @Override
        public final Builder sentimentFilter(SentimentFilter sentimentFilter) {
            SentimentFilter oldValue = this.sentimentFilter;
            this.sentimentFilter = sentimentFilter;
            this.handleUnionValueChange(Type.SENTIMENT_FILTER, oldValue, this.sentimentFilter);
            return this;
        }

        public Rule build() {
            return new Rule(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                this.setTypes.remove((Object)type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                this.setTypes.add(type);
            }
            this.type = this.setTypes.size() == 1 ? this.setTypes.iterator().next() : (this.setTypes.isEmpty() ? Type.UNKNOWN_TO_SDK_VERSION : null);
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Rule> {
        public Builder nonTalkTimeFilter(NonTalkTimeFilter var1);

        default public Builder nonTalkTimeFilter(Consumer<NonTalkTimeFilter.Builder> nonTalkTimeFilter) {
            return this.nonTalkTimeFilter((NonTalkTimeFilter)((NonTalkTimeFilter.Builder)NonTalkTimeFilter.builder().applyMutation(nonTalkTimeFilter)).build());
        }

        public Builder interruptionFilter(InterruptionFilter var1);

        default public Builder interruptionFilter(Consumer<InterruptionFilter.Builder> interruptionFilter) {
            return this.interruptionFilter((InterruptionFilter)((InterruptionFilter.Builder)InterruptionFilter.builder().applyMutation(interruptionFilter)).build());
        }

        public Builder transcriptFilter(TranscriptFilter var1);

        default public Builder transcriptFilter(Consumer<TranscriptFilter.Builder> transcriptFilter) {
            return this.transcriptFilter((TranscriptFilter)((TranscriptFilter.Builder)TranscriptFilter.builder().applyMutation(transcriptFilter)).build());
        }

        public Builder sentimentFilter(SentimentFilter var1);

        default public Builder sentimentFilter(Consumer<SentimentFilter.Builder> sentimentFilter) {
            return this.sentimentFilter((SentimentFilter)((SentimentFilter.Builder)SentimentFilter.builder().applyMutation(sentimentFilter)).build());
        }
    }
}

