/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.transcribe.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListMedicalTranscriptionJobsRequest extends TranscribeRequest implements
        ToCopyableBuilder<ListMedicalTranscriptionJobsRequest.Builder, ListMedicalTranscriptionJobsRequest> {
    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ListMedicalTranscriptionJobsRequest::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<String> JOB_NAME_CONTAINS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ListMedicalTranscriptionJobsRequest::jobNameContains)).setter(setter(Builder::jobNameContains))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JobNameContains").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ListMedicalTranscriptionJobsRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(ListMedicalTranscriptionJobsRequest::maxResults)).setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STATUS_FIELD,
            JOB_NAME_CONTAINS_FIELD, NEXT_TOKEN_FIELD, MAX_RESULTS_FIELD));

    private final String status;

    private final String jobNameContains;

    private final String nextToken;

    private final Integer maxResults;

    private ListMedicalTranscriptionJobsRequest(BuilderImpl builder) {
        super(builder);
        this.status = builder.status;
        this.jobNameContains = builder.jobNameContains;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
    }

    /**
     * <p>
     * When specified, returns only medical transcription jobs with the specified status. Jobs are ordered by creation
     * date, with the newest jobs returned first. If you don't specify a status, Amazon Transcribe Medical returns all
     * transcription jobs ordered by creation date.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link TranscriptionJobStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return When specified, returns only medical transcription jobs with the specified status. Jobs are ordered by
     *         creation date, with the newest jobs returned first. If you don't specify a status, Amazon Transcribe
     *         Medical returns all transcription jobs ordered by creation date.
     * @see TranscriptionJobStatus
     */
    public TranscriptionJobStatus status() {
        return TranscriptionJobStatus.fromValue(status);
    }

    /**
     * <p>
     * When specified, returns only medical transcription jobs with the specified status. Jobs are ordered by creation
     * date, with the newest jobs returned first. If you don't specify a status, Amazon Transcribe Medical returns all
     * transcription jobs ordered by creation date.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link TranscriptionJobStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return When specified, returns only medical transcription jobs with the specified status. Jobs are ordered by
     *         creation date, with the newest jobs returned first. If you don't specify a status, Amazon Transcribe
     *         Medical returns all transcription jobs ordered by creation date.
     * @see TranscriptionJobStatus
     */
    public String statusAsString() {
        return status;
    }

    /**
     * <p>
     * When specified, the jobs returned in the list are limited to jobs whose name contains the specified string.
     * </p>
     * 
     * @return When specified, the jobs returned in the list are limited to jobs whose name contains the specified
     *         string.
     */
    public String jobNameContains() {
        return jobNameContains;
    }

    /**
     * <p>
     * If you a receive a truncated result in the previous request of <code>ListMedicalTranscriptionJobs</code>, include
     * <code>NextToken</code> to fetch the next set of jobs.
     * </p>
     * 
     * @return If you a receive a truncated result in the previous request of <code>ListMedicalTranscriptionJobs</code>,
     *         include <code>NextToken</code> to fetch the next set of jobs.
     */
    public String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The maximum number of medical transcription jobs to return in the response. IF there are fewer results in the
     * list, this response contains only the actual results.
     * </p>
     * 
     * @return The maximum number of medical transcription jobs to return in the response. IF there are fewer results in
     *         the list, this response contains only the actual results.
     */
    public Integer maxResults() {
        return maxResults;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(jobNameContains());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListMedicalTranscriptionJobsRequest)) {
            return false;
        }
        ListMedicalTranscriptionJobsRequest other = (ListMedicalTranscriptionJobsRequest) obj;
        return Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(jobNameContains(), other.jobNameContains()) && Objects.equals(nextToken(), other.nextToken())
                && Objects.equals(maxResults(), other.maxResults());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ListMedicalTranscriptionJobsRequest").add("Status", statusAsString())
                .add("JobNameContains", jobNameContains()).add("NextToken", nextToken()).add("MaxResults", maxResults()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "JobNameContains":
            return Optional.ofNullable(clazz.cast(jobNameContains()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "MaxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListMedicalTranscriptionJobsRequest, T> g) {
        return obj -> g.apply((ListMedicalTranscriptionJobsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends TranscribeRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, ListMedicalTranscriptionJobsRequest> {
        /**
         * <p>
         * When specified, returns only medical transcription jobs with the specified status. Jobs are ordered by
         * creation date, with the newest jobs returned first. If you don't specify a status, Amazon Transcribe Medical
         * returns all transcription jobs ordered by creation date.
         * </p>
         * 
         * @param status
         *        When specified, returns only medical transcription jobs with the specified status. Jobs are ordered by
         *        creation date, with the newest jobs returned first. If you don't specify a status, Amazon Transcribe
         *        Medical returns all transcription jobs ordered by creation date.
         * @see TranscriptionJobStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TranscriptionJobStatus
         */
        Builder status(String status);

        /**
         * <p>
         * When specified, returns only medical transcription jobs with the specified status. Jobs are ordered by
         * creation date, with the newest jobs returned first. If you don't specify a status, Amazon Transcribe Medical
         * returns all transcription jobs ordered by creation date.
         * </p>
         * 
         * @param status
         *        When specified, returns only medical transcription jobs with the specified status. Jobs are ordered by
         *        creation date, with the newest jobs returned first. If you don't specify a status, Amazon Transcribe
         *        Medical returns all transcription jobs ordered by creation date.
         * @see TranscriptionJobStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TranscriptionJobStatus
         */
        Builder status(TranscriptionJobStatus status);

        /**
         * <p>
         * When specified, the jobs returned in the list are limited to jobs whose name contains the specified string.
         * </p>
         * 
         * @param jobNameContains
         *        When specified, the jobs returned in the list are limited to jobs whose name contains the specified
         *        string.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobNameContains(String jobNameContains);

        /**
         * <p>
         * If you a receive a truncated result in the previous request of <code>ListMedicalTranscriptionJobs</code>,
         * include <code>NextToken</code> to fetch the next set of jobs.
         * </p>
         * 
         * @param nextToken
         *        If you a receive a truncated result in the previous request of
         *        <code>ListMedicalTranscriptionJobs</code>, include <code>NextToken</code> to fetch the next set of
         *        jobs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The maximum number of medical transcription jobs to return in the response. IF there are fewer results in the
         * list, this response contains only the actual results.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of medical transcription jobs to return in the response. IF there are fewer results
         *        in the list, this response contains only the actual results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends TranscribeRequest.BuilderImpl implements Builder {
        private String status;

        private String jobNameContains;

        private String nextToken;

        private Integer maxResults;

        private BuilderImpl() {
        }

        private BuilderImpl(ListMedicalTranscriptionJobsRequest model) {
            super(model);
            status(model.status);
            jobNameContains(model.jobNameContains);
            nextToken(model.nextToken);
            maxResults(model.maxResults);
        }

        public final String getStatus() {
            return status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(TranscriptionJobStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final String getJobNameContains() {
            return jobNameContains;
        }

        @Override
        public final Builder jobNameContains(String jobNameContains) {
            this.jobNameContains = jobNameContains;
            return this;
        }

        public final void setJobNameContains(String jobNameContains) {
            this.jobNameContains = jobNameContains;
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListMedicalTranscriptionJobsRequest build() {
            return new ListMedicalTranscriptionJobsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
