/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.transcribe.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Identifies the location of a transcription.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Transcript implements SdkPojo, Serializable, ToCopyableBuilder<Transcript.Builder, Transcript> {
    private static final SdkField<String> TRANSCRIPT_FILE_URI_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Transcript::transcriptFileUri)).setter(setter(Builder::transcriptFileUri))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TranscriptFileUri").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TRANSCRIPT_FILE_URI_FIELD));

    private static final long serialVersionUID = 1L;

    private final String transcriptFileUri;

    private Transcript(BuilderImpl builder) {
        this.transcriptFileUri = builder.transcriptFileUri;
    }

    /**
     * <p>
     * The location where the transcription is stored.
     * </p>
     * <p>
     * Use this URI to access the transcription. If you specified an S3 bucket in the <code>OutputBucketName</code>
     * field when you created the job, this is the URI of that bucket. If you chose to store the transcription in Amazon
     * Transcribe, this is a shareable URL that provides secure access to that location.
     * </p>
     * 
     * @return The location where the transcription is stored.</p>
     *         <p>
     *         Use this URI to access the transcription. If you specified an S3 bucket in the
     *         <code>OutputBucketName</code> field when you created the job, this is the URI of that bucket. If you
     *         chose to store the transcription in Amazon Transcribe, this is a shareable URL that provides secure
     *         access to that location.
     */
    public String transcriptFileUri() {
        return transcriptFileUri;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(transcriptFileUri());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Transcript)) {
            return false;
        }
        Transcript other = (Transcript) obj;
        return Objects.equals(transcriptFileUri(), other.transcriptFileUri());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("Transcript").add("TranscriptFileUri", transcriptFileUri()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TranscriptFileUri":
            return Optional.ofNullable(clazz.cast(transcriptFileUri()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Transcript, T> g) {
        return obj -> g.apply((Transcript) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Transcript> {
        /**
         * <p>
         * The location where the transcription is stored.
         * </p>
         * <p>
         * Use this URI to access the transcription. If you specified an S3 bucket in the <code>OutputBucketName</code>
         * field when you created the job, this is the URI of that bucket. If you chose to store the transcription in
         * Amazon Transcribe, this is a shareable URL that provides secure access to that location.
         * </p>
         * 
         * @param transcriptFileUri
         *        The location where the transcription is stored.</p>
         *        <p>
         *        Use this URI to access the transcription. If you specified an S3 bucket in the
         *        <code>OutputBucketName</code> field when you created the job, this is the URI of that bucket. If you
         *        chose to store the transcription in Amazon Transcribe, this is a shareable URL that provides secure
         *        access to that location.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder transcriptFileUri(String transcriptFileUri);
    }

    static final class BuilderImpl implements Builder {
        private String transcriptFileUri;

        private BuilderImpl() {
        }

        private BuilderImpl(Transcript model) {
            transcriptFileUri(model.transcriptFileUri);
        }

        public final String getTranscriptFileUri() {
            return transcriptFileUri;
        }

        @Override
        public final Builder transcriptFileUri(String transcriptFileUri) {
            this.transcriptFileUri = transcriptFileUri;
            return this;
        }

        public final void setTranscriptFileUri(String transcriptFileUri) {
            this.transcriptFileUri = transcriptFileUri;
        }

        @Override
        public Transcript build() {
            return new Transcript(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
