/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.transcribe.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides optional settings for the <code>StartTranscriptionJob</code> operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Settings implements SdkPojo, Serializable, ToCopyableBuilder<Settings.Builder, Settings> {
    private static final SdkField<String> VOCABULARY_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Settings::vocabularyName)).setter(setter(Builder::vocabularyName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VocabularyName").build()).build();

    private static final SdkField<Boolean> SHOW_SPEAKER_LABELS_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(Settings::showSpeakerLabels)).setter(setter(Builder::showSpeakerLabels))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ShowSpeakerLabels").build()).build();

    private static final SdkField<Integer> MAX_SPEAKER_LABELS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(Settings::maxSpeakerLabels)).setter(setter(Builder::maxSpeakerLabels))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxSpeakerLabels").build()).build();

    private static final SdkField<Boolean> CHANNEL_IDENTIFICATION_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(Settings::channelIdentification)).setter(setter(Builder::channelIdentification))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ChannelIdentification").build())
            .build();

    private static final SdkField<Boolean> SHOW_ALTERNATIVES_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(Settings::showAlternatives)).setter(setter(Builder::showAlternatives))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ShowAlternatives").build()).build();

    private static final SdkField<Integer> MAX_ALTERNATIVES_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(Settings::maxAlternatives)).setter(setter(Builder::maxAlternatives))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxAlternatives").build()).build();

    private static final SdkField<String> VOCABULARY_FILTER_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Settings::vocabularyFilterName)).setter(setter(Builder::vocabularyFilterName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VocabularyFilterName").build())
            .build();

    private static final SdkField<String> VOCABULARY_FILTER_METHOD_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Settings::vocabularyFilterMethodAsString)).setter(setter(Builder::vocabularyFilterMethod))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VocabularyFilterMethod").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VOCABULARY_NAME_FIELD,
            SHOW_SPEAKER_LABELS_FIELD, MAX_SPEAKER_LABELS_FIELD, CHANNEL_IDENTIFICATION_FIELD, SHOW_ALTERNATIVES_FIELD,
            MAX_ALTERNATIVES_FIELD, VOCABULARY_FILTER_NAME_FIELD, VOCABULARY_FILTER_METHOD_FIELD));

    private static final long serialVersionUID = 1L;

    private final String vocabularyName;

    private final Boolean showSpeakerLabels;

    private final Integer maxSpeakerLabels;

    private final Boolean channelIdentification;

    private final Boolean showAlternatives;

    private final Integer maxAlternatives;

    private final String vocabularyFilterName;

    private final String vocabularyFilterMethod;

    private Settings(BuilderImpl builder) {
        this.vocabularyName = builder.vocabularyName;
        this.showSpeakerLabels = builder.showSpeakerLabels;
        this.maxSpeakerLabels = builder.maxSpeakerLabels;
        this.channelIdentification = builder.channelIdentification;
        this.showAlternatives = builder.showAlternatives;
        this.maxAlternatives = builder.maxAlternatives;
        this.vocabularyFilterName = builder.vocabularyFilterName;
        this.vocabularyFilterMethod = builder.vocabularyFilterMethod;
    }

    /**
     * <p>
     * The name of a vocabulary to use when processing the transcription job.
     * </p>
     * 
     * @return The name of a vocabulary to use when processing the transcription job.
     */
    public String vocabularyName() {
        return vocabularyName;
    }

    /**
     * <p>
     * Determines whether the transcription job uses speaker recognition to identify different speakers in the input
     * audio. Speaker recognition labels individual speakers in the audio file. If you set the
     * <code>ShowSpeakerLabels</code> field to true, you must also set the maximum number of speaker labels
     * <code>MaxSpeakerLabels</code> field.
     * </p>
     * <p>
     * You can't set both <code>ShowSpeakerLabels</code> and <code>ChannelIdentification</code> in the same request. If
     * you set both, your request returns a <code>BadRequestException</code>.
     * </p>
     * 
     * @return Determines whether the transcription job uses speaker recognition to identify different speakers in the
     *         input audio. Speaker recognition labels individual speakers in the audio file. If you set the
     *         <code>ShowSpeakerLabels</code> field to true, you must also set the maximum number of speaker labels
     *         <code>MaxSpeakerLabels</code> field.</p>
     *         <p>
     *         You can't set both <code>ShowSpeakerLabels</code> and <code>ChannelIdentification</code> in the same
     *         request. If you set both, your request returns a <code>BadRequestException</code>.
     */
    public Boolean showSpeakerLabels() {
        return showSpeakerLabels;
    }

    /**
     * <p>
     * The maximum number of speakers to identify in the input audio. If there are more speakers in the audio than this
     * number, multiple speakers will be identified as a single speaker. If you specify the
     * <code>MaxSpeakerLabels</code> field, you must set the <code>ShowSpeakerLabels</code> field to true.
     * </p>
     * 
     * @return The maximum number of speakers to identify in the input audio. If there are more speakers in the audio
     *         than this number, multiple speakers will be identified as a single speaker. If you specify the
     *         <code>MaxSpeakerLabels</code> field, you must set the <code>ShowSpeakerLabels</code> field to true.
     */
    public Integer maxSpeakerLabels() {
        return maxSpeakerLabels;
    }

    /**
     * <p>
     * Instructs Amazon Transcribe to process each audio channel separately and then merge the transcription output of
     * each channel into a single transcription.
     * </p>
     * <p>
     * Amazon Transcribe also produces a transcription of each item detected on an audio channel, including the start
     * time and end time of the item and alternative transcriptions of the item including the confidence that Amazon
     * Transcribe has in the transcription.
     * </p>
     * <p>
     * You can't set both <code>ShowSpeakerLabels</code> and <code>ChannelIdentification</code> in the same request. If
     * you set both, your request returns a <code>BadRequestException</code>.
     * </p>
     * 
     * @return Instructs Amazon Transcribe to process each audio channel separately and then merge the transcription
     *         output of each channel into a single transcription. </p>
     *         <p>
     *         Amazon Transcribe also produces a transcription of each item detected on an audio channel, including the
     *         start time and end time of the item and alternative transcriptions of the item including the confidence
     *         that Amazon Transcribe has in the transcription.
     *         </p>
     *         <p>
     *         You can't set both <code>ShowSpeakerLabels</code> and <code>ChannelIdentification</code> in the same
     *         request. If you set both, your request returns a <code>BadRequestException</code>.
     */
    public Boolean channelIdentification() {
        return channelIdentification;
    }

    /**
     * <p>
     * Determines whether the transcription contains alternative transcriptions. If you set the
     * <code>ShowAlternatives</code> field to true, you must also set the maximum number of alternatives to return in
     * the <code>MaxAlternatives</code> field.
     * </p>
     * 
     * @return Determines whether the transcription contains alternative transcriptions. If you set the
     *         <code>ShowAlternatives</code> field to true, you must also set the maximum number of alternatives to
     *         return in the <code>MaxAlternatives</code> field.
     */
    public Boolean showAlternatives() {
        return showAlternatives;
    }

    /**
     * <p>
     * The number of alternative transcriptions that the service should return. If you specify the
     * <code>MaxAlternatives</code> field, you must set the <code>ShowAlternatives</code> field to true.
     * </p>
     * 
     * @return The number of alternative transcriptions that the service should return. If you specify the
     *         <code>MaxAlternatives</code> field, you must set the <code>ShowAlternatives</code> field to true.
     */
    public Integer maxAlternatives() {
        return maxAlternatives;
    }

    /**
     * <p>
     * The name of the vocabulary filter to use when transcribing the audio. The filter that you specify must have the
     * same language code as the transcription job.
     * </p>
     * 
     * @return The name of the vocabulary filter to use when transcribing the audio. The filter that you specify must
     *         have the same language code as the transcription job.
     */
    public String vocabularyFilterName() {
        return vocabularyFilterName;
    }

    /**
     * <p>
     * Set to <code>mask</code> to remove filtered text from the transcript and replace it with three asterisks ("***")
     * as placeholder text. Set to <code>remove</code> to remove filtered text from the transcript without using
     * placeholder text.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #vocabularyFilterMethod} will return {@link VocabularyFilterMethod#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #vocabularyFilterMethodAsString}.
     * </p>
     * 
     * @return Set to <code>mask</code> to remove filtered text from the transcript and replace it with three asterisks
     *         ("***") as placeholder text. Set to <code>remove</code> to remove filtered text from the transcript
     *         without using placeholder text.
     * @see VocabularyFilterMethod
     */
    public VocabularyFilterMethod vocabularyFilterMethod() {
        return VocabularyFilterMethod.fromValue(vocabularyFilterMethod);
    }

    /**
     * <p>
     * Set to <code>mask</code> to remove filtered text from the transcript and replace it with three asterisks ("***")
     * as placeholder text. Set to <code>remove</code> to remove filtered text from the transcript without using
     * placeholder text.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #vocabularyFilterMethod} will return {@link VocabularyFilterMethod#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #vocabularyFilterMethodAsString}.
     * </p>
     * 
     * @return Set to <code>mask</code> to remove filtered text from the transcript and replace it with three asterisks
     *         ("***") as placeholder text. Set to <code>remove</code> to remove filtered text from the transcript
     *         without using placeholder text.
     * @see VocabularyFilterMethod
     */
    public String vocabularyFilterMethodAsString() {
        return vocabularyFilterMethod;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(vocabularyName());
        hashCode = 31 * hashCode + Objects.hashCode(showSpeakerLabels());
        hashCode = 31 * hashCode + Objects.hashCode(maxSpeakerLabels());
        hashCode = 31 * hashCode + Objects.hashCode(channelIdentification());
        hashCode = 31 * hashCode + Objects.hashCode(showAlternatives());
        hashCode = 31 * hashCode + Objects.hashCode(maxAlternatives());
        hashCode = 31 * hashCode + Objects.hashCode(vocabularyFilterName());
        hashCode = 31 * hashCode + Objects.hashCode(vocabularyFilterMethodAsString());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Settings)) {
            return false;
        }
        Settings other = (Settings) obj;
        return Objects.equals(vocabularyName(), other.vocabularyName())
                && Objects.equals(showSpeakerLabels(), other.showSpeakerLabels())
                && Objects.equals(maxSpeakerLabels(), other.maxSpeakerLabels())
                && Objects.equals(channelIdentification(), other.channelIdentification())
                && Objects.equals(showAlternatives(), other.showAlternatives())
                && Objects.equals(maxAlternatives(), other.maxAlternatives())
                && Objects.equals(vocabularyFilterName(), other.vocabularyFilterName())
                && Objects.equals(vocabularyFilterMethodAsString(), other.vocabularyFilterMethodAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("Settings").add("VocabularyName", vocabularyName()).add("ShowSpeakerLabels", showSpeakerLabels())
                .add("MaxSpeakerLabels", maxSpeakerLabels()).add("ChannelIdentification", channelIdentification())
                .add("ShowAlternatives", showAlternatives()).add("MaxAlternatives", maxAlternatives())
                .add("VocabularyFilterName", vocabularyFilterName())
                .add("VocabularyFilterMethod", vocabularyFilterMethodAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "VocabularyName":
            return Optional.ofNullable(clazz.cast(vocabularyName()));
        case "ShowSpeakerLabels":
            return Optional.ofNullable(clazz.cast(showSpeakerLabels()));
        case "MaxSpeakerLabels":
            return Optional.ofNullable(clazz.cast(maxSpeakerLabels()));
        case "ChannelIdentification":
            return Optional.ofNullable(clazz.cast(channelIdentification()));
        case "ShowAlternatives":
            return Optional.ofNullable(clazz.cast(showAlternatives()));
        case "MaxAlternatives":
            return Optional.ofNullable(clazz.cast(maxAlternatives()));
        case "VocabularyFilterName":
            return Optional.ofNullable(clazz.cast(vocabularyFilterName()));
        case "VocabularyFilterMethod":
            return Optional.ofNullable(clazz.cast(vocabularyFilterMethodAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Settings, T> g) {
        return obj -> g.apply((Settings) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Settings> {
        /**
         * <p>
         * The name of a vocabulary to use when processing the transcription job.
         * </p>
         * 
         * @param vocabularyName
         *        The name of a vocabulary to use when processing the transcription job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vocabularyName(String vocabularyName);

        /**
         * <p>
         * Determines whether the transcription job uses speaker recognition to identify different speakers in the input
         * audio. Speaker recognition labels individual speakers in the audio file. If you set the
         * <code>ShowSpeakerLabels</code> field to true, you must also set the maximum number of speaker labels
         * <code>MaxSpeakerLabels</code> field.
         * </p>
         * <p>
         * You can't set both <code>ShowSpeakerLabels</code> and <code>ChannelIdentification</code> in the same request.
         * If you set both, your request returns a <code>BadRequestException</code>.
         * </p>
         * 
         * @param showSpeakerLabels
         *        Determines whether the transcription job uses speaker recognition to identify different speakers in
         *        the input audio. Speaker recognition labels individual speakers in the audio file. If you set the
         *        <code>ShowSpeakerLabels</code> field to true, you must also set the maximum number of speaker labels
         *        <code>MaxSpeakerLabels</code> field.</p>
         *        <p>
         *        You can't set both <code>ShowSpeakerLabels</code> and <code>ChannelIdentification</code> in the same
         *        request. If you set both, your request returns a <code>BadRequestException</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder showSpeakerLabels(Boolean showSpeakerLabels);

        /**
         * <p>
         * The maximum number of speakers to identify in the input audio. If there are more speakers in the audio than
         * this number, multiple speakers will be identified as a single speaker. If you specify the
         * <code>MaxSpeakerLabels</code> field, you must set the <code>ShowSpeakerLabels</code> field to true.
         * </p>
         * 
         * @param maxSpeakerLabels
         *        The maximum number of speakers to identify in the input audio. If there are more speakers in the audio
         *        than this number, multiple speakers will be identified as a single speaker. If you specify the
         *        <code>MaxSpeakerLabels</code> field, you must set the <code>ShowSpeakerLabels</code> field to true.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxSpeakerLabels(Integer maxSpeakerLabels);

        /**
         * <p>
         * Instructs Amazon Transcribe to process each audio channel separately and then merge the transcription output
         * of each channel into a single transcription.
         * </p>
         * <p>
         * Amazon Transcribe also produces a transcription of each item detected on an audio channel, including the
         * start time and end time of the item and alternative transcriptions of the item including the confidence that
         * Amazon Transcribe has in the transcription.
         * </p>
         * <p>
         * You can't set both <code>ShowSpeakerLabels</code> and <code>ChannelIdentification</code> in the same request.
         * If you set both, your request returns a <code>BadRequestException</code>.
         * </p>
         * 
         * @param channelIdentification
         *        Instructs Amazon Transcribe to process each audio channel separately and then merge the transcription
         *        output of each channel into a single transcription. </p>
         *        <p>
         *        Amazon Transcribe also produces a transcription of each item detected on an audio channel, including
         *        the start time and end time of the item and alternative transcriptions of the item including the
         *        confidence that Amazon Transcribe has in the transcription.
         *        </p>
         *        <p>
         *        You can't set both <code>ShowSpeakerLabels</code> and <code>ChannelIdentification</code> in the same
         *        request. If you set both, your request returns a <code>BadRequestException</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder channelIdentification(Boolean channelIdentification);

        /**
         * <p>
         * Determines whether the transcription contains alternative transcriptions. If you set the
         * <code>ShowAlternatives</code> field to true, you must also set the maximum number of alternatives to return
         * in the <code>MaxAlternatives</code> field.
         * </p>
         * 
         * @param showAlternatives
         *        Determines whether the transcription contains alternative transcriptions. If you set the
         *        <code>ShowAlternatives</code> field to true, you must also set the maximum number of alternatives to
         *        return in the <code>MaxAlternatives</code> field.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder showAlternatives(Boolean showAlternatives);

        /**
         * <p>
         * The number of alternative transcriptions that the service should return. If you specify the
         * <code>MaxAlternatives</code> field, you must set the <code>ShowAlternatives</code> field to true.
         * </p>
         * 
         * @param maxAlternatives
         *        The number of alternative transcriptions that the service should return. If you specify the
         *        <code>MaxAlternatives</code> field, you must set the <code>ShowAlternatives</code> field to true.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxAlternatives(Integer maxAlternatives);

        /**
         * <p>
         * The name of the vocabulary filter to use when transcribing the audio. The filter that you specify must have
         * the same language code as the transcription job.
         * </p>
         * 
         * @param vocabularyFilterName
         *        The name of the vocabulary filter to use when transcribing the audio. The filter that you specify must
         *        have the same language code as the transcription job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vocabularyFilterName(String vocabularyFilterName);

        /**
         * <p>
         * Set to <code>mask</code> to remove filtered text from the transcript and replace it with three asterisks
         * ("***") as placeholder text. Set to <code>remove</code> to remove filtered text from the transcript without
         * using placeholder text.
         * </p>
         * 
         * @param vocabularyFilterMethod
         *        Set to <code>mask</code> to remove filtered text from the transcript and replace it with three
         *        asterisks ("***") as placeholder text. Set to <code>remove</code> to remove filtered text from the
         *        transcript without using placeholder text.
         * @see VocabularyFilterMethod
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see VocabularyFilterMethod
         */
        Builder vocabularyFilterMethod(String vocabularyFilterMethod);

        /**
         * <p>
         * Set to <code>mask</code> to remove filtered text from the transcript and replace it with three asterisks
         * ("***") as placeholder text. Set to <code>remove</code> to remove filtered text from the transcript without
         * using placeholder text.
         * </p>
         * 
         * @param vocabularyFilterMethod
         *        Set to <code>mask</code> to remove filtered text from the transcript and replace it with three
         *        asterisks ("***") as placeholder text. Set to <code>remove</code> to remove filtered text from the
         *        transcript without using placeholder text.
         * @see VocabularyFilterMethod
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see VocabularyFilterMethod
         */
        Builder vocabularyFilterMethod(VocabularyFilterMethod vocabularyFilterMethod);
    }

    static final class BuilderImpl implements Builder {
        private String vocabularyName;

        private Boolean showSpeakerLabels;

        private Integer maxSpeakerLabels;

        private Boolean channelIdentification;

        private Boolean showAlternatives;

        private Integer maxAlternatives;

        private String vocabularyFilterName;

        private String vocabularyFilterMethod;

        private BuilderImpl() {
        }

        private BuilderImpl(Settings model) {
            vocabularyName(model.vocabularyName);
            showSpeakerLabels(model.showSpeakerLabels);
            maxSpeakerLabels(model.maxSpeakerLabels);
            channelIdentification(model.channelIdentification);
            showAlternatives(model.showAlternatives);
            maxAlternatives(model.maxAlternatives);
            vocabularyFilterName(model.vocabularyFilterName);
            vocabularyFilterMethod(model.vocabularyFilterMethod);
        }

        public final String getVocabularyName() {
            return vocabularyName;
        }

        @Override
        public final Builder vocabularyName(String vocabularyName) {
            this.vocabularyName = vocabularyName;
            return this;
        }

        public final void setVocabularyName(String vocabularyName) {
            this.vocabularyName = vocabularyName;
        }

        public final Boolean getShowSpeakerLabels() {
            return showSpeakerLabels;
        }

        @Override
        public final Builder showSpeakerLabels(Boolean showSpeakerLabels) {
            this.showSpeakerLabels = showSpeakerLabels;
            return this;
        }

        public final void setShowSpeakerLabels(Boolean showSpeakerLabels) {
            this.showSpeakerLabels = showSpeakerLabels;
        }

        public final Integer getMaxSpeakerLabels() {
            return maxSpeakerLabels;
        }

        @Override
        public final Builder maxSpeakerLabels(Integer maxSpeakerLabels) {
            this.maxSpeakerLabels = maxSpeakerLabels;
            return this;
        }

        public final void setMaxSpeakerLabels(Integer maxSpeakerLabels) {
            this.maxSpeakerLabels = maxSpeakerLabels;
        }

        public final Boolean getChannelIdentification() {
            return channelIdentification;
        }

        @Override
        public final Builder channelIdentification(Boolean channelIdentification) {
            this.channelIdentification = channelIdentification;
            return this;
        }

        public final void setChannelIdentification(Boolean channelIdentification) {
            this.channelIdentification = channelIdentification;
        }

        public final Boolean getShowAlternatives() {
            return showAlternatives;
        }

        @Override
        public final Builder showAlternatives(Boolean showAlternatives) {
            this.showAlternatives = showAlternatives;
            return this;
        }

        public final void setShowAlternatives(Boolean showAlternatives) {
            this.showAlternatives = showAlternatives;
        }

        public final Integer getMaxAlternatives() {
            return maxAlternatives;
        }

        @Override
        public final Builder maxAlternatives(Integer maxAlternatives) {
            this.maxAlternatives = maxAlternatives;
            return this;
        }

        public final void setMaxAlternatives(Integer maxAlternatives) {
            this.maxAlternatives = maxAlternatives;
        }

        public final String getVocabularyFilterName() {
            return vocabularyFilterName;
        }

        @Override
        public final Builder vocabularyFilterName(String vocabularyFilterName) {
            this.vocabularyFilterName = vocabularyFilterName;
            return this;
        }

        public final void setVocabularyFilterName(String vocabularyFilterName) {
            this.vocabularyFilterName = vocabularyFilterName;
        }

        public final String getVocabularyFilterMethodAsString() {
            return vocabularyFilterMethod;
        }

        @Override
        public final Builder vocabularyFilterMethod(String vocabularyFilterMethod) {
            this.vocabularyFilterMethod = vocabularyFilterMethod;
            return this;
        }

        @Override
        public final Builder vocabularyFilterMethod(VocabularyFilterMethod vocabularyFilterMethod) {
            this.vocabularyFilterMethod(vocabularyFilterMethod == null ? null : vocabularyFilterMethod.toString());
            return this;
        }

        public final void setVocabularyFilterMethod(String vocabularyFilterMethod) {
            this.vocabularyFilterMethod = vocabularyFilterMethod;
        }

        @Override
        public Settings build() {
            return new Settings(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
