/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.tnb.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Details related to problems with AWS TNB resources.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ProblemDetails implements SdkPojo, Serializable, ToCopyableBuilder<ProblemDetails.Builder, ProblemDetails> {
    private static final SdkField<String> DETAIL_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("detail")
            .getter(getter(ProblemDetails::detail)).setter(setter(Builder::detail))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("detail").build()).build();

    private static final SdkField<String> TITLE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("title")
            .getter(getter(ProblemDetails::title)).setter(setter(Builder::title))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("title").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DETAIL_FIELD, TITLE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String detail;

    private final String title;

    private ProblemDetails(BuilderImpl builder) {
        this.detail = builder.detail;
        this.title = builder.title;
    }

    /**
     * <p>
     * A human-readable explanation specific to this occurrence of the problem.
     * </p>
     * 
     * @return A human-readable explanation specific to this occurrence of the problem.
     */
    public final String detail() {
        return detail;
    }

    /**
     * <p>
     * A human-readable title of the problem type.
     * </p>
     * 
     * @return A human-readable title of the problem type.
     */
    public final String title() {
        return title;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(detail());
        hashCode = 31 * hashCode + Objects.hashCode(title());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ProblemDetails)) {
            return false;
        }
        ProblemDetails other = (ProblemDetails) obj;
        return Objects.equals(detail(), other.detail()) && Objects.equals(title(), other.title());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ProblemDetails").add("Detail", detail()).add("Title", title()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "detail":
            return Optional.ofNullable(clazz.cast(detail()));
        case "title":
            return Optional.ofNullable(clazz.cast(title()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("detail", DETAIL_FIELD);
        map.put("title", TITLE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ProblemDetails, T> g) {
        return obj -> g.apply((ProblemDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ProblemDetails> {
        /**
         * <p>
         * A human-readable explanation specific to this occurrence of the problem.
         * </p>
         * 
         * @param detail
         *        A human-readable explanation specific to this occurrence of the problem.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder detail(String detail);

        /**
         * <p>
         * A human-readable title of the problem type.
         * </p>
         * 
         * @param title
         *        A human-readable title of the problem type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder title(String title);
    }

    static final class BuilderImpl implements Builder {
        private String detail;

        private String title;

        private BuilderImpl() {
        }

        private BuilderImpl(ProblemDetails model) {
            detail(model.detail);
            title(model.title);
        }

        public final String getDetail() {
            return detail;
        }

        public final void setDetail(String detail) {
            this.detail = detail;
        }

        @Override
        public final Builder detail(String detail) {
            this.detail = detail;
            return this;
        }

        public final String getTitle() {
            return title;
        }

        public final void setTitle(String title) {
            this.title = title;
        }

        @Override
        public final Builder title(String title) {
            this.title = title;
            return this;
        }

        @Override
        public ProblemDetails build() {
            return new ProblemDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
