/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.tnb.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Gets the details of a network operation.
 * </p>
 * <p>
 * A network operation is any operation that is done to your network, such as network instance instantiation or
 * termination.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetSolNetworkOperationTaskDetails implements SdkPojo, Serializable,
        ToCopyableBuilder<GetSolNetworkOperationTaskDetails.Builder, GetSolNetworkOperationTaskDetails> {
    private static final SdkField<Map<String, String>> TASK_CONTEXT_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("taskContext")
            .getter(getter(GetSolNetworkOperationTaskDetails::taskContext))
            .setter(setter(Builder::taskContext))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("taskContext").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<Instant> TASK_END_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("taskEndTime")
            .getter(getter(GetSolNetworkOperationTaskDetails::taskEndTime))
            .setter(setter(Builder::taskEndTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("taskEndTime").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<ErrorInfo> TASK_ERROR_DETAILS_FIELD = SdkField.<ErrorInfo> builder(MarshallingType.SDK_POJO)
            .memberName("taskErrorDetails").getter(getter(GetSolNetworkOperationTaskDetails::taskErrorDetails))
            .setter(setter(Builder::taskErrorDetails)).constructor(ErrorInfo::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("taskErrorDetails").build()).build();

    private static final SdkField<String> TASK_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("taskName").getter(getter(GetSolNetworkOperationTaskDetails::taskName)).setter(setter(Builder::taskName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("taskName").build()).build();

    private static final SdkField<Instant> TASK_START_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("taskStartTime")
            .getter(getter(GetSolNetworkOperationTaskDetails::taskStartTime))
            .setter(setter(Builder::taskStartTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("taskStartTime").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<String> TASK_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("taskStatus").getter(getter(GetSolNetworkOperationTaskDetails::taskStatusAsString))
            .setter(setter(Builder::taskStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("taskStatus").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TASK_CONTEXT_FIELD,
            TASK_END_TIME_FIELD, TASK_ERROR_DETAILS_FIELD, TASK_NAME_FIELD, TASK_START_TIME_FIELD, TASK_STATUS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Map<String, String> taskContext;

    private final Instant taskEndTime;

    private final ErrorInfo taskErrorDetails;

    private final String taskName;

    private final Instant taskStartTime;

    private final String taskStatus;

    private GetSolNetworkOperationTaskDetails(BuilderImpl builder) {
        this.taskContext = builder.taskContext;
        this.taskEndTime = builder.taskEndTime;
        this.taskErrorDetails = builder.taskErrorDetails;
        this.taskName = builder.taskName;
        this.taskStartTime = builder.taskStartTime;
        this.taskStatus = builder.taskStatus;
    }

    /**
     * For responses, this returns true if the service returned a value for the TaskContext property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasTaskContext() {
        return taskContext != null && !(taskContext instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * Context for the network operation task.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTaskContext} method.
     * </p>
     * 
     * @return Context for the network operation task.
     */
    public final Map<String, String> taskContext() {
        return taskContext;
    }

    /**
     * <p>
     * Task end time.
     * </p>
     * 
     * @return Task end time.
     */
    public final Instant taskEndTime() {
        return taskEndTime;
    }

    /**
     * <p>
     * Task error details.
     * </p>
     * 
     * @return Task error details.
     */
    public final ErrorInfo taskErrorDetails() {
        return taskErrorDetails;
    }

    /**
     * <p>
     * Task name.
     * </p>
     * 
     * @return Task name.
     */
    public final String taskName() {
        return taskName;
    }

    /**
     * <p>
     * Task start time.
     * </p>
     * 
     * @return Task start time.
     */
    public final Instant taskStartTime() {
        return taskStartTime;
    }

    /**
     * <p>
     * Task status.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #taskStatus} will
     * return {@link TaskStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #taskStatusAsString}.
     * </p>
     * 
     * @return Task status.
     * @see TaskStatus
     */
    public final TaskStatus taskStatus() {
        return TaskStatus.fromValue(taskStatus);
    }

    /**
     * <p>
     * Task status.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #taskStatus} will
     * return {@link TaskStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #taskStatusAsString}.
     * </p>
     * 
     * @return Task status.
     * @see TaskStatus
     */
    public final String taskStatusAsString() {
        return taskStatus;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasTaskContext() ? taskContext() : null);
        hashCode = 31 * hashCode + Objects.hashCode(taskEndTime());
        hashCode = 31 * hashCode + Objects.hashCode(taskErrorDetails());
        hashCode = 31 * hashCode + Objects.hashCode(taskName());
        hashCode = 31 * hashCode + Objects.hashCode(taskStartTime());
        hashCode = 31 * hashCode + Objects.hashCode(taskStatusAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetSolNetworkOperationTaskDetails)) {
            return false;
        }
        GetSolNetworkOperationTaskDetails other = (GetSolNetworkOperationTaskDetails) obj;
        return hasTaskContext() == other.hasTaskContext() && Objects.equals(taskContext(), other.taskContext())
                && Objects.equals(taskEndTime(), other.taskEndTime())
                && Objects.equals(taskErrorDetails(), other.taskErrorDetails()) && Objects.equals(taskName(), other.taskName())
                && Objects.equals(taskStartTime(), other.taskStartTime())
                && Objects.equals(taskStatusAsString(), other.taskStatusAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetSolNetworkOperationTaskDetails").add("TaskContext", hasTaskContext() ? taskContext() : null)
                .add("TaskEndTime", taskEndTime()).add("TaskErrorDetails", taskErrorDetails()).add("TaskName", taskName())
                .add("TaskStartTime", taskStartTime()).add("TaskStatus", taskStatusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "taskContext":
            return Optional.ofNullable(clazz.cast(taskContext()));
        case "taskEndTime":
            return Optional.ofNullable(clazz.cast(taskEndTime()));
        case "taskErrorDetails":
            return Optional.ofNullable(clazz.cast(taskErrorDetails()));
        case "taskName":
            return Optional.ofNullable(clazz.cast(taskName()));
        case "taskStartTime":
            return Optional.ofNullable(clazz.cast(taskStartTime()));
        case "taskStatus":
            return Optional.ofNullable(clazz.cast(taskStatusAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("taskContext", TASK_CONTEXT_FIELD);
        map.put("taskEndTime", TASK_END_TIME_FIELD);
        map.put("taskErrorDetails", TASK_ERROR_DETAILS_FIELD);
        map.put("taskName", TASK_NAME_FIELD);
        map.put("taskStartTime", TASK_START_TIME_FIELD);
        map.put("taskStatus", TASK_STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetSolNetworkOperationTaskDetails, T> g) {
        return obj -> g.apply((GetSolNetworkOperationTaskDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, GetSolNetworkOperationTaskDetails> {
        /**
         * <p>
         * Context for the network operation task.
         * </p>
         * 
         * @param taskContext
         *        Context for the network operation task.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder taskContext(Map<String, String> taskContext);

        /**
         * <p>
         * Task end time.
         * </p>
         * 
         * @param taskEndTime
         *        Task end time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder taskEndTime(Instant taskEndTime);

        /**
         * <p>
         * Task error details.
         * </p>
         * 
         * @param taskErrorDetails
         *        Task error details.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder taskErrorDetails(ErrorInfo taskErrorDetails);

        /**
         * <p>
         * Task error details.
         * </p>
         * This is a convenience method that creates an instance of the {@link ErrorInfo.Builder} avoiding the need to
         * create one manually via {@link ErrorInfo#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ErrorInfo.Builder#build()} is called immediately and its result
         * is passed to {@link #taskErrorDetails(ErrorInfo)}.
         * 
         * @param taskErrorDetails
         *        a consumer that will call methods on {@link ErrorInfo.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #taskErrorDetails(ErrorInfo)
         */
        default Builder taskErrorDetails(Consumer<ErrorInfo.Builder> taskErrorDetails) {
            return taskErrorDetails(ErrorInfo.builder().applyMutation(taskErrorDetails).build());
        }

        /**
         * <p>
         * Task name.
         * </p>
         * 
         * @param taskName
         *        Task name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder taskName(String taskName);

        /**
         * <p>
         * Task start time.
         * </p>
         * 
         * @param taskStartTime
         *        Task start time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder taskStartTime(Instant taskStartTime);

        /**
         * <p>
         * Task status.
         * </p>
         * 
         * @param taskStatus
         *        Task status.
         * @see TaskStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TaskStatus
         */
        Builder taskStatus(String taskStatus);

        /**
         * <p>
         * Task status.
         * </p>
         * 
         * @param taskStatus
         *        Task status.
         * @see TaskStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TaskStatus
         */
        Builder taskStatus(TaskStatus taskStatus);
    }

    static final class BuilderImpl implements Builder {
        private Map<String, String> taskContext = DefaultSdkAutoConstructMap.getInstance();

        private Instant taskEndTime;

        private ErrorInfo taskErrorDetails;

        private String taskName;

        private Instant taskStartTime;

        private String taskStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(GetSolNetworkOperationTaskDetails model) {
            taskContext(model.taskContext);
            taskEndTime(model.taskEndTime);
            taskErrorDetails(model.taskErrorDetails);
            taskName(model.taskName);
            taskStartTime(model.taskStartTime);
            taskStatus(model.taskStatus);
        }

        public final Map<String, String> getTaskContext() {
            if (taskContext instanceof SdkAutoConstructMap) {
                return null;
            }
            return taskContext;
        }

        public final void setTaskContext(Map<String, String> taskContext) {
            this.taskContext = StringMapCopier.copy(taskContext);
        }

        @Override
        public final Builder taskContext(Map<String, String> taskContext) {
            this.taskContext = StringMapCopier.copy(taskContext);
            return this;
        }

        public final Instant getTaskEndTime() {
            return taskEndTime;
        }

        public final void setTaskEndTime(Instant taskEndTime) {
            this.taskEndTime = taskEndTime;
        }

        @Override
        public final Builder taskEndTime(Instant taskEndTime) {
            this.taskEndTime = taskEndTime;
            return this;
        }

        public final ErrorInfo.Builder getTaskErrorDetails() {
            return taskErrorDetails != null ? taskErrorDetails.toBuilder() : null;
        }

        public final void setTaskErrorDetails(ErrorInfo.BuilderImpl taskErrorDetails) {
            this.taskErrorDetails = taskErrorDetails != null ? taskErrorDetails.build() : null;
        }

        @Override
        public final Builder taskErrorDetails(ErrorInfo taskErrorDetails) {
            this.taskErrorDetails = taskErrorDetails;
            return this;
        }

        public final String getTaskName() {
            return taskName;
        }

        public final void setTaskName(String taskName) {
            this.taskName = taskName;
        }

        @Override
        public final Builder taskName(String taskName) {
            this.taskName = taskName;
            return this;
        }

        public final Instant getTaskStartTime() {
            return taskStartTime;
        }

        public final void setTaskStartTime(Instant taskStartTime) {
            this.taskStartTime = taskStartTime;
        }

        @Override
        public final Builder taskStartTime(Instant taskStartTime) {
            this.taskStartTime = taskStartTime;
            return this;
        }

        public final String getTaskStatus() {
            return taskStatus;
        }

        public final void setTaskStatus(String taskStatus) {
            this.taskStatus = taskStatus;
        }

        @Override
        public final Builder taskStatus(String taskStatus) {
            this.taskStatus = taskStatus;
            return this;
        }

        @Override
        public final Builder taskStatus(TaskStatus taskStatus) {
            this.taskStatus(taskStatus == null ? null : taskStatus.toString());
            return this;
        }

        @Override
        public GetSolNetworkOperationTaskDetails build() {
            return new GetSolNetworkOperationTaskDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
