/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.tnb.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum UsageState {
    IN_USE("IN_USE"),
    NOT_IN_USE("NOT_IN_USE"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, UsageState> VALUE_MAP;
    private final String value;

    private UsageState(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static UsageState fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<UsageState> knownValues() {
        EnumSet<UsageState> knownValues = EnumSet.allOf(UsageState.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(UsageState.class, UsageState::toString);
    }
}

