/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.tnb.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.tnb.model.PutSolNetworkPackageContentMetadata;
import software.amazon.awssdk.services.tnb.model.TnbResponse;
import software.amazon.awssdk.services.tnb.model.VnfPkgIdListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PutSolNetworkPackageContentResponse
extends TnbResponse
implements ToCopyableBuilder<Builder, PutSolNetworkPackageContentResponse> {
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("arn").getter(PutSolNetworkPackageContentResponse.getter(PutSolNetworkPackageContentResponse::arn)).setter(PutSolNetworkPackageContentResponse.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()}).build();
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("id").getter(PutSolNetworkPackageContentResponse.getter(PutSolNetworkPackageContentResponse::id)).setter(PutSolNetworkPackageContentResponse.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()}).build();
    private static final SdkField<PutSolNetworkPackageContentMetadata> METADATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("metadata").getter(PutSolNetworkPackageContentResponse.getter(PutSolNetworkPackageContentResponse::metadata)).setter(PutSolNetworkPackageContentResponse.setter(Builder::metadata)).constructor(PutSolNetworkPackageContentMetadata::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("metadata").build()}).build();
    private static final SdkField<String> NSD_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nsdId").getter(PutSolNetworkPackageContentResponse.getter(PutSolNetworkPackageContentResponse::nsdId)).setter(PutSolNetworkPackageContentResponse.setter(Builder::nsdId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nsdId").build()}).build();
    private static final SdkField<String> NSD_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nsdName").getter(PutSolNetworkPackageContentResponse.getter(PutSolNetworkPackageContentResponse::nsdName)).setter(PutSolNetworkPackageContentResponse.setter(Builder::nsdName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nsdName").build()}).build();
    private static final SdkField<String> NSD_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nsdVersion").getter(PutSolNetworkPackageContentResponse.getter(PutSolNetworkPackageContentResponse::nsdVersion)).setter(PutSolNetworkPackageContentResponse.setter(Builder::nsdVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nsdVersion").build()}).build();
    private static final SdkField<List<String>> VNF_PKG_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("vnfPkgIds").getter(PutSolNetworkPackageContentResponse.getter(PutSolNetworkPackageContentResponse::vnfPkgIds)).setter(PutSolNetworkPackageContentResponse.setter(Builder::vnfPkgIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vnfPkgIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, ID_FIELD, METADATA_FIELD, NSD_ID_FIELD, NSD_NAME_FIELD, NSD_VERSION_FIELD, VNF_PKG_IDS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = PutSolNetworkPackageContentResponse.memberNameToFieldInitializer();
    private final String arn;
    private final String id;
    private final PutSolNetworkPackageContentMetadata metadata;
    private final String nsdId;
    private final String nsdName;
    private final String nsdVersion;
    private final List<String> vnfPkgIds;

    private PutSolNetworkPackageContentResponse(BuilderImpl builder) {
        super(builder);
        this.arn = builder.arn;
        this.id = builder.id;
        this.metadata = builder.metadata;
        this.nsdId = builder.nsdId;
        this.nsdName = builder.nsdName;
        this.nsdVersion = builder.nsdVersion;
        this.vnfPkgIds = builder.vnfPkgIds;
    }

    public final String arn() {
        return this.arn;
    }

    public final String id() {
        return this.id;
    }

    public final PutSolNetworkPackageContentMetadata metadata() {
        return this.metadata;
    }

    public final String nsdId() {
        return this.nsdId;
    }

    public final String nsdName() {
        return this.nsdName;
    }

    public final String nsdVersion() {
        return this.nsdVersion;
    }

    public final boolean hasVnfPkgIds() {
        return this.vnfPkgIds != null && !(this.vnfPkgIds instanceof SdkAutoConstructList);
    }

    public final List<String> vnfPkgIds() {
        return this.vnfPkgIds;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.metadata());
        hashCode = 31 * hashCode + Objects.hashCode(this.nsdId());
        hashCode = 31 * hashCode + Objects.hashCode(this.nsdName());
        hashCode = 31 * hashCode + Objects.hashCode(this.nsdVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasVnfPkgIds() ? this.vnfPkgIds() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutSolNetworkPackageContentResponse)) {
            return false;
        }
        PutSolNetworkPackageContentResponse other = (PutSolNetworkPackageContentResponse)((Object)obj);
        return Objects.equals(this.arn(), other.arn()) && Objects.equals(this.id(), other.id()) && Objects.equals(this.metadata(), other.metadata()) && Objects.equals(this.nsdId(), other.nsdId()) && Objects.equals(this.nsdName(), other.nsdName()) && Objects.equals(this.nsdVersion(), other.nsdVersion()) && this.hasVnfPkgIds() == other.hasVnfPkgIds() && Objects.equals(this.vnfPkgIds(), other.vnfPkgIds());
    }

    public final String toString() {
        return ToString.builder((String)"PutSolNetworkPackageContentResponse").add("Arn", (Object)this.arn()).add("Id", (Object)this.id()).add("Metadata", (Object)this.metadata()).add("NsdId", (Object)this.nsdId()).add("NsdName", (Object)this.nsdName()).add("NsdVersion", (Object)this.nsdVersion()).add("VnfPkgIds", this.hasVnfPkgIds() ? this.vnfPkgIds() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "metadata": {
                return Optional.ofNullable(clazz.cast(this.metadata()));
            }
            case "nsdId": {
                return Optional.ofNullable(clazz.cast(this.nsdId()));
            }
            case "nsdName": {
                return Optional.ofNullable(clazz.cast(this.nsdName()));
            }
            case "nsdVersion": {
                return Optional.ofNullable(clazz.cast(this.nsdVersion()));
            }
            case "vnfPkgIds": {
                return Optional.ofNullable(clazz.cast(this.vnfPkgIds()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("arn", ARN_FIELD);
        map.put("id", ID_FIELD);
        map.put("metadata", METADATA_FIELD);
        map.put("nsdId", NSD_ID_FIELD);
        map.put("nsdName", NSD_NAME_FIELD);
        map.put("nsdVersion", NSD_VERSION_FIELD);
        map.put("vnfPkgIds", VNF_PKG_IDS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PutSolNetworkPackageContentResponse, T> g) {
        return obj -> g.apply((PutSolNetworkPackageContentResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends TnbResponse.BuilderImpl
    implements Builder {
        private String arn;
        private String id;
        private PutSolNetworkPackageContentMetadata metadata;
        private String nsdId;
        private String nsdName;
        private String nsdVersion;
        private List<String> vnfPkgIds = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(PutSolNetworkPackageContentResponse model) {
            super(model);
            this.arn(model.arn);
            this.id(model.id);
            this.metadata(model.metadata);
            this.nsdId(model.nsdId);
            this.nsdName(model.nsdName);
            this.nsdVersion(model.nsdVersion);
            this.vnfPkgIds(model.vnfPkgIds);
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final PutSolNetworkPackageContentMetadata.Builder getMetadata() {
            return this.metadata != null ? this.metadata.toBuilder() : null;
        }

        public final void setMetadata(PutSolNetworkPackageContentMetadata.BuilderImpl metadata) {
            this.metadata = metadata != null ? metadata.build() : null;
        }

        @Override
        public final Builder metadata(PutSolNetworkPackageContentMetadata metadata) {
            this.metadata = metadata;
            return this;
        }

        public final String getNsdId() {
            return this.nsdId;
        }

        public final void setNsdId(String nsdId) {
            this.nsdId = nsdId;
        }

        @Override
        public final Builder nsdId(String nsdId) {
            this.nsdId = nsdId;
            return this;
        }

        public final String getNsdName() {
            return this.nsdName;
        }

        public final void setNsdName(String nsdName) {
            this.nsdName = nsdName;
        }

        @Override
        public final Builder nsdName(String nsdName) {
            this.nsdName = nsdName;
            return this;
        }

        public final String getNsdVersion() {
            return this.nsdVersion;
        }

        public final void setNsdVersion(String nsdVersion) {
            this.nsdVersion = nsdVersion;
        }

        @Override
        public final Builder nsdVersion(String nsdVersion) {
            this.nsdVersion = nsdVersion;
            return this;
        }

        public final Collection<String> getVnfPkgIds() {
            if (this.vnfPkgIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.vnfPkgIds;
        }

        public final void setVnfPkgIds(Collection<String> vnfPkgIds) {
            this.vnfPkgIds = VnfPkgIdListCopier.copy(vnfPkgIds);
        }

        @Override
        public final Builder vnfPkgIds(Collection<String> vnfPkgIds) {
            this.vnfPkgIds = VnfPkgIdListCopier.copy(vnfPkgIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder vnfPkgIds(String ... vnfPkgIds) {
            this.vnfPkgIds(Arrays.asList(vnfPkgIds));
            return this;
        }

        @Override
        public PutSolNetworkPackageContentResponse build() {
            return new PutSolNetworkPackageContentResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends TnbResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, PutSolNetworkPackageContentResponse> {
        public Builder arn(String var1);

        public Builder id(String var1);

        public Builder metadata(PutSolNetworkPackageContentMetadata var1);

        default public Builder metadata(Consumer<PutSolNetworkPackageContentMetadata.Builder> metadata) {
            return this.metadata((PutSolNetworkPackageContentMetadata)((PutSolNetworkPackageContentMetadata.Builder)PutSolNetworkPackageContentMetadata.builder().applyMutation(metadata)).build());
        }

        public Builder nsdId(String var1);

        public Builder nsdName(String var1);

        public Builder nsdVersion(String var1);

        public Builder vnfPkgIds(Collection<String> var1);

        public Builder vnfPkgIds(String ... var1);
    }
}

