/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.tnb.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.tnb.TnbAsyncClient;
import software.amazon.awssdk.services.tnb.internal.UserAgentUtils;
import software.amazon.awssdk.services.tnb.model.ListSolNetworkOperationsInfo;
import software.amazon.awssdk.services.tnb.model.ListSolNetworkOperationsRequest;
import software.amazon.awssdk.services.tnb.model.ListSolNetworkOperationsResponse;

public class ListSolNetworkOperationsPublisher
implements SdkPublisher<ListSolNetworkOperationsResponse> {
    private final TnbAsyncClient client;
    private final ListSolNetworkOperationsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListSolNetworkOperationsPublisher(TnbAsyncClient client, ListSolNetworkOperationsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListSolNetworkOperationsPublisher(TnbAsyncClient client, ListSolNetworkOperationsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListSolNetworkOperationsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListSolNetworkOperationsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<ListSolNetworkOperationsInfo> networkOperations() {
        Function<ListSolNetworkOperationsResponse, Iterator> getIterator = response -> {
            if (response != null && response.networkOperations() != null) {
                return response.networkOperations().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListSolNetworkOperationsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListSolNetworkOperationsResponseFetcher
    implements AsyncPageFetcher<ListSolNetworkOperationsResponse> {
        private ListSolNetworkOperationsResponseFetcher() {
        }

        public boolean hasNextPage(ListSolNetworkOperationsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListSolNetworkOperationsResponse> nextPage(ListSolNetworkOperationsResponse previousPage) {
            if (previousPage == null) {
                return ListSolNetworkOperationsPublisher.this.client.listSolNetworkOperations(ListSolNetworkOperationsPublisher.this.firstRequest);
            }
            return ListSolNetworkOperationsPublisher.this.client.listSolNetworkOperations((ListSolNetworkOperationsRequest)((Object)ListSolNetworkOperationsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

