/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.tnb.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.tnb.model.DescriptorContentType;
import software.amazon.awssdk.services.tnb.model.TnbRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetSolFunctionPackageDescriptorRequest
extends TnbRequest
implements ToCopyableBuilder<Builder, GetSolFunctionPackageDescriptorRequest> {
    private static final SdkField<String> ACCEPT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("accept").getter(GetSolFunctionPackageDescriptorRequest.getter(GetSolFunctionPackageDescriptorRequest::acceptAsString)).setter(GetSolFunctionPackageDescriptorRequest.setter(Builder::accept)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.HEADER).locationName("Accept").build()}).build();
    private static final SdkField<String> VNF_PKG_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("vnfPkgId").getter(GetSolFunctionPackageDescriptorRequest.getter(GetSolFunctionPackageDescriptorRequest::vnfPkgId)).setter(GetSolFunctionPackageDescriptorRequest.setter(Builder::vnfPkgId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("vnfPkgId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCEPT_FIELD, VNF_PKG_ID_FIELD));
    private final String accept;
    private final String vnfPkgId;

    private GetSolFunctionPackageDescriptorRequest(BuilderImpl builder) {
        super(builder);
        this.accept = builder.accept;
        this.vnfPkgId = builder.vnfPkgId;
    }

    public final DescriptorContentType accept() {
        return DescriptorContentType.fromValue(this.accept);
    }

    public final String acceptAsString() {
        return this.accept;
    }

    public final String vnfPkgId() {
        return this.vnfPkgId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.acceptAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.vnfPkgId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetSolFunctionPackageDescriptorRequest)) {
            return false;
        }
        GetSolFunctionPackageDescriptorRequest other = (GetSolFunctionPackageDescriptorRequest)((Object)obj);
        return Objects.equals(this.acceptAsString(), other.acceptAsString()) && Objects.equals(this.vnfPkgId(), other.vnfPkgId());
    }

    public final String toString() {
        return ToString.builder((String)"GetSolFunctionPackageDescriptorRequest").add("Accept", (Object)this.acceptAsString()).add("VnfPkgId", (Object)this.vnfPkgId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "accept": {
                return Optional.ofNullable(clazz.cast(this.acceptAsString()));
            }
            case "vnfPkgId": {
                return Optional.ofNullable(clazz.cast(this.vnfPkgId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetSolFunctionPackageDescriptorRequest, T> g) {
        return obj -> g.apply((GetSolFunctionPackageDescriptorRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends TnbRequest.BuilderImpl
    implements Builder {
        private String accept;
        private String vnfPkgId;

        private BuilderImpl() {
        }

        private BuilderImpl(GetSolFunctionPackageDescriptorRequest model) {
            super(model);
            this.accept(model.accept);
            this.vnfPkgId(model.vnfPkgId);
        }

        public final String getAccept() {
            return this.accept;
        }

        public final void setAccept(String accept) {
            this.accept = accept;
        }

        @Override
        public final Builder accept(String accept) {
            this.accept = accept;
            return this;
        }

        @Override
        public final Builder accept(DescriptorContentType accept) {
            this.accept(accept == null ? null : accept.toString());
            return this;
        }

        public final String getVnfPkgId() {
            return this.vnfPkgId;
        }

        public final void setVnfPkgId(String vnfPkgId) {
            this.vnfPkgId = vnfPkgId;
        }

        @Override
        public final Builder vnfPkgId(String vnfPkgId) {
            this.vnfPkgId = vnfPkgId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetSolFunctionPackageDescriptorRequest build() {
            return new GetSolFunctionPackageDescriptorRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends TnbRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetSolFunctionPackageDescriptorRequest> {
        public Builder accept(String var1);

        public Builder accept(DescriptorContentType var1);

        public Builder vnfPkgId(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

