/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.tnb.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.tnb.model.GetSolNetworkInstanceMetadata;
import software.amazon.awssdk.services.tnb.model.LcmOperationInfo;
import software.amazon.awssdk.services.tnb.model.NsState;
import software.amazon.awssdk.services.tnb.model.TagMapCopier;
import software.amazon.awssdk.services.tnb.model.TnbResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetSolNetworkInstanceResponse
extends TnbResponse
implements ToCopyableBuilder<Builder, GetSolNetworkInstanceResponse> {
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("arn").getter(GetSolNetworkInstanceResponse.getter(GetSolNetworkInstanceResponse::arn)).setter(GetSolNetworkInstanceResponse.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()}).build();
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("id").getter(GetSolNetworkInstanceResponse.getter(GetSolNetworkInstanceResponse::id)).setter(GetSolNetworkInstanceResponse.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()}).build();
    private static final SdkField<LcmOperationInfo> LCM_OP_INFO_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("lcmOpInfo").getter(GetSolNetworkInstanceResponse.getter(GetSolNetworkInstanceResponse::lcmOpInfo)).setter(GetSolNetworkInstanceResponse.setter(Builder::lcmOpInfo)).constructor(LcmOperationInfo::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lcmOpInfo").build()}).build();
    private static final SdkField<GetSolNetworkInstanceMetadata> METADATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("metadata").getter(GetSolNetworkInstanceResponse.getter(GetSolNetworkInstanceResponse::metadata)).setter(GetSolNetworkInstanceResponse.setter(Builder::metadata)).constructor(GetSolNetworkInstanceMetadata::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("metadata").build()}).build();
    private static final SdkField<String> NS_INSTANCE_DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nsInstanceDescription").getter(GetSolNetworkInstanceResponse.getter(GetSolNetworkInstanceResponse::nsInstanceDescription)).setter(GetSolNetworkInstanceResponse.setter(Builder::nsInstanceDescription)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nsInstanceDescription").build()}).build();
    private static final SdkField<String> NS_INSTANCE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nsInstanceName").getter(GetSolNetworkInstanceResponse.getter(GetSolNetworkInstanceResponse::nsInstanceName)).setter(GetSolNetworkInstanceResponse.setter(Builder::nsInstanceName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nsInstanceName").build()}).build();
    private static final SdkField<String> NS_STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nsState").getter(GetSolNetworkInstanceResponse.getter(GetSolNetworkInstanceResponse::nsStateAsString)).setter(GetSolNetworkInstanceResponse.setter(Builder::nsState)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nsState").build()}).build();
    private static final SdkField<String> NSD_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nsdId").getter(GetSolNetworkInstanceResponse.getter(GetSolNetworkInstanceResponse::nsdId)).setter(GetSolNetworkInstanceResponse.setter(Builder::nsdId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nsdId").build()}).build();
    private static final SdkField<String> NSD_INFO_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nsdInfoId").getter(GetSolNetworkInstanceResponse.getter(GetSolNetworkInstanceResponse::nsdInfoId)).setter(GetSolNetworkInstanceResponse.setter(Builder::nsdInfoId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nsdInfoId").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("tags").getter(GetSolNetworkInstanceResponse.getter(GetSolNetworkInstanceResponse::tags)).setter(GetSolNetworkInstanceResponse.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, ID_FIELD, LCM_OP_INFO_FIELD, METADATA_FIELD, NS_INSTANCE_DESCRIPTION_FIELD, NS_INSTANCE_NAME_FIELD, NS_STATE_FIELD, NSD_ID_FIELD, NSD_INFO_ID_FIELD, TAGS_FIELD));
    private final String arn;
    private final String id;
    private final LcmOperationInfo lcmOpInfo;
    private final GetSolNetworkInstanceMetadata metadata;
    private final String nsInstanceDescription;
    private final String nsInstanceName;
    private final String nsState;
    private final String nsdId;
    private final String nsdInfoId;
    private final Map<String, String> tags;

    private GetSolNetworkInstanceResponse(BuilderImpl builder) {
        super(builder);
        this.arn = builder.arn;
        this.id = builder.id;
        this.lcmOpInfo = builder.lcmOpInfo;
        this.metadata = builder.metadata;
        this.nsInstanceDescription = builder.nsInstanceDescription;
        this.nsInstanceName = builder.nsInstanceName;
        this.nsState = builder.nsState;
        this.nsdId = builder.nsdId;
        this.nsdInfoId = builder.nsdInfoId;
        this.tags = builder.tags;
    }

    public final String arn() {
        return this.arn;
    }

    public final String id() {
        return this.id;
    }

    public final LcmOperationInfo lcmOpInfo() {
        return this.lcmOpInfo;
    }

    public final GetSolNetworkInstanceMetadata metadata() {
        return this.metadata;
    }

    public final String nsInstanceDescription() {
        return this.nsInstanceDescription;
    }

    public final String nsInstanceName() {
        return this.nsInstanceName;
    }

    public final NsState nsState() {
        return NsState.fromValue(this.nsState);
    }

    public final String nsStateAsString() {
        return this.nsState;
    }

    public final String nsdId() {
        return this.nsdId;
    }

    public final String nsdInfoId() {
        return this.nsdInfoId;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.lcmOpInfo());
        hashCode = 31 * hashCode + Objects.hashCode(this.metadata());
        hashCode = 31 * hashCode + Objects.hashCode(this.nsInstanceDescription());
        hashCode = 31 * hashCode + Objects.hashCode(this.nsInstanceName());
        hashCode = 31 * hashCode + Objects.hashCode(this.nsStateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.nsdId());
        hashCode = 31 * hashCode + Objects.hashCode(this.nsdInfoId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetSolNetworkInstanceResponse)) {
            return false;
        }
        GetSolNetworkInstanceResponse other = (GetSolNetworkInstanceResponse)((Object)obj);
        return Objects.equals(this.arn(), other.arn()) && Objects.equals(this.id(), other.id()) && Objects.equals(this.lcmOpInfo(), other.lcmOpInfo()) && Objects.equals(this.metadata(), other.metadata()) && Objects.equals(this.nsInstanceDescription(), other.nsInstanceDescription()) && Objects.equals(this.nsInstanceName(), other.nsInstanceName()) && Objects.equals(this.nsStateAsString(), other.nsStateAsString()) && Objects.equals(this.nsdId(), other.nsdId()) && Objects.equals(this.nsdInfoId(), other.nsdInfoId()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"GetSolNetworkInstanceResponse").add("Arn", (Object)this.arn()).add("Id", (Object)this.id()).add("LcmOpInfo", (Object)this.lcmOpInfo()).add("Metadata", (Object)this.metadata()).add("NsInstanceDescription", (Object)this.nsInstanceDescription()).add("NsInstanceName", (Object)this.nsInstanceName()).add("NsState", (Object)this.nsStateAsString()).add("NsdId", (Object)this.nsdId()).add("NsdInfoId", (Object)this.nsdInfoId()).add("Tags", (Object)(this.tags() == null ? null : "*** Sensitive Data Redacted ***")).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "lcmOpInfo": {
                return Optional.ofNullable(clazz.cast(this.lcmOpInfo()));
            }
            case "metadata": {
                return Optional.ofNullable(clazz.cast(this.metadata()));
            }
            case "nsInstanceDescription": {
                return Optional.ofNullable(clazz.cast(this.nsInstanceDescription()));
            }
            case "nsInstanceName": {
                return Optional.ofNullable(clazz.cast(this.nsInstanceName()));
            }
            case "nsState": {
                return Optional.ofNullable(clazz.cast(this.nsStateAsString()));
            }
            case "nsdId": {
                return Optional.ofNullable(clazz.cast(this.nsdId()));
            }
            case "nsdInfoId": {
                return Optional.ofNullable(clazz.cast(this.nsdInfoId()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetSolNetworkInstanceResponse, T> g) {
        return obj -> g.apply((GetSolNetworkInstanceResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends TnbResponse.BuilderImpl
    implements Builder {
        private String arn;
        private String id;
        private LcmOperationInfo lcmOpInfo;
        private GetSolNetworkInstanceMetadata metadata;
        private String nsInstanceDescription;
        private String nsInstanceName;
        private String nsState;
        private String nsdId;
        private String nsdInfoId;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetSolNetworkInstanceResponse model) {
            super(model);
            this.arn(model.arn);
            this.id(model.id);
            this.lcmOpInfo(model.lcmOpInfo);
            this.metadata(model.metadata);
            this.nsInstanceDescription(model.nsInstanceDescription);
            this.nsInstanceName(model.nsInstanceName);
            this.nsState(model.nsState);
            this.nsdId(model.nsdId);
            this.nsdInfoId(model.nsdInfoId);
            this.tags(model.tags);
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final LcmOperationInfo.Builder getLcmOpInfo() {
            return this.lcmOpInfo != null ? this.lcmOpInfo.toBuilder() : null;
        }

        public final void setLcmOpInfo(LcmOperationInfo.BuilderImpl lcmOpInfo) {
            this.lcmOpInfo = lcmOpInfo != null ? lcmOpInfo.build() : null;
        }

        @Override
        public final Builder lcmOpInfo(LcmOperationInfo lcmOpInfo) {
            this.lcmOpInfo = lcmOpInfo;
            return this;
        }

        public final GetSolNetworkInstanceMetadata.Builder getMetadata() {
            return this.metadata != null ? this.metadata.toBuilder() : null;
        }

        public final void setMetadata(GetSolNetworkInstanceMetadata.BuilderImpl metadata) {
            this.metadata = metadata != null ? metadata.build() : null;
        }

        @Override
        public final Builder metadata(GetSolNetworkInstanceMetadata metadata) {
            this.metadata = metadata;
            return this;
        }

        public final String getNsInstanceDescription() {
            return this.nsInstanceDescription;
        }

        public final void setNsInstanceDescription(String nsInstanceDescription) {
            this.nsInstanceDescription = nsInstanceDescription;
        }

        @Override
        public final Builder nsInstanceDescription(String nsInstanceDescription) {
            this.nsInstanceDescription = nsInstanceDescription;
            return this;
        }

        public final String getNsInstanceName() {
            return this.nsInstanceName;
        }

        public final void setNsInstanceName(String nsInstanceName) {
            this.nsInstanceName = nsInstanceName;
        }

        @Override
        public final Builder nsInstanceName(String nsInstanceName) {
            this.nsInstanceName = nsInstanceName;
            return this;
        }

        public final String getNsState() {
            return this.nsState;
        }

        public final void setNsState(String nsState) {
            this.nsState = nsState;
        }

        @Override
        public final Builder nsState(String nsState) {
            this.nsState = nsState;
            return this;
        }

        @Override
        public final Builder nsState(NsState nsState) {
            this.nsState(nsState == null ? null : nsState.toString());
            return this;
        }

        public final String getNsdId() {
            return this.nsdId;
        }

        public final void setNsdId(String nsdId) {
            this.nsdId = nsdId;
        }

        @Override
        public final Builder nsdId(String nsdId) {
            this.nsdId = nsdId;
            return this;
        }

        public final String getNsdInfoId() {
            return this.nsdInfoId;
        }

        public final void setNsdInfoId(String nsdInfoId) {
            this.nsdInfoId = nsdInfoId;
        }

        @Override
        public final Builder nsdInfoId(String nsdInfoId) {
            this.nsdInfoId = nsdInfoId;
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        @Override
        public GetSolNetworkInstanceResponse build() {
            return new GetSolNetworkInstanceResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends TnbResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetSolNetworkInstanceResponse> {
        public Builder arn(String var1);

        public Builder id(String var1);

        public Builder lcmOpInfo(LcmOperationInfo var1);

        default public Builder lcmOpInfo(Consumer<LcmOperationInfo.Builder> lcmOpInfo) {
            return this.lcmOpInfo((LcmOperationInfo)((LcmOperationInfo.Builder)LcmOperationInfo.builder().applyMutation(lcmOpInfo)).build());
        }

        public Builder metadata(GetSolNetworkInstanceMetadata var1);

        default public Builder metadata(Consumer<GetSolNetworkInstanceMetadata.Builder> metadata) {
            return this.metadata((GetSolNetworkInstanceMetadata)((GetSolNetworkInstanceMetadata.Builder)GetSolNetworkInstanceMetadata.builder().applyMutation(metadata)).build());
        }

        public Builder nsInstanceDescription(String var1);

        public Builder nsInstanceName(String var1);

        public Builder nsState(String var1);

        public Builder nsState(NsState var1);

        public Builder nsdId(String var1);

        public Builder nsdInfoId(String var1);

        public Builder tags(Map<String, String> var1);
    }
}

