/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.timestreamwrite.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A delimited data format where the column separator can be a comma and the record separator is a newline character.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CsvConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<CsvConfiguration.Builder, CsvConfiguration> {
    private static final SdkField<String> COLUMN_SEPARATOR_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ColumnSeparator").getter(getter(CsvConfiguration::columnSeparator))
            .setter(setter(Builder::columnSeparator))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ColumnSeparator").build()).build();

    private static final SdkField<String> ESCAPE_CHAR_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EscapeChar").getter(getter(CsvConfiguration::escapeChar)).setter(setter(Builder::escapeChar))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EscapeChar").build()).build();

    private static final SdkField<String> QUOTE_CHAR_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("QuoteChar").getter(getter(CsvConfiguration::quoteChar)).setter(setter(Builder::quoteChar))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QuoteChar").build()).build();

    private static final SdkField<String> NULL_VALUE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NullValue").getter(getter(CsvConfiguration::nullValue)).setter(setter(Builder::nullValue))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NullValue").build()).build();

    private static final SdkField<Boolean> TRIM_WHITE_SPACE_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("TrimWhiteSpace").getter(getter(CsvConfiguration::trimWhiteSpace))
            .setter(setter(Builder::trimWhiteSpace))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrimWhiteSpace").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COLUMN_SEPARATOR_FIELD,
            ESCAPE_CHAR_FIELD, QUOTE_CHAR_FIELD, NULL_VALUE_FIELD, TRIM_WHITE_SPACE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String columnSeparator;

    private final String escapeChar;

    private final String quoteChar;

    private final String nullValue;

    private final Boolean trimWhiteSpace;

    private CsvConfiguration(BuilderImpl builder) {
        this.columnSeparator = builder.columnSeparator;
        this.escapeChar = builder.escapeChar;
        this.quoteChar = builder.quoteChar;
        this.nullValue = builder.nullValue;
        this.trimWhiteSpace = builder.trimWhiteSpace;
    }

    /**
     * <p>
     * Column separator can be one of comma (','), pipe ('|), semicolon (';'), tab('/t'), or blank space (' ').
     * </p>
     * 
     * @return Column separator can be one of comma (','), pipe ('|), semicolon (';'), tab('/t'), or blank space (' ').
     */
    public final String columnSeparator() {
        return columnSeparator;
    }

    /**
     * <p>
     * Escape character can be one of
     * </p>
     * 
     * @return Escape character can be one of
     */
    public final String escapeChar() {
        return escapeChar;
    }

    /**
     * <p>
     * Can be single quote (') or double quote (").
     * </p>
     * 
     * @return Can be single quote (') or double quote (").
     */
    public final String quoteChar() {
        return quoteChar;
    }

    /**
     * <p>
     * Can be blank space (' ').
     * </p>
     * 
     * @return Can be blank space (' ').
     */
    public final String nullValue() {
        return nullValue;
    }

    /**
     * <p>
     * Specifies to trim leading and trailing white space.
     * </p>
     * 
     * @return Specifies to trim leading and trailing white space.
     */
    public final Boolean trimWhiteSpace() {
        return trimWhiteSpace;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(columnSeparator());
        hashCode = 31 * hashCode + Objects.hashCode(escapeChar());
        hashCode = 31 * hashCode + Objects.hashCode(quoteChar());
        hashCode = 31 * hashCode + Objects.hashCode(nullValue());
        hashCode = 31 * hashCode + Objects.hashCode(trimWhiteSpace());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CsvConfiguration)) {
            return false;
        }
        CsvConfiguration other = (CsvConfiguration) obj;
        return Objects.equals(columnSeparator(), other.columnSeparator()) && Objects.equals(escapeChar(), other.escapeChar())
                && Objects.equals(quoteChar(), other.quoteChar()) && Objects.equals(nullValue(), other.nullValue())
                && Objects.equals(trimWhiteSpace(), other.trimWhiteSpace());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CsvConfiguration").add("ColumnSeparator", columnSeparator()).add("EscapeChar", escapeChar())
                .add("QuoteChar", quoteChar()).add("NullValue", nullValue()).add("TrimWhiteSpace", trimWhiteSpace()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ColumnSeparator":
            return Optional.ofNullable(clazz.cast(columnSeparator()));
        case "EscapeChar":
            return Optional.ofNullable(clazz.cast(escapeChar()));
        case "QuoteChar":
            return Optional.ofNullable(clazz.cast(quoteChar()));
        case "NullValue":
            return Optional.ofNullable(clazz.cast(nullValue()));
        case "TrimWhiteSpace":
            return Optional.ofNullable(clazz.cast(trimWhiteSpace()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ColumnSeparator", COLUMN_SEPARATOR_FIELD);
        map.put("EscapeChar", ESCAPE_CHAR_FIELD);
        map.put("QuoteChar", QUOTE_CHAR_FIELD);
        map.put("NullValue", NULL_VALUE_FIELD);
        map.put("TrimWhiteSpace", TRIM_WHITE_SPACE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CsvConfiguration, T> g) {
        return obj -> g.apply((CsvConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CsvConfiguration> {
        /**
         * <p>
         * Column separator can be one of comma (','), pipe ('|), semicolon (';'), tab('/t'), or blank space (' ').
         * </p>
         * 
         * @param columnSeparator
         *        Column separator can be one of comma (','), pipe ('|), semicolon (';'), tab('/t'), or blank space
         *        (' ').
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder columnSeparator(String columnSeparator);

        /**
         * <p>
         * Escape character can be one of
         * </p>
         * 
         * @param escapeChar
         *        Escape character can be one of
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder escapeChar(String escapeChar);

        /**
         * <p>
         * Can be single quote (') or double quote (").
         * </p>
         * 
         * @param quoteChar
         *        Can be single quote (') or double quote (").
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder quoteChar(String quoteChar);

        /**
         * <p>
         * Can be blank space (' ').
         * </p>
         * 
         * @param nullValue
         *        Can be blank space (' ').
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nullValue(String nullValue);

        /**
         * <p>
         * Specifies to trim leading and trailing white space.
         * </p>
         * 
         * @param trimWhiteSpace
         *        Specifies to trim leading and trailing white space.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder trimWhiteSpace(Boolean trimWhiteSpace);
    }

    static final class BuilderImpl implements Builder {
        private String columnSeparator;

        private String escapeChar;

        private String quoteChar;

        private String nullValue;

        private Boolean trimWhiteSpace;

        private BuilderImpl() {
        }

        private BuilderImpl(CsvConfiguration model) {
            columnSeparator(model.columnSeparator);
            escapeChar(model.escapeChar);
            quoteChar(model.quoteChar);
            nullValue(model.nullValue);
            trimWhiteSpace(model.trimWhiteSpace);
        }

        public final String getColumnSeparator() {
            return columnSeparator;
        }

        public final void setColumnSeparator(String columnSeparator) {
            this.columnSeparator = columnSeparator;
        }

        @Override
        public final Builder columnSeparator(String columnSeparator) {
            this.columnSeparator = columnSeparator;
            return this;
        }

        public final String getEscapeChar() {
            return escapeChar;
        }

        public final void setEscapeChar(String escapeChar) {
            this.escapeChar = escapeChar;
        }

        @Override
        public final Builder escapeChar(String escapeChar) {
            this.escapeChar = escapeChar;
            return this;
        }

        public final String getQuoteChar() {
            return quoteChar;
        }

        public final void setQuoteChar(String quoteChar) {
            this.quoteChar = quoteChar;
        }

        @Override
        public final Builder quoteChar(String quoteChar) {
            this.quoteChar = quoteChar;
            return this;
        }

        public final String getNullValue() {
            return nullValue;
        }

        public final void setNullValue(String nullValue) {
            this.nullValue = nullValue;
        }

        @Override
        public final Builder nullValue(String nullValue) {
            this.nullValue = nullValue;
            return this;
        }

        public final Boolean getTrimWhiteSpace() {
            return trimWhiteSpace;
        }

        public final void setTrimWhiteSpace(Boolean trimWhiteSpace) {
            this.trimWhiteSpace = trimWhiteSpace;
        }

        @Override
        public final Builder trimWhiteSpace(Boolean trimWhiteSpace) {
            this.trimWhiteSpace = trimWhiteSpace;
            return this;
        }

        @Override
        public CsvConfiguration build() {
            return new CsvConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
