/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.timestreamwrite;

import java.net.URI;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.awscore.client.handler.AwsAsyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.ApiName;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.client.handler.AsyncClientHandler;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.endpointdiscovery.EndpointDiscoveryCacheLoader;
import software.amazon.awssdk.core.endpointdiscovery.EndpointDiscoveryRefreshCache;
import software.amazon.awssdk.core.endpointdiscovery.EndpointDiscoveryRequest;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.metrics.NoOpMetricCollector;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.services.timestreamwrite.TimestreamWriteAsyncClient;
import software.amazon.awssdk.services.timestreamwrite.TimestreamWriteAsyncEndpointDiscoveryCacheLoader;
import software.amazon.awssdk.services.timestreamwrite.model.AccessDeniedException;
import software.amazon.awssdk.services.timestreamwrite.model.ConflictException;
import software.amazon.awssdk.services.timestreamwrite.model.CreateDatabaseRequest;
import software.amazon.awssdk.services.timestreamwrite.model.CreateDatabaseResponse;
import software.amazon.awssdk.services.timestreamwrite.model.CreateTableRequest;
import software.amazon.awssdk.services.timestreamwrite.model.CreateTableResponse;
import software.amazon.awssdk.services.timestreamwrite.model.DeleteDatabaseRequest;
import software.amazon.awssdk.services.timestreamwrite.model.DeleteDatabaseResponse;
import software.amazon.awssdk.services.timestreamwrite.model.DeleteTableRequest;
import software.amazon.awssdk.services.timestreamwrite.model.DeleteTableResponse;
import software.amazon.awssdk.services.timestreamwrite.model.DescribeDatabaseRequest;
import software.amazon.awssdk.services.timestreamwrite.model.DescribeDatabaseResponse;
import software.amazon.awssdk.services.timestreamwrite.model.DescribeEndpointsRequest;
import software.amazon.awssdk.services.timestreamwrite.model.DescribeEndpointsResponse;
import software.amazon.awssdk.services.timestreamwrite.model.DescribeTableRequest;
import software.amazon.awssdk.services.timestreamwrite.model.DescribeTableResponse;
import software.amazon.awssdk.services.timestreamwrite.model.InternalServerException;
import software.amazon.awssdk.services.timestreamwrite.model.InvalidEndpointException;
import software.amazon.awssdk.services.timestreamwrite.model.ListDatabasesRequest;
import software.amazon.awssdk.services.timestreamwrite.model.ListDatabasesResponse;
import software.amazon.awssdk.services.timestreamwrite.model.ListTablesRequest;
import software.amazon.awssdk.services.timestreamwrite.model.ListTablesResponse;
import software.amazon.awssdk.services.timestreamwrite.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.timestreamwrite.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.timestreamwrite.model.RejectedRecordsException;
import software.amazon.awssdk.services.timestreamwrite.model.ResourceNotFoundException;
import software.amazon.awssdk.services.timestreamwrite.model.ServiceQuotaExceededException;
import software.amazon.awssdk.services.timestreamwrite.model.TagResourceRequest;
import software.amazon.awssdk.services.timestreamwrite.model.TagResourceResponse;
import software.amazon.awssdk.services.timestreamwrite.model.ThrottlingException;
import software.amazon.awssdk.services.timestreamwrite.model.TimestreamWriteException;
import software.amazon.awssdk.services.timestreamwrite.model.TimestreamWriteRequest;
import software.amazon.awssdk.services.timestreamwrite.model.UntagResourceRequest;
import software.amazon.awssdk.services.timestreamwrite.model.UntagResourceResponse;
import software.amazon.awssdk.services.timestreamwrite.model.UpdateDatabaseRequest;
import software.amazon.awssdk.services.timestreamwrite.model.UpdateDatabaseResponse;
import software.amazon.awssdk.services.timestreamwrite.model.UpdateTableRequest;
import software.amazon.awssdk.services.timestreamwrite.model.UpdateTableResponse;
import software.amazon.awssdk.services.timestreamwrite.model.ValidationException;
import software.amazon.awssdk.services.timestreamwrite.model.WriteRecordsRequest;
import software.amazon.awssdk.services.timestreamwrite.model.WriteRecordsResponse;
import software.amazon.awssdk.services.timestreamwrite.paginators.ListDatabasesPublisher;
import software.amazon.awssdk.services.timestreamwrite.paginators.ListTablesPublisher;
import software.amazon.awssdk.services.timestreamwrite.transform.CreateDatabaseRequestMarshaller;
import software.amazon.awssdk.services.timestreamwrite.transform.CreateTableRequestMarshaller;
import software.amazon.awssdk.services.timestreamwrite.transform.DeleteDatabaseRequestMarshaller;
import software.amazon.awssdk.services.timestreamwrite.transform.DeleteTableRequestMarshaller;
import software.amazon.awssdk.services.timestreamwrite.transform.DescribeDatabaseRequestMarshaller;
import software.amazon.awssdk.services.timestreamwrite.transform.DescribeEndpointsRequestMarshaller;
import software.amazon.awssdk.services.timestreamwrite.transform.DescribeTableRequestMarshaller;
import software.amazon.awssdk.services.timestreamwrite.transform.ListDatabasesRequestMarshaller;
import software.amazon.awssdk.services.timestreamwrite.transform.ListTablesRequestMarshaller;
import software.amazon.awssdk.services.timestreamwrite.transform.ListTagsForResourceRequestMarshaller;
import software.amazon.awssdk.services.timestreamwrite.transform.TagResourceRequestMarshaller;
import software.amazon.awssdk.services.timestreamwrite.transform.UntagResourceRequestMarshaller;
import software.amazon.awssdk.services.timestreamwrite.transform.UpdateDatabaseRequestMarshaller;
import software.amazon.awssdk.services.timestreamwrite.transform.UpdateTableRequestMarshaller;
import software.amazon.awssdk.services.timestreamwrite.transform.WriteRecordsRequestMarshaller;
import software.amazon.awssdk.utils.CompletableFutureUtils;

@SdkInternalApi
final class DefaultTimestreamWriteAsyncClient
implements TimestreamWriteAsyncClient {
    private static final Logger log = LoggerFactory.getLogger(DefaultTimestreamWriteAsyncClient.class);
    private final AsyncClientHandler clientHandler;
    private final AwsJsonProtocolFactory protocolFactory;
    private final SdkClientConfiguration clientConfiguration;
    private EndpointDiscoveryRefreshCache endpointDiscoveryCache;

    protected DefaultTimestreamWriteAsyncClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsAsyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration;
        this.protocolFactory = this.init(AwsJsonProtocolFactory.builder()).build();
        if (((Boolean)clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_DISCOVERY_ENABLED)).booleanValue()) {
            this.endpointDiscoveryCache = EndpointDiscoveryRefreshCache.create((EndpointDiscoveryCacheLoader)TimestreamWriteAsyncEndpointDiscoveryCacheLoader.create(this));
            if (clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN) == Boolean.TRUE) {
                log.warn("Endpoint discovery is enabled for this client, and an endpoint override was also specified. This will disable endpoint discovery for methods that require it, instead using the specified endpoint override. This may or may not be what you intended.");
            }
        }
    }

    public final String serviceName() {
        return "timestream";
    }

    @Override
    public CompletableFuture<CreateDatabaseResponse> createDatabase(CreateDatabaseRequest createDatabaseRequest) {
        List<MetricPublisher> metricPublishers = DefaultTimestreamWriteAsyncClient.resolveMetricPublishers(this.clientConfiguration, createDatabaseRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            boolean endpointOverridden;
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Timestream Write");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateDatabase");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateDatabaseResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            boolean endpointDiscoveryEnabled = (Boolean)this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_DISCOVERY_ENABLED);
            boolean bl = endpointOverridden = this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN) == Boolean.TRUE;
            if (endpointOverridden) {
                endpointDiscoveryEnabled = false;
            } else if (!endpointDiscoveryEnabled) {
                throw new IllegalStateException("This operation requires endpoint discovery to be enabled, or for you to specify an endpoint override when the client is created.");
            }
            URI cachedEndpoint = null;
            if (endpointDiscoveryEnabled) {
                String key = createDatabaseRequest.overrideConfiguration().flatMap(AwsRequestOverrideConfiguration::credentialsProvider).orElseGet(() -> (AwsCredentialsProvider)this.clientConfiguration.option((ClientOption)AwsClientOption.CREDENTIALS_PROVIDER)).resolveCredentials().accessKeyId();
                EndpointDiscoveryRequest endpointDiscoveryRequest = (EndpointDiscoveryRequest)EndpointDiscoveryRequest.builder().required(true).defaultEndpoint((URI)this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT)).overrideConfiguration((RequestOverrideConfiguration)createDatabaseRequest.overrideConfiguration().orElse(null)).build();
                cachedEndpoint = this.endpointDiscoveryCache.get(key, endpointDiscoveryRequest);
            }
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateDatabase").withMarshaller((Marshaller)new CreateDatabaseRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).discoveredEndpoint(cachedEndpoint).withInput((SdkRequest)createDatabaseRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultTimestreamWriteAsyncClient.lambda$createDatabase$2(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultTimestreamWriteAsyncClient.lambda$createDatabase$3((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CreateTableResponse> createTable(CreateTableRequest createTableRequest) {
        List<MetricPublisher> metricPublishers = DefaultTimestreamWriteAsyncClient.resolveMetricPublishers(this.clientConfiguration, createTableRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            boolean endpointOverridden;
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Timestream Write");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateTable");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateTableResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            boolean endpointDiscoveryEnabled = (Boolean)this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_DISCOVERY_ENABLED);
            boolean bl = endpointOverridden = this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN) == Boolean.TRUE;
            if (endpointOverridden) {
                endpointDiscoveryEnabled = false;
            } else if (!endpointDiscoveryEnabled) {
                throw new IllegalStateException("This operation requires endpoint discovery to be enabled, or for you to specify an endpoint override when the client is created.");
            }
            URI cachedEndpoint = null;
            if (endpointDiscoveryEnabled) {
                String key = createTableRequest.overrideConfiguration().flatMap(AwsRequestOverrideConfiguration::credentialsProvider).orElseGet(() -> (AwsCredentialsProvider)this.clientConfiguration.option((ClientOption)AwsClientOption.CREDENTIALS_PROVIDER)).resolveCredentials().accessKeyId();
                EndpointDiscoveryRequest endpointDiscoveryRequest = (EndpointDiscoveryRequest)EndpointDiscoveryRequest.builder().required(true).defaultEndpoint((URI)this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT)).overrideConfiguration((RequestOverrideConfiguration)createTableRequest.overrideConfiguration().orElse(null)).build();
                cachedEndpoint = this.endpointDiscoveryCache.get(key, endpointDiscoveryRequest);
            }
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateTable").withMarshaller((Marshaller)new CreateTableRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).discoveredEndpoint(cachedEndpoint).withInput((SdkRequest)createTableRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultTimestreamWriteAsyncClient.lambda$createTable$6(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultTimestreamWriteAsyncClient.lambda$createTable$7((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteDatabaseResponse> deleteDatabase(DeleteDatabaseRequest deleteDatabaseRequest) {
        List<MetricPublisher> metricPublishers = DefaultTimestreamWriteAsyncClient.resolveMetricPublishers(this.clientConfiguration, deleteDatabaseRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            boolean endpointOverridden;
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Timestream Write");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteDatabase");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteDatabaseResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            boolean endpointDiscoveryEnabled = (Boolean)this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_DISCOVERY_ENABLED);
            boolean bl = endpointOverridden = this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN) == Boolean.TRUE;
            if (endpointOverridden) {
                endpointDiscoveryEnabled = false;
            } else if (!endpointDiscoveryEnabled) {
                throw new IllegalStateException("This operation requires endpoint discovery to be enabled, or for you to specify an endpoint override when the client is created.");
            }
            URI cachedEndpoint = null;
            if (endpointDiscoveryEnabled) {
                String key = deleteDatabaseRequest.overrideConfiguration().flatMap(AwsRequestOverrideConfiguration::credentialsProvider).orElseGet(() -> (AwsCredentialsProvider)this.clientConfiguration.option((ClientOption)AwsClientOption.CREDENTIALS_PROVIDER)).resolveCredentials().accessKeyId();
                EndpointDiscoveryRequest endpointDiscoveryRequest = (EndpointDiscoveryRequest)EndpointDiscoveryRequest.builder().required(true).defaultEndpoint((URI)this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT)).overrideConfiguration((RequestOverrideConfiguration)deleteDatabaseRequest.overrideConfiguration().orElse(null)).build();
                cachedEndpoint = this.endpointDiscoveryCache.get(key, endpointDiscoveryRequest);
            }
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteDatabase").withMarshaller((Marshaller)new DeleteDatabaseRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).discoveredEndpoint(cachedEndpoint).withInput((SdkRequest)deleteDatabaseRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultTimestreamWriteAsyncClient.lambda$deleteDatabase$10(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultTimestreamWriteAsyncClient.lambda$deleteDatabase$11((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteTableResponse> deleteTable(DeleteTableRequest deleteTableRequest) {
        List<MetricPublisher> metricPublishers = DefaultTimestreamWriteAsyncClient.resolveMetricPublishers(this.clientConfiguration, deleteTableRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            boolean endpointOverridden;
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Timestream Write");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteTable");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteTableResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            boolean endpointDiscoveryEnabled = (Boolean)this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_DISCOVERY_ENABLED);
            boolean bl = endpointOverridden = this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN) == Boolean.TRUE;
            if (endpointOverridden) {
                endpointDiscoveryEnabled = false;
            } else if (!endpointDiscoveryEnabled) {
                throw new IllegalStateException("This operation requires endpoint discovery to be enabled, or for you to specify an endpoint override when the client is created.");
            }
            URI cachedEndpoint = null;
            if (endpointDiscoveryEnabled) {
                String key = deleteTableRequest.overrideConfiguration().flatMap(AwsRequestOverrideConfiguration::credentialsProvider).orElseGet(() -> (AwsCredentialsProvider)this.clientConfiguration.option((ClientOption)AwsClientOption.CREDENTIALS_PROVIDER)).resolveCredentials().accessKeyId();
                EndpointDiscoveryRequest endpointDiscoveryRequest = (EndpointDiscoveryRequest)EndpointDiscoveryRequest.builder().required(true).defaultEndpoint((URI)this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT)).overrideConfiguration((RequestOverrideConfiguration)deleteTableRequest.overrideConfiguration().orElse(null)).build();
                cachedEndpoint = this.endpointDiscoveryCache.get(key, endpointDiscoveryRequest);
            }
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteTable").withMarshaller((Marshaller)new DeleteTableRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).discoveredEndpoint(cachedEndpoint).withInput((SdkRequest)deleteTableRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultTimestreamWriteAsyncClient.lambda$deleteTable$14(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultTimestreamWriteAsyncClient.lambda$deleteTable$15((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DescribeDatabaseResponse> describeDatabase(DescribeDatabaseRequest describeDatabaseRequest) {
        List<MetricPublisher> metricPublishers = DefaultTimestreamWriteAsyncClient.resolveMetricPublishers(this.clientConfiguration, describeDatabaseRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            boolean endpointOverridden;
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Timestream Write");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeDatabase");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeDatabaseResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            boolean endpointDiscoveryEnabled = (Boolean)this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_DISCOVERY_ENABLED);
            boolean bl = endpointOverridden = this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN) == Boolean.TRUE;
            if (endpointOverridden) {
                endpointDiscoveryEnabled = false;
            } else if (!endpointDiscoveryEnabled) {
                throw new IllegalStateException("This operation requires endpoint discovery to be enabled, or for you to specify an endpoint override when the client is created.");
            }
            URI cachedEndpoint = null;
            if (endpointDiscoveryEnabled) {
                String key = describeDatabaseRequest.overrideConfiguration().flatMap(AwsRequestOverrideConfiguration::credentialsProvider).orElseGet(() -> (AwsCredentialsProvider)this.clientConfiguration.option((ClientOption)AwsClientOption.CREDENTIALS_PROVIDER)).resolveCredentials().accessKeyId();
                EndpointDiscoveryRequest endpointDiscoveryRequest = (EndpointDiscoveryRequest)EndpointDiscoveryRequest.builder().required(true).defaultEndpoint((URI)this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT)).overrideConfiguration((RequestOverrideConfiguration)describeDatabaseRequest.overrideConfiguration().orElse(null)).build();
                cachedEndpoint = this.endpointDiscoveryCache.get(key, endpointDiscoveryRequest);
            }
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeDatabase").withMarshaller((Marshaller)new DescribeDatabaseRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).discoveredEndpoint(cachedEndpoint).withInput((SdkRequest)describeDatabaseRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultTimestreamWriteAsyncClient.lambda$describeDatabase$18(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultTimestreamWriteAsyncClient.lambda$describeDatabase$19((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DescribeEndpointsResponse> describeEndpoints(DescribeEndpointsRequest describeEndpointsRequest) {
        List<MetricPublisher> metricPublishers = DefaultTimestreamWriteAsyncClient.resolveMetricPublishers(this.clientConfiguration, describeEndpointsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Timestream Write");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeEndpoints");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeEndpointsResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeEndpoints").withMarshaller((Marshaller)new DescribeEndpointsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)describeEndpointsRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultTimestreamWriteAsyncClient.lambda$describeEndpoints$21(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultTimestreamWriteAsyncClient.lambda$describeEndpoints$22((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DescribeTableResponse> describeTable(DescribeTableRequest describeTableRequest) {
        List<MetricPublisher> metricPublishers = DefaultTimestreamWriteAsyncClient.resolveMetricPublishers(this.clientConfiguration, describeTableRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            boolean endpointOverridden;
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Timestream Write");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeTable");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeTableResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            boolean endpointDiscoveryEnabled = (Boolean)this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_DISCOVERY_ENABLED);
            boolean bl = endpointOverridden = this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN) == Boolean.TRUE;
            if (endpointOverridden) {
                endpointDiscoveryEnabled = false;
            } else if (!endpointDiscoveryEnabled) {
                throw new IllegalStateException("This operation requires endpoint discovery to be enabled, or for you to specify an endpoint override when the client is created.");
            }
            URI cachedEndpoint = null;
            if (endpointDiscoveryEnabled) {
                String key = describeTableRequest.overrideConfiguration().flatMap(AwsRequestOverrideConfiguration::credentialsProvider).orElseGet(() -> (AwsCredentialsProvider)this.clientConfiguration.option((ClientOption)AwsClientOption.CREDENTIALS_PROVIDER)).resolveCredentials().accessKeyId();
                EndpointDiscoveryRequest endpointDiscoveryRequest = (EndpointDiscoveryRequest)EndpointDiscoveryRequest.builder().required(true).defaultEndpoint((URI)this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT)).overrideConfiguration((RequestOverrideConfiguration)describeTableRequest.overrideConfiguration().orElse(null)).build();
                cachedEndpoint = this.endpointDiscoveryCache.get(key, endpointDiscoveryRequest);
            }
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeTable").withMarshaller((Marshaller)new DescribeTableRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).discoveredEndpoint(cachedEndpoint).withInput((SdkRequest)describeTableRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultTimestreamWriteAsyncClient.lambda$describeTable$25(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultTimestreamWriteAsyncClient.lambda$describeTable$26((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ListDatabasesResponse> listDatabases(ListDatabasesRequest listDatabasesRequest) {
        List<MetricPublisher> metricPublishers = DefaultTimestreamWriteAsyncClient.resolveMetricPublishers(this.clientConfiguration, listDatabasesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            boolean endpointOverridden;
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Timestream Write");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListDatabases");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListDatabasesResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            boolean endpointDiscoveryEnabled = (Boolean)this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_DISCOVERY_ENABLED);
            boolean bl = endpointOverridden = this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN) == Boolean.TRUE;
            if (endpointOverridden) {
                endpointDiscoveryEnabled = false;
            } else if (!endpointDiscoveryEnabled) {
                throw new IllegalStateException("This operation requires endpoint discovery to be enabled, or for you to specify an endpoint override when the client is created.");
            }
            URI cachedEndpoint = null;
            if (endpointDiscoveryEnabled) {
                String key = listDatabasesRequest.overrideConfiguration().flatMap(AwsRequestOverrideConfiguration::credentialsProvider).orElseGet(() -> (AwsCredentialsProvider)this.clientConfiguration.option((ClientOption)AwsClientOption.CREDENTIALS_PROVIDER)).resolveCredentials().accessKeyId();
                EndpointDiscoveryRequest endpointDiscoveryRequest = (EndpointDiscoveryRequest)EndpointDiscoveryRequest.builder().required(true).defaultEndpoint((URI)this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT)).overrideConfiguration((RequestOverrideConfiguration)listDatabasesRequest.overrideConfiguration().orElse(null)).build();
                cachedEndpoint = this.endpointDiscoveryCache.get(key, endpointDiscoveryRequest);
            }
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListDatabases").withMarshaller((Marshaller)new ListDatabasesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).discoveredEndpoint(cachedEndpoint).withInput((SdkRequest)listDatabasesRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultTimestreamWriteAsyncClient.lambda$listDatabases$29(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultTimestreamWriteAsyncClient.lambda$listDatabases$30((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public ListDatabasesPublisher listDatabasesPaginator(ListDatabasesRequest listDatabasesRequest) {
        return new ListDatabasesPublisher(this, this.applyPaginatorUserAgent(listDatabasesRequest));
    }

    @Override
    public CompletableFuture<ListTablesResponse> listTables(ListTablesRequest listTablesRequest) {
        List<MetricPublisher> metricPublishers = DefaultTimestreamWriteAsyncClient.resolveMetricPublishers(this.clientConfiguration, listTablesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            boolean endpointOverridden;
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Timestream Write");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListTables");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListTablesResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            boolean endpointDiscoveryEnabled = (Boolean)this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_DISCOVERY_ENABLED);
            boolean bl = endpointOverridden = this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN) == Boolean.TRUE;
            if (endpointOverridden) {
                endpointDiscoveryEnabled = false;
            } else if (!endpointDiscoveryEnabled) {
                throw new IllegalStateException("This operation requires endpoint discovery to be enabled, or for you to specify an endpoint override when the client is created.");
            }
            URI cachedEndpoint = null;
            if (endpointDiscoveryEnabled) {
                String key = listTablesRequest.overrideConfiguration().flatMap(AwsRequestOverrideConfiguration::credentialsProvider).orElseGet(() -> (AwsCredentialsProvider)this.clientConfiguration.option((ClientOption)AwsClientOption.CREDENTIALS_PROVIDER)).resolveCredentials().accessKeyId();
                EndpointDiscoveryRequest endpointDiscoveryRequest = (EndpointDiscoveryRequest)EndpointDiscoveryRequest.builder().required(true).defaultEndpoint((URI)this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT)).overrideConfiguration((RequestOverrideConfiguration)listTablesRequest.overrideConfiguration().orElse(null)).build();
                cachedEndpoint = this.endpointDiscoveryCache.get(key, endpointDiscoveryRequest);
            }
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListTables").withMarshaller((Marshaller)new ListTablesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).discoveredEndpoint(cachedEndpoint).withInput((SdkRequest)listTablesRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultTimestreamWriteAsyncClient.lambda$listTables$33(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultTimestreamWriteAsyncClient.lambda$listTables$34((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public ListTablesPublisher listTablesPaginator(ListTablesRequest listTablesRequest) {
        return new ListTablesPublisher(this, this.applyPaginatorUserAgent(listTablesRequest));
    }

    @Override
    public CompletableFuture<ListTagsForResourceResponse> listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest) {
        List<MetricPublisher> metricPublishers = DefaultTimestreamWriteAsyncClient.resolveMetricPublishers(this.clientConfiguration, listTagsForResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            boolean endpointOverridden;
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Timestream Write");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListTagsForResource");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListTagsForResourceResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            boolean endpointDiscoveryEnabled = (Boolean)this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_DISCOVERY_ENABLED);
            boolean bl = endpointOverridden = this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN) == Boolean.TRUE;
            if (endpointOverridden) {
                endpointDiscoveryEnabled = false;
            } else if (!endpointDiscoveryEnabled) {
                throw new IllegalStateException("This operation requires endpoint discovery to be enabled, or for you to specify an endpoint override when the client is created.");
            }
            URI cachedEndpoint = null;
            if (endpointDiscoveryEnabled) {
                String key = listTagsForResourceRequest.overrideConfiguration().flatMap(AwsRequestOverrideConfiguration::credentialsProvider).orElseGet(() -> (AwsCredentialsProvider)this.clientConfiguration.option((ClientOption)AwsClientOption.CREDENTIALS_PROVIDER)).resolveCredentials().accessKeyId();
                EndpointDiscoveryRequest endpointDiscoveryRequest = (EndpointDiscoveryRequest)EndpointDiscoveryRequest.builder().required(true).defaultEndpoint((URI)this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT)).overrideConfiguration((RequestOverrideConfiguration)listTagsForResourceRequest.overrideConfiguration().orElse(null)).build();
                cachedEndpoint = this.endpointDiscoveryCache.get(key, endpointDiscoveryRequest);
            }
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListTagsForResource").withMarshaller((Marshaller)new ListTagsForResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).discoveredEndpoint(cachedEndpoint).withInput((SdkRequest)listTagsForResourceRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultTimestreamWriteAsyncClient.lambda$listTagsForResource$37(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultTimestreamWriteAsyncClient.lambda$listTagsForResource$38((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<TagResourceResponse> tagResource(TagResourceRequest tagResourceRequest) {
        List<MetricPublisher> metricPublishers = DefaultTimestreamWriteAsyncClient.resolveMetricPublishers(this.clientConfiguration, tagResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            boolean endpointOverridden;
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Timestream Write");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"TagResource");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, TagResourceResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            boolean endpointDiscoveryEnabled = (Boolean)this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_DISCOVERY_ENABLED);
            boolean bl = endpointOverridden = this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN) == Boolean.TRUE;
            if (endpointOverridden) {
                endpointDiscoveryEnabled = false;
            } else if (!endpointDiscoveryEnabled) {
                throw new IllegalStateException("This operation requires endpoint discovery to be enabled, or for you to specify an endpoint override when the client is created.");
            }
            URI cachedEndpoint = null;
            if (endpointDiscoveryEnabled) {
                String key = tagResourceRequest.overrideConfiguration().flatMap(AwsRequestOverrideConfiguration::credentialsProvider).orElseGet(() -> (AwsCredentialsProvider)this.clientConfiguration.option((ClientOption)AwsClientOption.CREDENTIALS_PROVIDER)).resolveCredentials().accessKeyId();
                EndpointDiscoveryRequest endpointDiscoveryRequest = (EndpointDiscoveryRequest)EndpointDiscoveryRequest.builder().required(true).defaultEndpoint((URI)this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT)).overrideConfiguration((RequestOverrideConfiguration)tagResourceRequest.overrideConfiguration().orElse(null)).build();
                cachedEndpoint = this.endpointDiscoveryCache.get(key, endpointDiscoveryRequest);
            }
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("TagResource").withMarshaller((Marshaller)new TagResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).discoveredEndpoint(cachedEndpoint).withInput((SdkRequest)tagResourceRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultTimestreamWriteAsyncClient.lambda$tagResource$41(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultTimestreamWriteAsyncClient.lambda$tagResource$42((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<UntagResourceResponse> untagResource(UntagResourceRequest untagResourceRequest) {
        List<MetricPublisher> metricPublishers = DefaultTimestreamWriteAsyncClient.resolveMetricPublishers(this.clientConfiguration, untagResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            boolean endpointOverridden;
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Timestream Write");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UntagResource");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UntagResourceResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            boolean endpointDiscoveryEnabled = (Boolean)this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_DISCOVERY_ENABLED);
            boolean bl = endpointOverridden = this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN) == Boolean.TRUE;
            if (endpointOverridden) {
                endpointDiscoveryEnabled = false;
            } else if (!endpointDiscoveryEnabled) {
                throw new IllegalStateException("This operation requires endpoint discovery to be enabled, or for you to specify an endpoint override when the client is created.");
            }
            URI cachedEndpoint = null;
            if (endpointDiscoveryEnabled) {
                String key = untagResourceRequest.overrideConfiguration().flatMap(AwsRequestOverrideConfiguration::credentialsProvider).orElseGet(() -> (AwsCredentialsProvider)this.clientConfiguration.option((ClientOption)AwsClientOption.CREDENTIALS_PROVIDER)).resolveCredentials().accessKeyId();
                EndpointDiscoveryRequest endpointDiscoveryRequest = (EndpointDiscoveryRequest)EndpointDiscoveryRequest.builder().required(true).defaultEndpoint((URI)this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT)).overrideConfiguration((RequestOverrideConfiguration)untagResourceRequest.overrideConfiguration().orElse(null)).build();
                cachedEndpoint = this.endpointDiscoveryCache.get(key, endpointDiscoveryRequest);
            }
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("UntagResource").withMarshaller((Marshaller)new UntagResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).discoveredEndpoint(cachedEndpoint).withInput((SdkRequest)untagResourceRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultTimestreamWriteAsyncClient.lambda$untagResource$45(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultTimestreamWriteAsyncClient.lambda$untagResource$46((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<UpdateDatabaseResponse> updateDatabase(UpdateDatabaseRequest updateDatabaseRequest) {
        List<MetricPublisher> metricPublishers = DefaultTimestreamWriteAsyncClient.resolveMetricPublishers(this.clientConfiguration, updateDatabaseRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            boolean endpointOverridden;
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Timestream Write");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateDatabase");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateDatabaseResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            boolean endpointDiscoveryEnabled = (Boolean)this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_DISCOVERY_ENABLED);
            boolean bl = endpointOverridden = this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN) == Boolean.TRUE;
            if (endpointOverridden) {
                endpointDiscoveryEnabled = false;
            } else if (!endpointDiscoveryEnabled) {
                throw new IllegalStateException("This operation requires endpoint discovery to be enabled, or for you to specify an endpoint override when the client is created.");
            }
            URI cachedEndpoint = null;
            if (endpointDiscoveryEnabled) {
                String key = updateDatabaseRequest.overrideConfiguration().flatMap(AwsRequestOverrideConfiguration::credentialsProvider).orElseGet(() -> (AwsCredentialsProvider)this.clientConfiguration.option((ClientOption)AwsClientOption.CREDENTIALS_PROVIDER)).resolveCredentials().accessKeyId();
                EndpointDiscoveryRequest endpointDiscoveryRequest = (EndpointDiscoveryRequest)EndpointDiscoveryRequest.builder().required(true).defaultEndpoint((URI)this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT)).overrideConfiguration((RequestOverrideConfiguration)updateDatabaseRequest.overrideConfiguration().orElse(null)).build();
                cachedEndpoint = this.endpointDiscoveryCache.get(key, endpointDiscoveryRequest);
            }
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateDatabase").withMarshaller((Marshaller)new UpdateDatabaseRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).discoveredEndpoint(cachedEndpoint).withInput((SdkRequest)updateDatabaseRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultTimestreamWriteAsyncClient.lambda$updateDatabase$49(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultTimestreamWriteAsyncClient.lambda$updateDatabase$50((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<UpdateTableResponse> updateTable(UpdateTableRequest updateTableRequest) {
        List<MetricPublisher> metricPublishers = DefaultTimestreamWriteAsyncClient.resolveMetricPublishers(this.clientConfiguration, updateTableRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            boolean endpointOverridden;
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Timestream Write");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateTable");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateTableResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            boolean endpointDiscoveryEnabled = (Boolean)this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_DISCOVERY_ENABLED);
            boolean bl = endpointOverridden = this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN) == Boolean.TRUE;
            if (endpointOverridden) {
                endpointDiscoveryEnabled = false;
            } else if (!endpointDiscoveryEnabled) {
                throw new IllegalStateException("This operation requires endpoint discovery to be enabled, or for you to specify an endpoint override when the client is created.");
            }
            URI cachedEndpoint = null;
            if (endpointDiscoveryEnabled) {
                String key = updateTableRequest.overrideConfiguration().flatMap(AwsRequestOverrideConfiguration::credentialsProvider).orElseGet(() -> (AwsCredentialsProvider)this.clientConfiguration.option((ClientOption)AwsClientOption.CREDENTIALS_PROVIDER)).resolveCredentials().accessKeyId();
                EndpointDiscoveryRequest endpointDiscoveryRequest = (EndpointDiscoveryRequest)EndpointDiscoveryRequest.builder().required(true).defaultEndpoint((URI)this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT)).overrideConfiguration((RequestOverrideConfiguration)updateTableRequest.overrideConfiguration().orElse(null)).build();
                cachedEndpoint = this.endpointDiscoveryCache.get(key, endpointDiscoveryRequest);
            }
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateTable").withMarshaller((Marshaller)new UpdateTableRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).discoveredEndpoint(cachedEndpoint).withInput((SdkRequest)updateTableRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultTimestreamWriteAsyncClient.lambda$updateTable$53(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultTimestreamWriteAsyncClient.lambda$updateTable$54((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<WriteRecordsResponse> writeRecords(WriteRecordsRequest writeRecordsRequest) {
        List<MetricPublisher> metricPublishers = DefaultTimestreamWriteAsyncClient.resolveMetricPublishers(this.clientConfiguration, writeRecordsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            boolean endpointOverridden;
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Timestream Write");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"WriteRecords");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, WriteRecordsResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            boolean endpointDiscoveryEnabled = (Boolean)this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_DISCOVERY_ENABLED);
            boolean bl = endpointOverridden = this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN) == Boolean.TRUE;
            if (endpointOverridden) {
                endpointDiscoveryEnabled = false;
            } else if (!endpointDiscoveryEnabled) {
                throw new IllegalStateException("This operation requires endpoint discovery to be enabled, or for you to specify an endpoint override when the client is created.");
            }
            URI cachedEndpoint = null;
            if (endpointDiscoveryEnabled) {
                String key = writeRecordsRequest.overrideConfiguration().flatMap(AwsRequestOverrideConfiguration::credentialsProvider).orElseGet(() -> (AwsCredentialsProvider)this.clientConfiguration.option((ClientOption)AwsClientOption.CREDENTIALS_PROVIDER)).resolveCredentials().accessKeyId();
                EndpointDiscoveryRequest endpointDiscoveryRequest = (EndpointDiscoveryRequest)EndpointDiscoveryRequest.builder().required(true).defaultEndpoint((URI)this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT)).overrideConfiguration((RequestOverrideConfiguration)writeRecordsRequest.overrideConfiguration().orElse(null)).build();
                cachedEndpoint = this.endpointDiscoveryCache.get(key, endpointDiscoveryRequest);
            }
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("WriteRecords").withMarshaller((Marshaller)new WriteRecordsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).discoveredEndpoint(cachedEndpoint).withInput((SdkRequest)writeRecordsRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultTimestreamWriteAsyncClient.lambda$writeRecords$57(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultTimestreamWriteAsyncClient.lambda$writeRecords$58((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    public void close() {
        this.clientHandler.close();
    }

    private <T extends BaseAwsJsonProtocolFactory.Builder<T>> T init(T builder) {
        return (T)builder.clientConfiguration(this.clientConfiguration).defaultServiceExceptionSupplier(TimestreamWriteException::builder).protocol(AwsJsonProtocol.AWS_JSON).protocolVersion("1.0").registerModeledException(ExceptionMetadata.builder().errorCode("AccessDeniedException").exceptionBuilderSupplier(AccessDeniedException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ConflictException").exceptionBuilderSupplier(ConflictException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidEndpointException").exceptionBuilderSupplier(InvalidEndpointException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").exceptionBuilderSupplier(ResourceNotFoundException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ThrottlingException").exceptionBuilderSupplier(ThrottlingException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ValidationException").exceptionBuilderSupplier(ValidationException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InternalServerException").exceptionBuilderSupplier(InternalServerException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("RejectedRecordsException").exceptionBuilderSupplier(RejectedRecordsException::builder).build());
    }

    private static List<MetricPublisher> resolveMetricPublishers(SdkClientConfiguration clientConfiguration, RequestOverrideConfiguration requestOverrideConfiguration) {
        List<MetricPublisher> publishers = null;
        if (requestOverrideConfiguration != null) {
            publishers = requestOverrideConfiguration.metricPublishers();
        }
        if (publishers == null || publishers.isEmpty()) {
            publishers = (List)clientConfiguration.option((ClientOption)SdkClientOption.METRIC_PUBLISHERS);
        }
        if (publishers == null) {
            publishers = Collections.emptyList();
        }
        return publishers;
    }

    private <T extends TimestreamWriteRequest> T applyPaginatorUserAgent(T request) {
        Consumer<AwsRequestOverrideConfiguration.Builder> userAgentApplier = b -> {
            AwsRequestOverrideConfiguration.Builder cfr_ignored_0 = (AwsRequestOverrideConfiguration.Builder)b.addApiName(ApiName.builder().version("2.17.124").name("PAGINATED").build());
        };
        AwsRequestOverrideConfiguration overrideConfiguration = request.overrideConfiguration().map(c -> ((AwsRequestOverrideConfiguration.Builder)c.toBuilder().applyMutation(userAgentApplier)).build()).orElse(((AwsRequestOverrideConfiguration.Builder)AwsRequestOverrideConfiguration.builder().applyMutation(userAgentApplier)).build());
        return (T)((Object)((TimestreamWriteRequest)request.toBuilder().overrideConfiguration(overrideConfiguration).build()));
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory, JsonOperationMetadata operationMetadata) {
        return protocolFactory.createErrorResponseHandler(operationMetadata);
    }

    private static /* synthetic */ void lambda$writeRecords$58(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$writeRecords$57(List metricPublishers, MetricCollector apiCallMetricCollector, WriteRecordsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$updateTable$54(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateTable$53(List metricPublishers, MetricCollector apiCallMetricCollector, UpdateTableResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$updateDatabase$50(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateDatabase$49(List metricPublishers, MetricCollector apiCallMetricCollector, UpdateDatabaseResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$untagResource$46(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$untagResource$45(List metricPublishers, MetricCollector apiCallMetricCollector, UntagResourceResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$tagResource$42(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$tagResource$41(List metricPublishers, MetricCollector apiCallMetricCollector, TagResourceResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$listTagsForResource$38(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listTagsForResource$37(List metricPublishers, MetricCollector apiCallMetricCollector, ListTagsForResourceResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$listTables$34(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listTables$33(List metricPublishers, MetricCollector apiCallMetricCollector, ListTablesResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$listDatabases$30(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listDatabases$29(List metricPublishers, MetricCollector apiCallMetricCollector, ListDatabasesResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$describeTable$26(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeTable$25(List metricPublishers, MetricCollector apiCallMetricCollector, DescribeTableResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$describeEndpoints$22(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeEndpoints$21(List metricPublishers, MetricCollector apiCallMetricCollector, DescribeEndpointsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$describeDatabase$19(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeDatabase$18(List metricPublishers, MetricCollector apiCallMetricCollector, DescribeDatabaseResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$deleteTable$15(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteTable$14(List metricPublishers, MetricCollector apiCallMetricCollector, DeleteTableResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$deleteDatabase$11(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteDatabase$10(List metricPublishers, MetricCollector apiCallMetricCollector, DeleteDatabaseResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$createTable$7(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createTable$6(List metricPublishers, MetricCollector apiCallMetricCollector, CreateTableResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$createDatabase$3(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createDatabase$2(List metricPublishers, MetricCollector apiCallMetricCollector, CreateDatabaseResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }
}

