/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.timestreamwrite.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.exception.AwsErrorDetails;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * WriteRecords would throw this exception in the following cases:
 * </p>
 * <ul>
 * <li>
 * <p>
 * Records with duplicate data where there are multiple records with the same dimensions, timestamps, and measure names
 * but different measure values.
 * </p>
 * </li>
 * <li>
 * <p>
 * Records with timestamps that lie outside the retention duration of the memory store
 * </p>
 * </li>
 * <li>
 * <p>
 * Records with dimensions or measures that exceed the Timestream defined limits.
 * </p>
 * </li>
 * </ul>
 * <p>
 * For more information, see <a
 * href="https://docs.aws.amazon.com/timestream/latest/developerguide/ts-limits.html">Access Management</a> in the
 * Timestream Developer Guide.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RejectedRecordsException extends TimestreamWriteException implements
        ToCopyableBuilder<RejectedRecordsException.Builder, RejectedRecordsException> {
    private static final SdkField<List<RejectedRecord>> REJECTED_RECORDS_FIELD = SdkField
            .<List<RejectedRecord>> builder(MarshallingType.LIST)
            .memberName("RejectedRecords")
            .getter(getter(RejectedRecordsException::rejectedRecords))
            .setter(setter(Builder::rejectedRecords))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RejectedRecords").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<RejectedRecord> builder(MarshallingType.SDK_POJO)
                                            .constructor(RejectedRecord::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REJECTED_RECORDS_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<RejectedRecord> rejectedRecords;

    private RejectedRecordsException(BuilderImpl builder) {
        super(builder);
        this.rejectedRecords = builder.rejectedRecords;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    /**
     * Returns true if the RejectedRecords property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasRejectedRecords() {
        return rejectedRecords != null && !(rejectedRecords instanceof SdkAutoConstructList);
    }

    /**
     * Returns the value of the RejectedRecords property for this object.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasRejectedRecords()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The value of the RejectedRecords property for this object.
     */
    public List<RejectedRecord> rejectedRecords() {
        return rejectedRecords;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RejectedRecordsException, T> g) {
        return obj -> g.apply((RejectedRecordsException) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RejectedRecordsException>,
            TimestreamWriteException.Builder {
        /**
         * Sets the value of the RejectedRecords property for this object.
         *
         * @param rejectedRecords
         *        The new value for the RejectedRecords property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rejectedRecords(Collection<RejectedRecord> rejectedRecords);

        /**
         * Sets the value of the RejectedRecords property for this object.
         *
         * @param rejectedRecords
         *        The new value for the RejectedRecords property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rejectedRecords(RejectedRecord... rejectedRecords);

        /**
         * Sets the value of the RejectedRecords property for this object.
         *
         * This is a convenience that creates an instance of the {@link List<RejectedRecord>.Builder} avoiding the need
         * to create one manually via {@link List<RejectedRecord>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<RejectedRecord>.Builder#build()} is called immediately and
         * its result is passed to {@link #rejectedRecords(List<RejectedRecord>)}.
         * 
         * @param rejectedRecords
         *        a consumer that will call methods on {@link List<RejectedRecord>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #rejectedRecords(List<RejectedRecord>)
         */
        Builder rejectedRecords(Consumer<RejectedRecord.Builder>... rejectedRecords);

        @Override
        Builder awsErrorDetails(AwsErrorDetails awsErrorDetails);

        @Override
        Builder message(String message);

        @Override
        Builder requestId(String requestId);

        @Override
        Builder statusCode(int statusCode);

        @Override
        Builder cause(Throwable cause);
    }

    static final class BuilderImpl extends TimestreamWriteException.BuilderImpl implements Builder {
        private List<RejectedRecord> rejectedRecords = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(RejectedRecordsException model) {
            super(model);
            rejectedRecords(model.rejectedRecords);
        }

        public final Collection<RejectedRecord.Builder> getRejectedRecords() {
            if (rejectedRecords instanceof SdkAutoConstructList) {
                return null;
            }
            return rejectedRecords != null ? rejectedRecords.stream().map(RejectedRecord::toBuilder).collect(Collectors.toList())
                    : null;
        }

        @Override
        public final Builder rejectedRecords(Collection<RejectedRecord> rejectedRecords) {
            this.rejectedRecords = RejectedRecordsCopier.copy(rejectedRecords);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder rejectedRecords(RejectedRecord... rejectedRecords) {
            rejectedRecords(Arrays.asList(rejectedRecords));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder rejectedRecords(Consumer<RejectedRecord.Builder>... rejectedRecords) {
            rejectedRecords(Stream.of(rejectedRecords).map(c -> RejectedRecord.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setRejectedRecords(Collection<RejectedRecord.BuilderImpl> rejectedRecords) {
            this.rejectedRecords = RejectedRecordsCopier.copyFromBuilder(rejectedRecords);
        }

        @Override
        public BuilderImpl awsErrorDetails(AwsErrorDetails awsErrorDetails) {
            this.awsErrorDetails = awsErrorDetails;
            return this;
        }

        @Override
        public BuilderImpl message(String message) {
            this.message = message;
            return this;
        }

        @Override
        public BuilderImpl requestId(String requestId) {
            this.requestId = requestId;
            return this;
        }

        @Override
        public BuilderImpl statusCode(int statusCode) {
            this.statusCode = statusCode;
            return this;
        }

        @Override
        public BuilderImpl cause(Throwable cause) {
            this.cause = cause;
            return this;
        }

        @Override
        public RejectedRecordsException build() {
            return new RejectedRecordsException(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
