/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.timestreamwrite;

import java.util.function.Consumer;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.SdkClient;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.regions.ServiceMetadata;
import software.amazon.awssdk.services.timestreamwrite.DefaultTimestreamWriteClientBuilder;
import software.amazon.awssdk.services.timestreamwrite.TimestreamWriteClientBuilder;
import software.amazon.awssdk.services.timestreamwrite.model.AccessDeniedException;
import software.amazon.awssdk.services.timestreamwrite.model.ConflictException;
import software.amazon.awssdk.services.timestreamwrite.model.CreateDatabaseRequest;
import software.amazon.awssdk.services.timestreamwrite.model.CreateDatabaseResponse;
import software.amazon.awssdk.services.timestreamwrite.model.CreateTableRequest;
import software.amazon.awssdk.services.timestreamwrite.model.CreateTableResponse;
import software.amazon.awssdk.services.timestreamwrite.model.DeleteDatabaseRequest;
import software.amazon.awssdk.services.timestreamwrite.model.DeleteDatabaseResponse;
import software.amazon.awssdk.services.timestreamwrite.model.DeleteTableRequest;
import software.amazon.awssdk.services.timestreamwrite.model.DeleteTableResponse;
import software.amazon.awssdk.services.timestreamwrite.model.DescribeDatabaseRequest;
import software.amazon.awssdk.services.timestreamwrite.model.DescribeDatabaseResponse;
import software.amazon.awssdk.services.timestreamwrite.model.DescribeEndpointsRequest;
import software.amazon.awssdk.services.timestreamwrite.model.DescribeEndpointsResponse;
import software.amazon.awssdk.services.timestreamwrite.model.DescribeTableRequest;
import software.amazon.awssdk.services.timestreamwrite.model.DescribeTableResponse;
import software.amazon.awssdk.services.timestreamwrite.model.InternalServerException;
import software.amazon.awssdk.services.timestreamwrite.model.InvalidEndpointException;
import software.amazon.awssdk.services.timestreamwrite.model.ListDatabasesRequest;
import software.amazon.awssdk.services.timestreamwrite.model.ListDatabasesResponse;
import software.amazon.awssdk.services.timestreamwrite.model.ListTablesRequest;
import software.amazon.awssdk.services.timestreamwrite.model.ListTablesResponse;
import software.amazon.awssdk.services.timestreamwrite.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.timestreamwrite.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.timestreamwrite.model.RejectedRecordsException;
import software.amazon.awssdk.services.timestreamwrite.model.ResourceNotFoundException;
import software.amazon.awssdk.services.timestreamwrite.model.ServiceQuotaExceededException;
import software.amazon.awssdk.services.timestreamwrite.model.TagResourceRequest;
import software.amazon.awssdk.services.timestreamwrite.model.TagResourceResponse;
import software.amazon.awssdk.services.timestreamwrite.model.ThrottlingException;
import software.amazon.awssdk.services.timestreamwrite.model.TimestreamWriteException;
import software.amazon.awssdk.services.timestreamwrite.model.UntagResourceRequest;
import software.amazon.awssdk.services.timestreamwrite.model.UntagResourceResponse;
import software.amazon.awssdk.services.timestreamwrite.model.UpdateDatabaseRequest;
import software.amazon.awssdk.services.timestreamwrite.model.UpdateDatabaseResponse;
import software.amazon.awssdk.services.timestreamwrite.model.UpdateTableRequest;
import software.amazon.awssdk.services.timestreamwrite.model.UpdateTableResponse;
import software.amazon.awssdk.services.timestreamwrite.model.ValidationException;
import software.amazon.awssdk.services.timestreamwrite.model.WriteRecordsRequest;
import software.amazon.awssdk.services.timestreamwrite.model.WriteRecordsResponse;
import software.amazon.awssdk.services.timestreamwrite.paginators.ListDatabasesIterable;
import software.amazon.awssdk.services.timestreamwrite.paginators.ListTablesIterable;

public interface TimestreamWriteClient
extends SdkClient {
    public static final String SERVICE_NAME = "timestream";

    public static TimestreamWriteClient create() {
        return (TimestreamWriteClient)TimestreamWriteClient.builder().build();
    }

    public static TimestreamWriteClientBuilder builder() {
        return new DefaultTimestreamWriteClientBuilder();
    }

    default public CreateDatabaseResponse createDatabase(CreateDatabaseRequest createDatabaseRequest) throws ConflictException, ValidationException, AccessDeniedException, ServiceQuotaExceededException, ThrottlingException, InvalidEndpointException, InternalServerException, AwsServiceException, SdkClientException, TimestreamWriteException {
        throw new UnsupportedOperationException();
    }

    default public CreateDatabaseResponse createDatabase(Consumer<CreateDatabaseRequest.Builder> createDatabaseRequest) throws ConflictException, ValidationException, AccessDeniedException, ServiceQuotaExceededException, ThrottlingException, InvalidEndpointException, InternalServerException, AwsServiceException, SdkClientException, TimestreamWriteException {
        return this.createDatabase((CreateDatabaseRequest)((Object)((CreateDatabaseRequest.Builder)CreateDatabaseRequest.builder().applyMutation(createDatabaseRequest)).build()));
    }

    default public CreateTableResponse createTable(CreateTableRequest createTableRequest) throws ConflictException, ValidationException, AccessDeniedException, ResourceNotFoundException, ServiceQuotaExceededException, ThrottlingException, InternalServerException, InvalidEndpointException, AwsServiceException, SdkClientException, TimestreamWriteException {
        throw new UnsupportedOperationException();
    }

    default public CreateTableResponse createTable(Consumer<CreateTableRequest.Builder> createTableRequest) throws ConflictException, ValidationException, AccessDeniedException, ResourceNotFoundException, ServiceQuotaExceededException, ThrottlingException, InternalServerException, InvalidEndpointException, AwsServiceException, SdkClientException, TimestreamWriteException {
        return this.createTable((CreateTableRequest)((Object)((CreateTableRequest.Builder)CreateTableRequest.builder().applyMutation(createTableRequest)).build()));
    }

    default public DeleteDatabaseResponse deleteDatabase(DeleteDatabaseRequest deleteDatabaseRequest) throws InternalServerException, ThrottlingException, ResourceNotFoundException, ValidationException, AccessDeniedException, InvalidEndpointException, AwsServiceException, SdkClientException, TimestreamWriteException {
        throw new UnsupportedOperationException();
    }

    default public DeleteDatabaseResponse deleteDatabase(Consumer<DeleteDatabaseRequest.Builder> deleteDatabaseRequest) throws InternalServerException, ThrottlingException, ResourceNotFoundException, ValidationException, AccessDeniedException, InvalidEndpointException, AwsServiceException, SdkClientException, TimestreamWriteException {
        return this.deleteDatabase((DeleteDatabaseRequest)((Object)((DeleteDatabaseRequest.Builder)DeleteDatabaseRequest.builder().applyMutation(deleteDatabaseRequest)).build()));
    }

    default public DeleteTableResponse deleteTable(DeleteTableRequest deleteTableRequest) throws InternalServerException, ThrottlingException, ValidationException, ResourceNotFoundException, AccessDeniedException, InvalidEndpointException, AwsServiceException, SdkClientException, TimestreamWriteException {
        throw new UnsupportedOperationException();
    }

    default public DeleteTableResponse deleteTable(Consumer<DeleteTableRequest.Builder> deleteTableRequest) throws InternalServerException, ThrottlingException, ValidationException, ResourceNotFoundException, AccessDeniedException, InvalidEndpointException, AwsServiceException, SdkClientException, TimestreamWriteException {
        return this.deleteTable((DeleteTableRequest)((Object)((DeleteTableRequest.Builder)DeleteTableRequest.builder().applyMutation(deleteTableRequest)).build()));
    }

    default public DescribeDatabaseResponse describeDatabase(DescribeDatabaseRequest describeDatabaseRequest) throws ResourceNotFoundException, ValidationException, AccessDeniedException, ThrottlingException, InternalServerException, InvalidEndpointException, AwsServiceException, SdkClientException, TimestreamWriteException {
        throw new UnsupportedOperationException();
    }

    default public DescribeDatabaseResponse describeDatabase(Consumer<DescribeDatabaseRequest.Builder> describeDatabaseRequest) throws ResourceNotFoundException, ValidationException, AccessDeniedException, ThrottlingException, InternalServerException, InvalidEndpointException, AwsServiceException, SdkClientException, TimestreamWriteException {
        return this.describeDatabase((DescribeDatabaseRequest)((Object)((DescribeDatabaseRequest.Builder)DescribeDatabaseRequest.builder().applyMutation(describeDatabaseRequest)).build()));
    }

    default public DescribeEndpointsResponse describeEndpoints(DescribeEndpointsRequest describeEndpointsRequest) throws InternalServerException, ValidationException, ThrottlingException, AwsServiceException, SdkClientException, TimestreamWriteException {
        throw new UnsupportedOperationException();
    }

    default public DescribeEndpointsResponse describeEndpoints(Consumer<DescribeEndpointsRequest.Builder> describeEndpointsRequest) throws InternalServerException, ValidationException, ThrottlingException, AwsServiceException, SdkClientException, TimestreamWriteException {
        return this.describeEndpoints((DescribeEndpointsRequest)((Object)((DescribeEndpointsRequest.Builder)DescribeEndpointsRequest.builder().applyMutation(describeEndpointsRequest)).build()));
    }

    default public DescribeTableResponse describeTable(DescribeTableRequest describeTableRequest) throws ResourceNotFoundException, ValidationException, AccessDeniedException, ThrottlingException, InternalServerException, InvalidEndpointException, AwsServiceException, SdkClientException, TimestreamWriteException {
        throw new UnsupportedOperationException();
    }

    default public DescribeTableResponse describeTable(Consumer<DescribeTableRequest.Builder> describeTableRequest) throws ResourceNotFoundException, ValidationException, AccessDeniedException, ThrottlingException, InternalServerException, InvalidEndpointException, AwsServiceException, SdkClientException, TimestreamWriteException {
        return this.describeTable((DescribeTableRequest)((Object)((DescribeTableRequest.Builder)DescribeTableRequest.builder().applyMutation(describeTableRequest)).build()));
    }

    default public ListDatabasesResponse listDatabases(ListDatabasesRequest listDatabasesRequest) throws InternalServerException, ThrottlingException, ValidationException, AccessDeniedException, InvalidEndpointException, AwsServiceException, SdkClientException, TimestreamWriteException {
        throw new UnsupportedOperationException();
    }

    default public ListDatabasesResponse listDatabases(Consumer<ListDatabasesRequest.Builder> listDatabasesRequest) throws InternalServerException, ThrottlingException, ValidationException, AccessDeniedException, InvalidEndpointException, AwsServiceException, SdkClientException, TimestreamWriteException {
        return this.listDatabases((ListDatabasesRequest)((Object)((ListDatabasesRequest.Builder)ListDatabasesRequest.builder().applyMutation(listDatabasesRequest)).build()));
    }

    default public ListDatabasesIterable listDatabasesPaginator(ListDatabasesRequest listDatabasesRequest) throws InternalServerException, ThrottlingException, ValidationException, AccessDeniedException, InvalidEndpointException, AwsServiceException, SdkClientException, TimestreamWriteException {
        throw new UnsupportedOperationException();
    }

    default public ListDatabasesIterable listDatabasesPaginator(Consumer<ListDatabasesRequest.Builder> listDatabasesRequest) throws InternalServerException, ThrottlingException, ValidationException, AccessDeniedException, InvalidEndpointException, AwsServiceException, SdkClientException, TimestreamWriteException {
        return this.listDatabasesPaginator((ListDatabasesRequest)((Object)((ListDatabasesRequest.Builder)ListDatabasesRequest.builder().applyMutation(listDatabasesRequest)).build()));
    }

    default public ListTablesResponse listTables(ListTablesRequest listTablesRequest) throws InternalServerException, ThrottlingException, ValidationException, ResourceNotFoundException, AccessDeniedException, InvalidEndpointException, AwsServiceException, SdkClientException, TimestreamWriteException {
        throw new UnsupportedOperationException();
    }

    default public ListTablesResponse listTables(Consumer<ListTablesRequest.Builder> listTablesRequest) throws InternalServerException, ThrottlingException, ValidationException, ResourceNotFoundException, AccessDeniedException, InvalidEndpointException, AwsServiceException, SdkClientException, TimestreamWriteException {
        return this.listTables((ListTablesRequest)((Object)((ListTablesRequest.Builder)ListTablesRequest.builder().applyMutation(listTablesRequest)).build()));
    }

    default public ListTablesIterable listTablesPaginator(ListTablesRequest listTablesRequest) throws InternalServerException, ThrottlingException, ValidationException, ResourceNotFoundException, AccessDeniedException, InvalidEndpointException, AwsServiceException, SdkClientException, TimestreamWriteException {
        throw new UnsupportedOperationException();
    }

    default public ListTablesIterable listTablesPaginator(Consumer<ListTablesRequest.Builder> listTablesRequest) throws InternalServerException, ThrottlingException, ValidationException, ResourceNotFoundException, AccessDeniedException, InvalidEndpointException, AwsServiceException, SdkClientException, TimestreamWriteException {
        return this.listTablesPaginator((ListTablesRequest)((Object)((ListTablesRequest.Builder)ListTablesRequest.builder().applyMutation(listTablesRequest)).build()));
    }

    default public ListTagsForResourceResponse listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest) throws ResourceNotFoundException, ThrottlingException, ValidationException, InvalidEndpointException, AwsServiceException, SdkClientException, TimestreamWriteException {
        throw new UnsupportedOperationException();
    }

    default public ListTagsForResourceResponse listTagsForResource(Consumer<ListTagsForResourceRequest.Builder> listTagsForResourceRequest) throws ResourceNotFoundException, ThrottlingException, ValidationException, InvalidEndpointException, AwsServiceException, SdkClientException, TimestreamWriteException {
        return this.listTagsForResource((ListTagsForResourceRequest)((Object)((ListTagsForResourceRequest.Builder)ListTagsForResourceRequest.builder().applyMutation(listTagsForResourceRequest)).build()));
    }

    default public TagResourceResponse tagResource(TagResourceRequest tagResourceRequest) throws ResourceNotFoundException, ServiceQuotaExceededException, ThrottlingException, ValidationException, InvalidEndpointException, AwsServiceException, SdkClientException, TimestreamWriteException {
        throw new UnsupportedOperationException();
    }

    default public TagResourceResponse tagResource(Consumer<TagResourceRequest.Builder> tagResourceRequest) throws ResourceNotFoundException, ServiceQuotaExceededException, ThrottlingException, ValidationException, InvalidEndpointException, AwsServiceException, SdkClientException, TimestreamWriteException {
        return this.tagResource((TagResourceRequest)((Object)((TagResourceRequest.Builder)TagResourceRequest.builder().applyMutation(tagResourceRequest)).build()));
    }

    default public UntagResourceResponse untagResource(UntagResourceRequest untagResourceRequest) throws ValidationException, ServiceQuotaExceededException, ThrottlingException, ResourceNotFoundException, InvalidEndpointException, AwsServiceException, SdkClientException, TimestreamWriteException {
        throw new UnsupportedOperationException();
    }

    default public UntagResourceResponse untagResource(Consumer<UntagResourceRequest.Builder> untagResourceRequest) throws ValidationException, ServiceQuotaExceededException, ThrottlingException, ResourceNotFoundException, InvalidEndpointException, AwsServiceException, SdkClientException, TimestreamWriteException {
        return this.untagResource((UntagResourceRequest)((Object)((UntagResourceRequest.Builder)UntagResourceRequest.builder().applyMutation(untagResourceRequest)).build()));
    }

    default public UpdateDatabaseResponse updateDatabase(UpdateDatabaseRequest updateDatabaseRequest) throws ValidationException, AccessDeniedException, ResourceNotFoundException, ServiceQuotaExceededException, ThrottlingException, InternalServerException, InvalidEndpointException, AwsServiceException, SdkClientException, TimestreamWriteException {
        throw new UnsupportedOperationException();
    }

    default public UpdateDatabaseResponse updateDatabase(Consumer<UpdateDatabaseRequest.Builder> updateDatabaseRequest) throws ValidationException, AccessDeniedException, ResourceNotFoundException, ServiceQuotaExceededException, ThrottlingException, InternalServerException, InvalidEndpointException, AwsServiceException, SdkClientException, TimestreamWriteException {
        return this.updateDatabase((UpdateDatabaseRequest)((Object)((UpdateDatabaseRequest.Builder)UpdateDatabaseRequest.builder().applyMutation(updateDatabaseRequest)).build()));
    }

    default public UpdateTableResponse updateTable(UpdateTableRequest updateTableRequest) throws InternalServerException, ThrottlingException, ValidationException, ResourceNotFoundException, AccessDeniedException, InvalidEndpointException, AwsServiceException, SdkClientException, TimestreamWriteException {
        throw new UnsupportedOperationException();
    }

    default public UpdateTableResponse updateTable(Consumer<UpdateTableRequest.Builder> updateTableRequest) throws InternalServerException, ThrottlingException, ValidationException, ResourceNotFoundException, AccessDeniedException, InvalidEndpointException, AwsServiceException, SdkClientException, TimestreamWriteException {
        return this.updateTable((UpdateTableRequest)((Object)((UpdateTableRequest.Builder)UpdateTableRequest.builder().applyMutation(updateTableRequest)).build()));
    }

    default public WriteRecordsResponse writeRecords(WriteRecordsRequest writeRecordsRequest) throws InternalServerException, ThrottlingException, ValidationException, ResourceNotFoundException, AccessDeniedException, RejectedRecordsException, InvalidEndpointException, AwsServiceException, SdkClientException, TimestreamWriteException {
        throw new UnsupportedOperationException();
    }

    default public WriteRecordsResponse writeRecords(Consumer<WriteRecordsRequest.Builder> writeRecordsRequest) throws InternalServerException, ThrottlingException, ValidationException, ResourceNotFoundException, AccessDeniedException, RejectedRecordsException, InvalidEndpointException, AwsServiceException, SdkClientException, TimestreamWriteException {
        return this.writeRecords((WriteRecordsRequest)((Object)((WriteRecordsRequest.Builder)WriteRecordsRequest.builder().applyMutation(writeRecordsRequest)).build()));
    }

    public static ServiceMetadata serviceMetadata() {
        return ServiceMetadata.of((String)"ingest.timestream");
    }
}

