/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.timestreamwrite.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.timestreamwrite.model.Record;
import software.amazon.awssdk.services.timestreamwrite.model.RecordsCopier;
import software.amazon.awssdk.services.timestreamwrite.model.TimestreamWriteRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class WriteRecordsRequest
extends TimestreamWriteRequest
implements ToCopyableBuilder<Builder, WriteRecordsRequest> {
    private static final SdkField<String> DATABASE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DatabaseName").getter(WriteRecordsRequest.getter(WriteRecordsRequest::databaseName)).setter(WriteRecordsRequest.setter(Builder::databaseName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DatabaseName").build()}).build();
    private static final SdkField<String> TABLE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TableName").getter(WriteRecordsRequest.getter(WriteRecordsRequest::tableName)).setter(WriteRecordsRequest.setter(Builder::tableName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TableName").build()}).build();
    private static final SdkField<Record> COMMON_ATTRIBUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("CommonAttributes").getter(WriteRecordsRequest.getter(WriteRecordsRequest::commonAttributes)).setter(WriteRecordsRequest.setter(Builder::commonAttributes)).constructor(Record::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CommonAttributes").build()}).build();
    private static final SdkField<List<Record>> RECORDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Records").getter(WriteRecordsRequest.getter(WriteRecordsRequest::records)).setter(WriteRecordsRequest.setter(Builder::records)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Records").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Record::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATABASE_NAME_FIELD, TABLE_NAME_FIELD, COMMON_ATTRIBUTES_FIELD, RECORDS_FIELD));
    private final String databaseName;
    private final String tableName;
    private final Record commonAttributes;
    private final List<Record> records;

    private WriteRecordsRequest(BuilderImpl builder) {
        super(builder);
        this.databaseName = builder.databaseName;
        this.tableName = builder.tableName;
        this.commonAttributes = builder.commonAttributes;
        this.records = builder.records;
    }

    public String databaseName() {
        return this.databaseName;
    }

    public String tableName() {
        return this.tableName;
    }

    public Record commonAttributes() {
        return this.commonAttributes;
    }

    public boolean hasRecords() {
        return this.records != null && !(this.records instanceof SdkAutoConstructList);
    }

    public List<Record> records() {
        return this.records;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.databaseName());
        hashCode = 31 * hashCode + Objects.hashCode(this.tableName());
        hashCode = 31 * hashCode + Objects.hashCode(this.commonAttributes());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRecords() ? this.records() : null);
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof WriteRecordsRequest)) {
            return false;
        }
        WriteRecordsRequest other = (WriteRecordsRequest)((Object)obj);
        return Objects.equals(this.databaseName(), other.databaseName()) && Objects.equals(this.tableName(), other.tableName()) && Objects.equals(this.commonAttributes(), other.commonAttributes()) && this.hasRecords() == other.hasRecords() && Objects.equals(this.records(), other.records());
    }

    public String toString() {
        return ToString.builder((String)"WriteRecordsRequest").add("DatabaseName", (Object)this.databaseName()).add("TableName", (Object)this.tableName()).add("CommonAttributes", (Object)this.commonAttributes()).add("Records", this.hasRecords() ? this.records() : null).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DatabaseName": {
                return Optional.ofNullable(clazz.cast(this.databaseName()));
            }
            case "TableName": {
                return Optional.ofNullable(clazz.cast(this.tableName()));
            }
            case "CommonAttributes": {
                return Optional.ofNullable(clazz.cast(this.commonAttributes()));
            }
            case "Records": {
                return Optional.ofNullable(clazz.cast(this.records()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<WriteRecordsRequest, T> g) {
        return obj -> g.apply((WriteRecordsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends TimestreamWriteRequest.BuilderImpl
    implements Builder {
        private String databaseName;
        private String tableName;
        private Record commonAttributes;
        private List<Record> records = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(WriteRecordsRequest model) {
            super(model);
            this.databaseName(model.databaseName);
            this.tableName(model.tableName);
            this.commonAttributes(model.commonAttributes);
            this.records(model.records);
        }

        public final String getDatabaseName() {
            return this.databaseName;
        }

        @Override
        public final Builder databaseName(String databaseName) {
            this.databaseName = databaseName;
            return this;
        }

        public final void setDatabaseName(String databaseName) {
            this.databaseName = databaseName;
        }

        public final String getTableName() {
            return this.tableName;
        }

        @Override
        public final Builder tableName(String tableName) {
            this.tableName = tableName;
            return this;
        }

        public final void setTableName(String tableName) {
            this.tableName = tableName;
        }

        public final Record.Builder getCommonAttributes() {
            return this.commonAttributes != null ? this.commonAttributes.toBuilder() : null;
        }

        @Override
        public final Builder commonAttributes(Record commonAttributes) {
            this.commonAttributes = commonAttributes;
            return this;
        }

        public final void setCommonAttributes(Record.BuilderImpl commonAttributes) {
            this.commonAttributes = commonAttributes != null ? commonAttributes.build() : null;
        }

        public final Collection<Record.Builder> getRecords() {
            if (this.records instanceof SdkAutoConstructList) {
                return null;
            }
            return this.records != null ? (Collection)this.records.stream().map(Record::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder records(Collection<Record> records) {
            this.records = RecordsCopier.copy(records);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder records(Record ... records) {
            this.records(Arrays.asList(records));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder records(Consumer<Record.Builder> ... records) {
            this.records(Stream.of(records).map(c -> (Record)((Record.Builder)Record.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setRecords(Collection<Record.BuilderImpl> records) {
            this.records = RecordsCopier.copyFromBuilder(records);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public WriteRecordsRequest build() {
            return new WriteRecordsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends TimestreamWriteRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, WriteRecordsRequest> {
        public Builder databaseName(String var1);

        public Builder tableName(String var1);

        public Builder commonAttributes(Record var1);

        default public Builder commonAttributes(Consumer<Record.Builder> commonAttributes) {
            return this.commonAttributes((Record)((Record.Builder)Record.builder().applyMutation(commonAttributes)).build());
        }

        public Builder records(Collection<Record> var1);

        public Builder records(Record ... var1);

        public Builder records(Consumer<Record.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

