/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.timestreamquery.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.timestreamquery.model.ErrorReportLocation;
import software.amazon.awssdk.services.timestreamquery.model.ExecutionStats;
import software.amazon.awssdk.services.timestreamquery.model.ScheduledQueryInsightsResponse;
import software.amazon.awssdk.services.timestreamquery.model.ScheduledQueryRunStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ScheduledQueryRunSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ScheduledQueryRunSummary> {
    private static final SdkField<Instant> INVOCATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("InvocationTime").getter(ScheduledQueryRunSummary.getter(ScheduledQueryRunSummary::invocationTime)).setter(ScheduledQueryRunSummary.setter(Builder::invocationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InvocationTime").build()}).build();
    private static final SdkField<Instant> TRIGGER_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("TriggerTime").getter(ScheduledQueryRunSummary.getter(ScheduledQueryRunSummary::triggerTime)).setter(ScheduledQueryRunSummary.setter(Builder::triggerTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TriggerTime").build()}).build();
    private static final SdkField<String> RUN_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RunStatus").getter(ScheduledQueryRunSummary.getter(ScheduledQueryRunSummary::runStatusAsString)).setter(ScheduledQueryRunSummary.setter(Builder::runStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RunStatus").build()}).build();
    private static final SdkField<ExecutionStats> EXECUTION_STATS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ExecutionStats").getter(ScheduledQueryRunSummary.getter(ScheduledQueryRunSummary::executionStats)).setter(ScheduledQueryRunSummary.setter(Builder::executionStats)).constructor(ExecutionStats::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExecutionStats").build()}).build();
    private static final SdkField<ScheduledQueryInsightsResponse> QUERY_INSIGHTS_RESPONSE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("QueryInsightsResponse").getter(ScheduledQueryRunSummary.getter(ScheduledQueryRunSummary::queryInsightsResponse)).setter(ScheduledQueryRunSummary.setter(Builder::queryInsightsResponse)).constructor(ScheduledQueryInsightsResponse::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QueryInsightsResponse").build()}).build();
    private static final SdkField<ErrorReportLocation> ERROR_REPORT_LOCATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ErrorReportLocation").getter(ScheduledQueryRunSummary.getter(ScheduledQueryRunSummary::errorReportLocation)).setter(ScheduledQueryRunSummary.setter(Builder::errorReportLocation)).constructor(ErrorReportLocation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ErrorReportLocation").build()}).build();
    private static final SdkField<String> FAILURE_REASON_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FailureReason").getter(ScheduledQueryRunSummary.getter(ScheduledQueryRunSummary::failureReason)).setter(ScheduledQueryRunSummary.setter(Builder::failureReason)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FailureReason").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INVOCATION_TIME_FIELD, TRIGGER_TIME_FIELD, RUN_STATUS_FIELD, EXECUTION_STATS_FIELD, QUERY_INSIGHTS_RESPONSE_FIELD, ERROR_REPORT_LOCATION_FIELD, FAILURE_REASON_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ScheduledQueryRunSummary.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Instant invocationTime;
    private final Instant triggerTime;
    private final String runStatus;
    private final ExecutionStats executionStats;
    private final ScheduledQueryInsightsResponse queryInsightsResponse;
    private final ErrorReportLocation errorReportLocation;
    private final String failureReason;

    private ScheduledQueryRunSummary(BuilderImpl builder) {
        this.invocationTime = builder.invocationTime;
        this.triggerTime = builder.triggerTime;
        this.runStatus = builder.runStatus;
        this.executionStats = builder.executionStats;
        this.queryInsightsResponse = builder.queryInsightsResponse;
        this.errorReportLocation = builder.errorReportLocation;
        this.failureReason = builder.failureReason;
    }

    public final Instant invocationTime() {
        return this.invocationTime;
    }

    public final Instant triggerTime() {
        return this.triggerTime;
    }

    public final ScheduledQueryRunStatus runStatus() {
        return ScheduledQueryRunStatus.fromValue(this.runStatus);
    }

    public final String runStatusAsString() {
        return this.runStatus;
    }

    public final ExecutionStats executionStats() {
        return this.executionStats;
    }

    public final ScheduledQueryInsightsResponse queryInsightsResponse() {
        return this.queryInsightsResponse;
    }

    public final ErrorReportLocation errorReportLocation() {
        return this.errorReportLocation;
    }

    public final String failureReason() {
        return this.failureReason;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.invocationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.triggerTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.runStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.executionStats());
        hashCode = 31 * hashCode + Objects.hashCode(this.queryInsightsResponse());
        hashCode = 31 * hashCode + Objects.hashCode(this.errorReportLocation());
        hashCode = 31 * hashCode + Objects.hashCode(this.failureReason());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ScheduledQueryRunSummary)) {
            return false;
        }
        ScheduledQueryRunSummary other = (ScheduledQueryRunSummary)obj;
        return Objects.equals(this.invocationTime(), other.invocationTime()) && Objects.equals(this.triggerTime(), other.triggerTime()) && Objects.equals(this.runStatusAsString(), other.runStatusAsString()) && Objects.equals(this.executionStats(), other.executionStats()) && Objects.equals(this.queryInsightsResponse(), other.queryInsightsResponse()) && Objects.equals(this.errorReportLocation(), other.errorReportLocation()) && Objects.equals(this.failureReason(), other.failureReason());
    }

    public final String toString() {
        return ToString.builder((String)"ScheduledQueryRunSummary").add("InvocationTime", (Object)this.invocationTime()).add("TriggerTime", (Object)this.triggerTime()).add("RunStatus", (Object)this.runStatusAsString()).add("ExecutionStats", (Object)this.executionStats()).add("QueryInsightsResponse", (Object)this.queryInsightsResponse()).add("ErrorReportLocation", (Object)this.errorReportLocation()).add("FailureReason", (Object)this.failureReason()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "InvocationTime": {
                return Optional.ofNullable(clazz.cast(this.invocationTime()));
            }
            case "TriggerTime": {
                return Optional.ofNullable(clazz.cast(this.triggerTime()));
            }
            case "RunStatus": {
                return Optional.ofNullable(clazz.cast(this.runStatusAsString()));
            }
            case "ExecutionStats": {
                return Optional.ofNullable(clazz.cast(this.executionStats()));
            }
            case "QueryInsightsResponse": {
                return Optional.ofNullable(clazz.cast(this.queryInsightsResponse()));
            }
            case "ErrorReportLocation": {
                return Optional.ofNullable(clazz.cast(this.errorReportLocation()));
            }
            case "FailureReason": {
                return Optional.ofNullable(clazz.cast(this.failureReason()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("InvocationTime", INVOCATION_TIME_FIELD);
        map.put("TriggerTime", TRIGGER_TIME_FIELD);
        map.put("RunStatus", RUN_STATUS_FIELD);
        map.put("ExecutionStats", EXECUTION_STATS_FIELD);
        map.put("QueryInsightsResponse", QUERY_INSIGHTS_RESPONSE_FIELD);
        map.put("ErrorReportLocation", ERROR_REPORT_LOCATION_FIELD);
        map.put("FailureReason", FAILURE_REASON_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ScheduledQueryRunSummary, T> g) {
        return obj -> g.apply((ScheduledQueryRunSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Instant invocationTime;
        private Instant triggerTime;
        private String runStatus;
        private ExecutionStats executionStats;
        private ScheduledQueryInsightsResponse queryInsightsResponse;
        private ErrorReportLocation errorReportLocation;
        private String failureReason;

        private BuilderImpl() {
        }

        private BuilderImpl(ScheduledQueryRunSummary model) {
            this.invocationTime(model.invocationTime);
            this.triggerTime(model.triggerTime);
            this.runStatus(model.runStatus);
            this.executionStats(model.executionStats);
            this.queryInsightsResponse(model.queryInsightsResponse);
            this.errorReportLocation(model.errorReportLocation);
            this.failureReason(model.failureReason);
        }

        public final Instant getInvocationTime() {
            return this.invocationTime;
        }

        public final void setInvocationTime(Instant invocationTime) {
            this.invocationTime = invocationTime;
        }

        @Override
        public final Builder invocationTime(Instant invocationTime) {
            this.invocationTime = invocationTime;
            return this;
        }

        public final Instant getTriggerTime() {
            return this.triggerTime;
        }

        public final void setTriggerTime(Instant triggerTime) {
            this.triggerTime = triggerTime;
        }

        @Override
        public final Builder triggerTime(Instant triggerTime) {
            this.triggerTime = triggerTime;
            return this;
        }

        public final String getRunStatus() {
            return this.runStatus;
        }

        public final void setRunStatus(String runStatus) {
            this.runStatus = runStatus;
        }

        @Override
        public final Builder runStatus(String runStatus) {
            this.runStatus = runStatus;
            return this;
        }

        @Override
        public final Builder runStatus(ScheduledQueryRunStatus runStatus) {
            this.runStatus(runStatus == null ? null : runStatus.toString());
            return this;
        }

        public final ExecutionStats.Builder getExecutionStats() {
            return this.executionStats != null ? this.executionStats.toBuilder() : null;
        }

        public final void setExecutionStats(ExecutionStats.BuilderImpl executionStats) {
            this.executionStats = executionStats != null ? executionStats.build() : null;
        }

        @Override
        public final Builder executionStats(ExecutionStats executionStats) {
            this.executionStats = executionStats;
            return this;
        }

        public final ScheduledQueryInsightsResponse.Builder getQueryInsightsResponse() {
            return this.queryInsightsResponse != null ? this.queryInsightsResponse.toBuilder() : null;
        }

        public final void setQueryInsightsResponse(ScheduledQueryInsightsResponse.BuilderImpl queryInsightsResponse) {
            this.queryInsightsResponse = queryInsightsResponse != null ? queryInsightsResponse.build() : null;
        }

        @Override
        public final Builder queryInsightsResponse(ScheduledQueryInsightsResponse queryInsightsResponse) {
            this.queryInsightsResponse = queryInsightsResponse;
            return this;
        }

        public final ErrorReportLocation.Builder getErrorReportLocation() {
            return this.errorReportLocation != null ? this.errorReportLocation.toBuilder() : null;
        }

        public final void setErrorReportLocation(ErrorReportLocation.BuilderImpl errorReportLocation) {
            this.errorReportLocation = errorReportLocation != null ? errorReportLocation.build() : null;
        }

        @Override
        public final Builder errorReportLocation(ErrorReportLocation errorReportLocation) {
            this.errorReportLocation = errorReportLocation;
            return this;
        }

        public final String getFailureReason() {
            return this.failureReason;
        }

        public final void setFailureReason(String failureReason) {
            this.failureReason = failureReason;
        }

        @Override
        public final Builder failureReason(String failureReason) {
            this.failureReason = failureReason;
            return this;
        }

        public ScheduledQueryRunSummary build() {
            return new ScheduledQueryRunSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ScheduledQueryRunSummary> {
        public Builder invocationTime(Instant var1);

        public Builder triggerTime(Instant var1);

        public Builder runStatus(String var1);

        public Builder runStatus(ScheduledQueryRunStatus var1);

        public Builder executionStats(ExecutionStats var1);

        default public Builder executionStats(Consumer<ExecutionStats.Builder> executionStats) {
            return this.executionStats((ExecutionStats)((ExecutionStats.Builder)ExecutionStats.builder().applyMutation(executionStats)).build());
        }

        public Builder queryInsightsResponse(ScheduledQueryInsightsResponse var1);

        default public Builder queryInsightsResponse(Consumer<ScheduledQueryInsightsResponse.Builder> queryInsightsResponse) {
            return this.queryInsightsResponse((ScheduledQueryInsightsResponse)((ScheduledQueryInsightsResponse.Builder)ScheduledQueryInsightsResponse.builder().applyMutation(queryInsightsResponse)).build());
        }

        public Builder errorReportLocation(ErrorReportLocation var1);

        default public Builder errorReportLocation(Consumer<ErrorReportLocation.Builder> errorReportLocation) {
            return this.errorReportLocation((ErrorReportLocation)((ErrorReportLocation.Builder)ErrorReportLocation.builder().applyMutation(errorReportLocation)).build());
        }

        public Builder failureReason(String var1);
    }
}

