/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.timestreamquery;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.timestreamquery.DefaultTimestreamQueryBaseClientBuilder;
import software.amazon.awssdk.services.timestreamquery.DefaultTimestreamQueryClient;
import software.amazon.awssdk.services.timestreamquery.TimestreamQueryClient;
import software.amazon.awssdk.services.timestreamquery.TimestreamQueryClientBuilder;
import software.amazon.awssdk.services.timestreamquery.TimestreamQueryServiceClientConfiguration;
import software.amazon.awssdk.services.timestreamquery.endpoints.TimestreamQueryEndpointProvider;

@SdkInternalApi
final class DefaultTimestreamQueryClientBuilder
extends DefaultTimestreamQueryBaseClientBuilder<TimestreamQueryClientBuilder, TimestreamQueryClient>
implements TimestreamQueryClientBuilder {
    DefaultTimestreamQueryClientBuilder() {
    }

    @Override
    public DefaultTimestreamQueryClientBuilder endpointDiscoveryEnabled(boolean endpointDiscoveryEnabled) {
        this.endpointDiscoveryEnabled = endpointDiscoveryEnabled;
        return this;
    }

    @Override
    public DefaultTimestreamQueryClientBuilder endpointProvider(TimestreamQueryEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final TimestreamQueryClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.syncClientConfiguration();
        DefaultTimestreamQueryClientBuilder.validateClientOptions(clientConfiguration);
        URI endpointOverride = null;
        if (clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN) != null && Boolean.TRUE.equals(clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        TimestreamQueryServiceClientConfiguration serviceClientConfiguration = TimestreamQueryServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfiguration.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).build();
        return new DefaultTimestreamQueryClient(serviceClientConfiguration, clientConfiguration);
    }
}

