/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.timestreamquery.model;

import java.beans.Transient;
import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.timestreamquery.model.ErrorReportConfiguration;
import software.amazon.awssdk.services.timestreamquery.model.NotificationConfiguration;
import software.amazon.awssdk.services.timestreamquery.model.ScheduleConfiguration;
import software.amazon.awssdk.services.timestreamquery.model.ScheduledQueryRunSummary;
import software.amazon.awssdk.services.timestreamquery.model.ScheduledQueryRunSummaryListCopier;
import software.amazon.awssdk.services.timestreamquery.model.ScheduledQueryState;
import software.amazon.awssdk.services.timestreamquery.model.TargetConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ScheduledQueryDescription
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ScheduledQueryDescription> {
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Arn").getter(ScheduledQueryDescription.getter(ScheduledQueryDescription::arn)).setter(ScheduledQueryDescription.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(ScheduledQueryDescription.getter(ScheduledQueryDescription::name)).setter(ScheduledQueryDescription.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> QUERY_STRING_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("QueryString").getter(ScheduledQueryDescription.getter(ScheduledQueryDescription::queryString)).setter(ScheduledQueryDescription.setter(Builder::queryString)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QueryString").build()}).build();
    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreationTime").getter(ScheduledQueryDescription.getter(ScheduledQueryDescription::creationTime)).setter(ScheduledQueryDescription.setter(Builder::creationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()}).build();
    private static final SdkField<String> STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("State").getter(ScheduledQueryDescription.getter(ScheduledQueryDescription::stateAsString)).setter(ScheduledQueryDescription.setter(Builder::state)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State").build()}).build();
    private static final SdkField<Instant> PREVIOUS_INVOCATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("PreviousInvocationTime").getter(ScheduledQueryDescription.getter(ScheduledQueryDescription::previousInvocationTime)).setter(ScheduledQueryDescription.setter(Builder::previousInvocationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PreviousInvocationTime").build()}).build();
    private static final SdkField<Instant> NEXT_INVOCATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("NextInvocationTime").getter(ScheduledQueryDescription.getter(ScheduledQueryDescription::nextInvocationTime)).setter(ScheduledQueryDescription.setter(Builder::nextInvocationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextInvocationTime").build()}).build();
    private static final SdkField<ScheduleConfiguration> SCHEDULE_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ScheduleConfiguration").getter(ScheduledQueryDescription.getter(ScheduledQueryDescription::scheduleConfiguration)).setter(ScheduledQueryDescription.setter(Builder::scheduleConfiguration)).constructor(ScheduleConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScheduleConfiguration").build()}).build();
    private static final SdkField<NotificationConfiguration> NOTIFICATION_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("NotificationConfiguration").getter(ScheduledQueryDescription.getter(ScheduledQueryDescription::notificationConfiguration)).setter(ScheduledQueryDescription.setter(Builder::notificationConfiguration)).constructor(NotificationConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NotificationConfiguration").build()}).build();
    private static final SdkField<TargetConfiguration> TARGET_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("TargetConfiguration").getter(ScheduledQueryDescription.getter(ScheduledQueryDescription::targetConfiguration)).setter(ScheduledQueryDescription.setter(Builder::targetConfiguration)).constructor(TargetConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetConfiguration").build()}).build();
    private static final SdkField<String> SCHEDULED_QUERY_EXECUTION_ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ScheduledQueryExecutionRoleArn").getter(ScheduledQueryDescription.getter(ScheduledQueryDescription::scheduledQueryExecutionRoleArn)).setter(ScheduledQueryDescription.setter(Builder::scheduledQueryExecutionRoleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScheduledQueryExecutionRoleArn").build()}).build();
    private static final SdkField<String> KMS_KEY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("KmsKeyId").getter(ScheduledQueryDescription.getter(ScheduledQueryDescription::kmsKeyId)).setter(ScheduledQueryDescription.setter(Builder::kmsKeyId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KmsKeyId").build()}).build();
    private static final SdkField<ErrorReportConfiguration> ERROR_REPORT_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ErrorReportConfiguration").getter(ScheduledQueryDescription.getter(ScheduledQueryDescription::errorReportConfiguration)).setter(ScheduledQueryDescription.setter(Builder::errorReportConfiguration)).constructor(ErrorReportConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ErrorReportConfiguration").build()}).build();
    private static final SdkField<ScheduledQueryRunSummary> LAST_RUN_SUMMARY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("LastRunSummary").getter(ScheduledQueryDescription.getter(ScheduledQueryDescription::lastRunSummary)).setter(ScheduledQueryDescription.setter(Builder::lastRunSummary)).constructor(ScheduledQueryRunSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastRunSummary").build()}).build();
    private static final SdkField<List<ScheduledQueryRunSummary>> RECENTLY_FAILED_RUNS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("RecentlyFailedRuns").getter(ScheduledQueryDescription.getter(ScheduledQueryDescription::recentlyFailedRuns)).setter(ScheduledQueryDescription.setter(Builder::recentlyFailedRuns)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RecentlyFailedRuns").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ScheduledQueryRunSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, NAME_FIELD, QUERY_STRING_FIELD, CREATION_TIME_FIELD, STATE_FIELD, PREVIOUS_INVOCATION_TIME_FIELD, NEXT_INVOCATION_TIME_FIELD, SCHEDULE_CONFIGURATION_FIELD, NOTIFICATION_CONFIGURATION_FIELD, TARGET_CONFIGURATION_FIELD, SCHEDULED_QUERY_EXECUTION_ROLE_ARN_FIELD, KMS_KEY_ID_FIELD, ERROR_REPORT_CONFIGURATION_FIELD, LAST_RUN_SUMMARY_FIELD, RECENTLY_FAILED_RUNS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String arn;
    private final String name;
    private final String queryString;
    private final Instant creationTime;
    private final String state;
    private final Instant previousInvocationTime;
    private final Instant nextInvocationTime;
    private final ScheduleConfiguration scheduleConfiguration;
    private final NotificationConfiguration notificationConfiguration;
    private final TargetConfiguration targetConfiguration;
    private final String scheduledQueryExecutionRoleArn;
    private final String kmsKeyId;
    private final ErrorReportConfiguration errorReportConfiguration;
    private final ScheduledQueryRunSummary lastRunSummary;
    private final List<ScheduledQueryRunSummary> recentlyFailedRuns;

    private ScheduledQueryDescription(BuilderImpl builder) {
        this.arn = builder.arn;
        this.name = builder.name;
        this.queryString = builder.queryString;
        this.creationTime = builder.creationTime;
        this.state = builder.state;
        this.previousInvocationTime = builder.previousInvocationTime;
        this.nextInvocationTime = builder.nextInvocationTime;
        this.scheduleConfiguration = builder.scheduleConfiguration;
        this.notificationConfiguration = builder.notificationConfiguration;
        this.targetConfiguration = builder.targetConfiguration;
        this.scheduledQueryExecutionRoleArn = builder.scheduledQueryExecutionRoleArn;
        this.kmsKeyId = builder.kmsKeyId;
        this.errorReportConfiguration = builder.errorReportConfiguration;
        this.lastRunSummary = builder.lastRunSummary;
        this.recentlyFailedRuns = builder.recentlyFailedRuns;
    }

    public final String arn() {
        return this.arn;
    }

    public final String name() {
        return this.name;
    }

    public final String queryString() {
        return this.queryString;
    }

    public final Instant creationTime() {
        return this.creationTime;
    }

    public final ScheduledQueryState state() {
        return ScheduledQueryState.fromValue(this.state);
    }

    public final String stateAsString() {
        return this.state;
    }

    public final Instant previousInvocationTime() {
        return this.previousInvocationTime;
    }

    public final Instant nextInvocationTime() {
        return this.nextInvocationTime;
    }

    public final ScheduleConfiguration scheduleConfiguration() {
        return this.scheduleConfiguration;
    }

    public final NotificationConfiguration notificationConfiguration() {
        return this.notificationConfiguration;
    }

    public final TargetConfiguration targetConfiguration() {
        return this.targetConfiguration;
    }

    public final String scheduledQueryExecutionRoleArn() {
        return this.scheduledQueryExecutionRoleArn;
    }

    public final String kmsKeyId() {
        return this.kmsKeyId;
    }

    public final ErrorReportConfiguration errorReportConfiguration() {
        return this.errorReportConfiguration;
    }

    public final ScheduledQueryRunSummary lastRunSummary() {
        return this.lastRunSummary;
    }

    public final boolean hasRecentlyFailedRuns() {
        return this.recentlyFailedRuns != null && !(this.recentlyFailedRuns instanceof SdkAutoConstructList);
    }

    public final List<ScheduledQueryRunSummary> recentlyFailedRuns() {
        return this.recentlyFailedRuns;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.queryString());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.previousInvocationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextInvocationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.scheduleConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.notificationConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.targetConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.scheduledQueryExecutionRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.kmsKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(this.errorReportConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastRunSummary());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRecentlyFailedRuns() ? this.recentlyFailedRuns() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ScheduledQueryDescription)) {
            return false;
        }
        ScheduledQueryDescription other = (ScheduledQueryDescription)obj;
        return Objects.equals(this.arn(), other.arn()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.queryString(), other.queryString()) && Objects.equals(this.creationTime(), other.creationTime()) && Objects.equals(this.stateAsString(), other.stateAsString()) && Objects.equals(this.previousInvocationTime(), other.previousInvocationTime()) && Objects.equals(this.nextInvocationTime(), other.nextInvocationTime()) && Objects.equals(this.scheduleConfiguration(), other.scheduleConfiguration()) && Objects.equals(this.notificationConfiguration(), other.notificationConfiguration()) && Objects.equals(this.targetConfiguration(), other.targetConfiguration()) && Objects.equals(this.scheduledQueryExecutionRoleArn(), other.scheduledQueryExecutionRoleArn()) && Objects.equals(this.kmsKeyId(), other.kmsKeyId()) && Objects.equals(this.errorReportConfiguration(), other.errorReportConfiguration()) && Objects.equals(this.lastRunSummary(), other.lastRunSummary()) && this.hasRecentlyFailedRuns() == other.hasRecentlyFailedRuns() && Objects.equals(this.recentlyFailedRuns(), other.recentlyFailedRuns());
    }

    public final String toString() {
        return ToString.builder((String)"ScheduledQueryDescription").add("Arn", (Object)this.arn()).add("Name", (Object)this.name()).add("QueryString", (Object)(this.queryString() == null ? null : "*** Sensitive Data Redacted ***")).add("CreationTime", (Object)this.creationTime()).add("State", (Object)this.stateAsString()).add("PreviousInvocationTime", (Object)this.previousInvocationTime()).add("NextInvocationTime", (Object)this.nextInvocationTime()).add("ScheduleConfiguration", (Object)this.scheduleConfiguration()).add("NotificationConfiguration", (Object)this.notificationConfiguration()).add("TargetConfiguration", (Object)this.targetConfiguration()).add("ScheduledQueryExecutionRoleArn", (Object)this.scheduledQueryExecutionRoleArn()).add("KmsKeyId", (Object)this.kmsKeyId()).add("ErrorReportConfiguration", (Object)this.errorReportConfiguration()).add("LastRunSummary", (Object)this.lastRunSummary()).add("RecentlyFailedRuns", this.hasRecentlyFailedRuns() ? this.recentlyFailedRuns() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "QueryString": {
                return Optional.ofNullable(clazz.cast(this.queryString()));
            }
            case "CreationTime": {
                return Optional.ofNullable(clazz.cast(this.creationTime()));
            }
            case "State": {
                return Optional.ofNullable(clazz.cast(this.stateAsString()));
            }
            case "PreviousInvocationTime": {
                return Optional.ofNullable(clazz.cast(this.previousInvocationTime()));
            }
            case "NextInvocationTime": {
                return Optional.ofNullable(clazz.cast(this.nextInvocationTime()));
            }
            case "ScheduleConfiguration": {
                return Optional.ofNullable(clazz.cast(this.scheduleConfiguration()));
            }
            case "NotificationConfiguration": {
                return Optional.ofNullable(clazz.cast(this.notificationConfiguration()));
            }
            case "TargetConfiguration": {
                return Optional.ofNullable(clazz.cast(this.targetConfiguration()));
            }
            case "ScheduledQueryExecutionRoleArn": {
                return Optional.ofNullable(clazz.cast(this.scheduledQueryExecutionRoleArn()));
            }
            case "KmsKeyId": {
                return Optional.ofNullable(clazz.cast(this.kmsKeyId()));
            }
            case "ErrorReportConfiguration": {
                return Optional.ofNullable(clazz.cast(this.errorReportConfiguration()));
            }
            case "LastRunSummary": {
                return Optional.ofNullable(clazz.cast(this.lastRunSummary()));
            }
            case "RecentlyFailedRuns": {
                return Optional.ofNullable(clazz.cast(this.recentlyFailedRuns()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ScheduledQueryDescription, T> g) {
        return obj -> g.apply((ScheduledQueryDescription)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String arn;
        private String name;
        private String queryString;
        private Instant creationTime;
        private String state;
        private Instant previousInvocationTime;
        private Instant nextInvocationTime;
        private ScheduleConfiguration scheduleConfiguration;
        private NotificationConfiguration notificationConfiguration;
        private TargetConfiguration targetConfiguration;
        private String scheduledQueryExecutionRoleArn;
        private String kmsKeyId;
        private ErrorReportConfiguration errorReportConfiguration;
        private ScheduledQueryRunSummary lastRunSummary;
        private List<ScheduledQueryRunSummary> recentlyFailedRuns = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ScheduledQueryDescription model) {
            this.arn(model.arn);
            this.name(model.name);
            this.queryString(model.queryString);
            this.creationTime(model.creationTime);
            this.state(model.state);
            this.previousInvocationTime(model.previousInvocationTime);
            this.nextInvocationTime(model.nextInvocationTime);
            this.scheduleConfiguration(model.scheduleConfiguration);
            this.notificationConfiguration(model.notificationConfiguration);
            this.targetConfiguration(model.targetConfiguration);
            this.scheduledQueryExecutionRoleArn(model.scheduledQueryExecutionRoleArn);
            this.kmsKeyId(model.kmsKeyId);
            this.errorReportConfiguration(model.errorReportConfiguration);
            this.lastRunSummary(model.lastRunSummary);
            this.recentlyFailedRuns(model.recentlyFailedRuns);
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        @Transient
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        @Transient
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getQueryString() {
            return this.queryString;
        }

        public final void setQueryString(String queryString) {
            this.queryString = queryString;
        }

        @Override
        @Transient
        public final Builder queryString(String queryString) {
            this.queryString = queryString;
            return this;
        }

        public final Instant getCreationTime() {
            return this.creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        @Transient
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final String getState() {
            return this.state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        @Transient
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        @Transient
        public final Builder state(ScheduledQueryState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final Instant getPreviousInvocationTime() {
            return this.previousInvocationTime;
        }

        public final void setPreviousInvocationTime(Instant previousInvocationTime) {
            this.previousInvocationTime = previousInvocationTime;
        }

        @Override
        @Transient
        public final Builder previousInvocationTime(Instant previousInvocationTime) {
            this.previousInvocationTime = previousInvocationTime;
            return this;
        }

        public final Instant getNextInvocationTime() {
            return this.nextInvocationTime;
        }

        public final void setNextInvocationTime(Instant nextInvocationTime) {
            this.nextInvocationTime = nextInvocationTime;
        }

        @Override
        @Transient
        public final Builder nextInvocationTime(Instant nextInvocationTime) {
            this.nextInvocationTime = nextInvocationTime;
            return this;
        }

        public final ScheduleConfiguration.Builder getScheduleConfiguration() {
            return this.scheduleConfiguration != null ? this.scheduleConfiguration.toBuilder() : null;
        }

        public final void setScheduleConfiguration(ScheduleConfiguration.BuilderImpl scheduleConfiguration) {
            this.scheduleConfiguration = scheduleConfiguration != null ? scheduleConfiguration.build() : null;
        }

        @Override
        @Transient
        public final Builder scheduleConfiguration(ScheduleConfiguration scheduleConfiguration) {
            this.scheduleConfiguration = scheduleConfiguration;
            return this;
        }

        public final NotificationConfiguration.Builder getNotificationConfiguration() {
            return this.notificationConfiguration != null ? this.notificationConfiguration.toBuilder() : null;
        }

        public final void setNotificationConfiguration(NotificationConfiguration.BuilderImpl notificationConfiguration) {
            this.notificationConfiguration = notificationConfiguration != null ? notificationConfiguration.build() : null;
        }

        @Override
        @Transient
        public final Builder notificationConfiguration(NotificationConfiguration notificationConfiguration) {
            this.notificationConfiguration = notificationConfiguration;
            return this;
        }

        public final TargetConfiguration.Builder getTargetConfiguration() {
            return this.targetConfiguration != null ? this.targetConfiguration.toBuilder() : null;
        }

        public final void setTargetConfiguration(TargetConfiguration.BuilderImpl targetConfiguration) {
            this.targetConfiguration = targetConfiguration != null ? targetConfiguration.build() : null;
        }

        @Override
        @Transient
        public final Builder targetConfiguration(TargetConfiguration targetConfiguration) {
            this.targetConfiguration = targetConfiguration;
            return this;
        }

        public final String getScheduledQueryExecutionRoleArn() {
            return this.scheduledQueryExecutionRoleArn;
        }

        public final void setScheduledQueryExecutionRoleArn(String scheduledQueryExecutionRoleArn) {
            this.scheduledQueryExecutionRoleArn = scheduledQueryExecutionRoleArn;
        }

        @Override
        @Transient
        public final Builder scheduledQueryExecutionRoleArn(String scheduledQueryExecutionRoleArn) {
            this.scheduledQueryExecutionRoleArn = scheduledQueryExecutionRoleArn;
            return this;
        }

        public final String getKmsKeyId() {
            return this.kmsKeyId;
        }

        public final void setKmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
        }

        @Override
        @Transient
        public final Builder kmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
            return this;
        }

        public final ErrorReportConfiguration.Builder getErrorReportConfiguration() {
            return this.errorReportConfiguration != null ? this.errorReportConfiguration.toBuilder() : null;
        }

        public final void setErrorReportConfiguration(ErrorReportConfiguration.BuilderImpl errorReportConfiguration) {
            this.errorReportConfiguration = errorReportConfiguration != null ? errorReportConfiguration.build() : null;
        }

        @Override
        @Transient
        public final Builder errorReportConfiguration(ErrorReportConfiguration errorReportConfiguration) {
            this.errorReportConfiguration = errorReportConfiguration;
            return this;
        }

        public final ScheduledQueryRunSummary.Builder getLastRunSummary() {
            return this.lastRunSummary != null ? this.lastRunSummary.toBuilder() : null;
        }

        public final void setLastRunSummary(ScheduledQueryRunSummary.BuilderImpl lastRunSummary) {
            this.lastRunSummary = lastRunSummary != null ? lastRunSummary.build() : null;
        }

        @Override
        @Transient
        public final Builder lastRunSummary(ScheduledQueryRunSummary lastRunSummary) {
            this.lastRunSummary = lastRunSummary;
            return this;
        }

        public final List<ScheduledQueryRunSummary.Builder> getRecentlyFailedRuns() {
            List<ScheduledQueryRunSummary.Builder> result = ScheduledQueryRunSummaryListCopier.copyToBuilder(this.recentlyFailedRuns);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRecentlyFailedRuns(Collection<ScheduledQueryRunSummary.BuilderImpl> recentlyFailedRuns) {
            this.recentlyFailedRuns = ScheduledQueryRunSummaryListCopier.copyFromBuilder(recentlyFailedRuns);
        }

        @Override
        @Transient
        public final Builder recentlyFailedRuns(Collection<ScheduledQueryRunSummary> recentlyFailedRuns) {
            this.recentlyFailedRuns = ScheduledQueryRunSummaryListCopier.copy(recentlyFailedRuns);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder recentlyFailedRuns(ScheduledQueryRunSummary ... recentlyFailedRuns) {
            this.recentlyFailedRuns(Arrays.asList(recentlyFailedRuns));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder recentlyFailedRuns(Consumer<ScheduledQueryRunSummary.Builder> ... recentlyFailedRuns) {
            this.recentlyFailedRuns(Stream.of(recentlyFailedRuns).map(c -> (ScheduledQueryRunSummary)((ScheduledQueryRunSummary.Builder)ScheduledQueryRunSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public ScheduledQueryDescription build() {
            return new ScheduledQueryDescription(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ScheduledQueryDescription> {
        public Builder arn(String var1);

        public Builder name(String var1);

        public Builder queryString(String var1);

        public Builder creationTime(Instant var1);

        public Builder state(String var1);

        public Builder state(ScheduledQueryState var1);

        public Builder previousInvocationTime(Instant var1);

        public Builder nextInvocationTime(Instant var1);

        public Builder scheduleConfiguration(ScheduleConfiguration var1);

        default public Builder scheduleConfiguration(Consumer<ScheduleConfiguration.Builder> scheduleConfiguration) {
            return this.scheduleConfiguration((ScheduleConfiguration)((ScheduleConfiguration.Builder)ScheduleConfiguration.builder().applyMutation(scheduleConfiguration)).build());
        }

        public Builder notificationConfiguration(NotificationConfiguration var1);

        default public Builder notificationConfiguration(Consumer<NotificationConfiguration.Builder> notificationConfiguration) {
            return this.notificationConfiguration((NotificationConfiguration)((NotificationConfiguration.Builder)NotificationConfiguration.builder().applyMutation(notificationConfiguration)).build());
        }

        public Builder targetConfiguration(TargetConfiguration var1);

        default public Builder targetConfiguration(Consumer<TargetConfiguration.Builder> targetConfiguration) {
            return this.targetConfiguration((TargetConfiguration)((TargetConfiguration.Builder)TargetConfiguration.builder().applyMutation(targetConfiguration)).build());
        }

        public Builder scheduledQueryExecutionRoleArn(String var1);

        public Builder kmsKeyId(String var1);

        public Builder errorReportConfiguration(ErrorReportConfiguration var1);

        default public Builder errorReportConfiguration(Consumer<ErrorReportConfiguration.Builder> errorReportConfiguration) {
            return this.errorReportConfiguration((ErrorReportConfiguration)((ErrorReportConfiguration.Builder)ErrorReportConfiguration.builder().applyMutation(errorReportConfiguration)).build());
        }

        public Builder lastRunSummary(ScheduledQueryRunSummary var1);

        default public Builder lastRunSummary(Consumer<ScheduledQueryRunSummary.Builder> lastRunSummary) {
            return this.lastRunSummary((ScheduledQueryRunSummary)((ScheduledQueryRunSummary.Builder)ScheduledQueryRunSummary.builder().applyMutation(lastRunSummary)).build());
        }

        public Builder recentlyFailedRuns(Collection<ScheduledQueryRunSummary> var1);

        public Builder recentlyFailedRuns(ScheduledQueryRunSummary ... var1);

        public Builder recentlyFailedRuns(Consumer<ScheduledQueryRunSummary.Builder> ... var1);
    }
}

