/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.timestreaminfluxdb.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum DurationType {
    HOURS("hours"),
    MINUTES("minutes"),
    SECONDS("seconds"),
    MILLISECONDS("milliseconds"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, DurationType> VALUE_MAP;
    private final String value;

    private DurationType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static DurationType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<DurationType> knownValues() {
        EnumSet<DurationType> knownValues = EnumSet.allOf(DurationType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(DurationType.class, DurationType::toString);
    }
}

