/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.textract.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.textract.model.AdapterVersionListCopier;
import software.amazon.awssdk.services.textract.model.AdapterVersionOverview;
import software.amazon.awssdk.services.textract.model.TextractResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListAdapterVersionsResponse
extends TextractResponse
implements ToCopyableBuilder<Builder, ListAdapterVersionsResponse> {
    private static final SdkField<List<AdapterVersionOverview>> ADAPTER_VERSIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AdapterVersions").getter(ListAdapterVersionsResponse.getter(ListAdapterVersionsResponse::adapterVersions)).setter(ListAdapterVersionsResponse.setter(Builder::adapterVersions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AdapterVersions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AdapterVersionOverview::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListAdapterVersionsResponse.getter(ListAdapterVersionsResponse::nextToken)).setter(ListAdapterVersionsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ADAPTER_VERSIONS_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListAdapterVersionsResponse.memberNameToFieldInitializer();
    private final List<AdapterVersionOverview> adapterVersions;
    private final String nextToken;

    private ListAdapterVersionsResponse(BuilderImpl builder) {
        super(builder);
        this.adapterVersions = builder.adapterVersions;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasAdapterVersions() {
        return this.adapterVersions != null && !(this.adapterVersions instanceof SdkAutoConstructList);
    }

    public final List<AdapterVersionOverview> adapterVersions() {
        return this.adapterVersions;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAdapterVersions() ? this.adapterVersions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListAdapterVersionsResponse)) {
            return false;
        }
        ListAdapterVersionsResponse other = (ListAdapterVersionsResponse)((Object)obj);
        return this.hasAdapterVersions() == other.hasAdapterVersions() && Objects.equals(this.adapterVersions(), other.adapterVersions()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListAdapterVersionsResponse").add("AdapterVersions", this.hasAdapterVersions() ? this.adapterVersions() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AdapterVersions": {
                return Optional.ofNullable(clazz.cast(this.adapterVersions()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("AdapterVersions", ADAPTER_VERSIONS_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListAdapterVersionsResponse, T> g) {
        return obj -> g.apply((ListAdapterVersionsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends TextractResponse.BuilderImpl
    implements Builder {
        private List<AdapterVersionOverview> adapterVersions = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListAdapterVersionsResponse model) {
            super(model);
            this.adapterVersions(model.adapterVersions);
            this.nextToken(model.nextToken);
        }

        public final List<AdapterVersionOverview.Builder> getAdapterVersions() {
            List<AdapterVersionOverview.Builder> result = AdapterVersionListCopier.copyToBuilder(this.adapterVersions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAdapterVersions(Collection<AdapterVersionOverview.BuilderImpl> adapterVersions) {
            this.adapterVersions = AdapterVersionListCopier.copyFromBuilder(adapterVersions);
        }

        @Override
        public final Builder adapterVersions(Collection<AdapterVersionOverview> adapterVersions) {
            this.adapterVersions = AdapterVersionListCopier.copy(adapterVersions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder adapterVersions(AdapterVersionOverview ... adapterVersions) {
            this.adapterVersions(Arrays.asList(adapterVersions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder adapterVersions(Consumer<AdapterVersionOverview.Builder> ... adapterVersions) {
            this.adapterVersions(Stream.of(adapterVersions).map(c -> (AdapterVersionOverview)((AdapterVersionOverview.Builder)AdapterVersionOverview.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListAdapterVersionsResponse build() {
            return new ListAdapterVersionsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends TextractResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListAdapterVersionsResponse> {
        public Builder adapterVersions(Collection<AdapterVersionOverview> var1);

        public Builder adapterVersions(AdapterVersionOverview ... var1);

        public Builder adapterVersions(Consumer<AdapterVersionOverview.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

