/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.textract.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about how blocks are related to each other. A <code>Block</code> object contains 0 or more
 * <code>Relation</code> objects in a list, <code>Relationships</code>. For more information, see <a>Block</a>.
 * </p>
 * <p>
 * The <code>Type</code> element provides the type of the relationship for all blocks in the <code>IDs</code> array.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Relationship implements SdkPojo, Serializable, ToCopyableBuilder<Relationship.Builder, Relationship> {
    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Type")
            .getter(getter(Relationship::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()).build();

    private static final SdkField<List<String>> IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("Ids")
            .getter(getter(Relationship::ids))
            .setter(setter(Builder::ids))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Ids").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TYPE_FIELD, IDS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String type;

    private final List<String> ids;

    private Relationship(BuilderImpl builder) {
        this.type = builder.type;
        this.ids = builder.ids;
    }

    /**
     * <p>
     * The type of relationship between the blocks in the IDs array and the current block. The following list describes
     * the relationship types that can be returned.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <i>VALUE</i> - A list that contains the ID of the VALUE block that's associated with the KEY of a key-value pair.
     * </p>
     * </li>
     * <li>
     * <p>
     * <i>CHILD</i> - A list of IDs that identify blocks found within the current block object. For example, WORD blocks
     * have a CHILD relationship to the LINE block type.
     * </p>
     * </li>
     * <li>
     * <p>
     * <i>MERGED_CELL</i> - A list of IDs that identify each of the MERGED_CELL block types in a table.
     * </p>
     * </li>
     * <li>
     * <p>
     * <i>ANSWER</i> - A list that contains the ID of the QUERY_RESULT block that’s associated with the corresponding
     * QUERY block.
     * </p>
     * </li>
     * <li>
     * <p>
     * <i>TABLE</i> - A list of IDs that identify associated TABLE block types.
     * </p>
     * </li>
     * <li>
     * <p>
     * <i>TABLE_TITLE</i> - A list that contains the ID for the TABLE_TITLE block type in a table.
     * </p>
     * </li>
     * <li>
     * <p>
     * <i>TABLE_FOOTER</i> - A list of IDs that identify the TABLE_FOOTER block types in a table.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link RelationshipType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of relationship between the blocks in the IDs array and the current block. The following list
     *         describes the relationship types that can be returned. </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <i>VALUE</i> - A list that contains the ID of the VALUE block that's associated with the KEY of a
     *         key-value pair.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <i>CHILD</i> - A list of IDs that identify blocks found within the current block object. For example,
     *         WORD blocks have a CHILD relationship to the LINE block type.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <i>MERGED_CELL</i> - A list of IDs that identify each of the MERGED_CELL block types in a table.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <i>ANSWER</i> - A list that contains the ID of the QUERY_RESULT block that’s associated with the
     *         corresponding QUERY block.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <i>TABLE</i> - A list of IDs that identify associated TABLE block types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <i>TABLE_TITLE</i> - A list that contains the ID for the TABLE_TITLE block type in a table.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <i>TABLE_FOOTER</i> - A list of IDs that identify the TABLE_FOOTER block types in a table.
     *         </p>
     *         </li>
     * @see RelationshipType
     */
    public final RelationshipType type() {
        return RelationshipType.fromValue(type);
    }

    /**
     * <p>
     * The type of relationship between the blocks in the IDs array and the current block. The following list describes
     * the relationship types that can be returned.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <i>VALUE</i> - A list that contains the ID of the VALUE block that's associated with the KEY of a key-value pair.
     * </p>
     * </li>
     * <li>
     * <p>
     * <i>CHILD</i> - A list of IDs that identify blocks found within the current block object. For example, WORD blocks
     * have a CHILD relationship to the LINE block type.
     * </p>
     * </li>
     * <li>
     * <p>
     * <i>MERGED_CELL</i> - A list of IDs that identify each of the MERGED_CELL block types in a table.
     * </p>
     * </li>
     * <li>
     * <p>
     * <i>ANSWER</i> - A list that contains the ID of the QUERY_RESULT block that’s associated with the corresponding
     * QUERY block.
     * </p>
     * </li>
     * <li>
     * <p>
     * <i>TABLE</i> - A list of IDs that identify associated TABLE block types.
     * </p>
     * </li>
     * <li>
     * <p>
     * <i>TABLE_TITLE</i> - A list that contains the ID for the TABLE_TITLE block type in a table.
     * </p>
     * </li>
     * <li>
     * <p>
     * <i>TABLE_FOOTER</i> - A list of IDs that identify the TABLE_FOOTER block types in a table.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link RelationshipType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of relationship between the blocks in the IDs array and the current block. The following list
     *         describes the relationship types that can be returned. </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <i>VALUE</i> - A list that contains the ID of the VALUE block that's associated with the KEY of a
     *         key-value pair.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <i>CHILD</i> - A list of IDs that identify blocks found within the current block object. For example,
     *         WORD blocks have a CHILD relationship to the LINE block type.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <i>MERGED_CELL</i> - A list of IDs that identify each of the MERGED_CELL block types in a table.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <i>ANSWER</i> - A list that contains the ID of the QUERY_RESULT block that’s associated with the
     *         corresponding QUERY block.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <i>TABLE</i> - A list of IDs that identify associated TABLE block types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <i>TABLE_TITLE</i> - A list that contains the ID for the TABLE_TITLE block type in a table.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <i>TABLE_FOOTER</i> - A list of IDs that identify the TABLE_FOOTER block types in a table.
     *         </p>
     *         </li>
     * @see RelationshipType
     */
    public final String typeAsString() {
        return type;
    }

    /**
     * For responses, this returns true if the service returned a value for the Ids property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasIds() {
        return ids != null && !(ids instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of IDs for related blocks. You can get the type of the relationship from the <code>Type</code> element.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasIds} method.
     * </p>
     * 
     * @return An array of IDs for related blocks. You can get the type of the relationship from the <code>Type</code>
     *         element.
     */
    public final List<String> ids() {
        return ids;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasIds() ? ids() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Relationship)) {
            return false;
        }
        Relationship other = (Relationship) obj;
        return Objects.equals(typeAsString(), other.typeAsString()) && hasIds() == other.hasIds()
                && Objects.equals(ids(), other.ids());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Relationship").add("Type", typeAsString()).add("Ids", hasIds() ? ids() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        case "Ids":
            return Optional.ofNullable(clazz.cast(ids()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Type", TYPE_FIELD);
        map.put("Ids", IDS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Relationship, T> g) {
        return obj -> g.apply((Relationship) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Relationship> {
        /**
         * <p>
         * The type of relationship between the blocks in the IDs array and the current block. The following list
         * describes the relationship types that can be returned.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <i>VALUE</i> - A list that contains the ID of the VALUE block that's associated with the KEY of a key-value
         * pair.
         * </p>
         * </li>
         * <li>
         * <p>
         * <i>CHILD</i> - A list of IDs that identify blocks found within the current block object. For example, WORD
         * blocks have a CHILD relationship to the LINE block type.
         * </p>
         * </li>
         * <li>
         * <p>
         * <i>MERGED_CELL</i> - A list of IDs that identify each of the MERGED_CELL block types in a table.
         * </p>
         * </li>
         * <li>
         * <p>
         * <i>ANSWER</i> - A list that contains the ID of the QUERY_RESULT block that’s associated with the
         * corresponding QUERY block.
         * </p>
         * </li>
         * <li>
         * <p>
         * <i>TABLE</i> - A list of IDs that identify associated TABLE block types.
         * </p>
         * </li>
         * <li>
         * <p>
         * <i>TABLE_TITLE</i> - A list that contains the ID for the TABLE_TITLE block type in a table.
         * </p>
         * </li>
         * <li>
         * <p>
         * <i>TABLE_FOOTER</i> - A list of IDs that identify the TABLE_FOOTER block types in a table.
         * </p>
         * </li>
         * </ul>
         * 
         * @param type
         *        The type of relationship between the blocks in the IDs array and the current block. The following list
         *        describes the relationship types that can be returned. </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <i>VALUE</i> - A list that contains the ID of the VALUE block that's associated with the KEY of a
         *        key-value pair.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <i>CHILD</i> - A list of IDs that identify blocks found within the current block object. For example,
         *        WORD blocks have a CHILD relationship to the LINE block type.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <i>MERGED_CELL</i> - A list of IDs that identify each of the MERGED_CELL block types in a table.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <i>ANSWER</i> - A list that contains the ID of the QUERY_RESULT block that’s associated with the
         *        corresponding QUERY block.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <i>TABLE</i> - A list of IDs that identify associated TABLE block types.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <i>TABLE_TITLE</i> - A list that contains the ID for the TABLE_TITLE block type in a table.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <i>TABLE_FOOTER</i> - A list of IDs that identify the TABLE_FOOTER block types in a table.
         *        </p>
         *        </li>
         * @see RelationshipType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RelationshipType
         */
        Builder type(String type);

        /**
         * <p>
         * The type of relationship between the blocks in the IDs array and the current block. The following list
         * describes the relationship types that can be returned.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <i>VALUE</i> - A list that contains the ID of the VALUE block that's associated with the KEY of a key-value
         * pair.
         * </p>
         * </li>
         * <li>
         * <p>
         * <i>CHILD</i> - A list of IDs that identify blocks found within the current block object. For example, WORD
         * blocks have a CHILD relationship to the LINE block type.
         * </p>
         * </li>
         * <li>
         * <p>
         * <i>MERGED_CELL</i> - A list of IDs that identify each of the MERGED_CELL block types in a table.
         * </p>
         * </li>
         * <li>
         * <p>
         * <i>ANSWER</i> - A list that contains the ID of the QUERY_RESULT block that’s associated with the
         * corresponding QUERY block.
         * </p>
         * </li>
         * <li>
         * <p>
         * <i>TABLE</i> - A list of IDs that identify associated TABLE block types.
         * </p>
         * </li>
         * <li>
         * <p>
         * <i>TABLE_TITLE</i> - A list that contains the ID for the TABLE_TITLE block type in a table.
         * </p>
         * </li>
         * <li>
         * <p>
         * <i>TABLE_FOOTER</i> - A list of IDs that identify the TABLE_FOOTER block types in a table.
         * </p>
         * </li>
         * </ul>
         * 
         * @param type
         *        The type of relationship between the blocks in the IDs array and the current block. The following list
         *        describes the relationship types that can be returned. </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <i>VALUE</i> - A list that contains the ID of the VALUE block that's associated with the KEY of a
         *        key-value pair.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <i>CHILD</i> - A list of IDs that identify blocks found within the current block object. For example,
         *        WORD blocks have a CHILD relationship to the LINE block type.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <i>MERGED_CELL</i> - A list of IDs that identify each of the MERGED_CELL block types in a table.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <i>ANSWER</i> - A list that contains the ID of the QUERY_RESULT block that’s associated with the
         *        corresponding QUERY block.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <i>TABLE</i> - A list of IDs that identify associated TABLE block types.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <i>TABLE_TITLE</i> - A list that contains the ID for the TABLE_TITLE block type in a table.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <i>TABLE_FOOTER</i> - A list of IDs that identify the TABLE_FOOTER block types in a table.
         *        </p>
         *        </li>
         * @see RelationshipType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RelationshipType
         */
        Builder type(RelationshipType type);

        /**
         * <p>
         * An array of IDs for related blocks. You can get the type of the relationship from the <code>Type</code>
         * element.
         * </p>
         * 
         * @param ids
         *        An array of IDs for related blocks. You can get the type of the relationship from the
         *        <code>Type</code> element.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ids(Collection<String> ids);

        /**
         * <p>
         * An array of IDs for related blocks. You can get the type of the relationship from the <code>Type</code>
         * element.
         * </p>
         * 
         * @param ids
         *        An array of IDs for related blocks. You can get the type of the relationship from the
         *        <code>Type</code> element.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ids(String... ids);
    }

    static final class BuilderImpl implements Builder {
        private String type;

        private List<String> ids = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(Relationship model) {
            type(model.type);
            ids(model.ids);
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(RelationshipType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final Collection<String> getIds() {
            if (ids instanceof SdkAutoConstructList) {
                return null;
            }
            return ids;
        }

        public final void setIds(Collection<String> ids) {
            this.ids = IdListCopier.copy(ids);
        }

        @Override
        public final Builder ids(Collection<String> ids) {
            this.ids = IdListCopier.copy(ids);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ids(String... ids) {
            ids(Arrays.asList(ids));
            return this;
        }

        @Override
        public Relationship build() {
            return new Relationship(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
