/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.textract.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.textract.model.Extraction;
import software.amazon.awssdk.services.textract.model.ExtractionListCopier;
import software.amazon.awssdk.services.textract.model.PageClassification;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class LendingResult
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, LendingResult> {
    private static final SdkField<Integer> PAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Page").getter(LendingResult.getter(LendingResult::page)).setter(LendingResult.setter(Builder::page)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Page").build()}).build();
    private static final SdkField<PageClassification> PAGE_CLASSIFICATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("PageClassification").getter(LendingResult.getter(LendingResult::pageClassification)).setter(LendingResult.setter(Builder::pageClassification)).constructor(PageClassification::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PageClassification").build()}).build();
    private static final SdkField<List<Extraction>> EXTRACTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Extractions").getter(LendingResult.getter(LendingResult::extractions)).setter(LendingResult.setter(Builder::extractions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Extractions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Extraction::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PAGE_FIELD, PAGE_CLASSIFICATION_FIELD, EXTRACTIONS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = LendingResult.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Integer page;
    private final PageClassification pageClassification;
    private final List<Extraction> extractions;

    private LendingResult(BuilderImpl builder) {
        this.page = builder.page;
        this.pageClassification = builder.pageClassification;
        this.extractions = builder.extractions;
    }

    public final Integer page() {
        return this.page;
    }

    public final PageClassification pageClassification() {
        return this.pageClassification;
    }

    public final boolean hasExtractions() {
        return this.extractions != null && !(this.extractions instanceof SdkAutoConstructList);
    }

    public final List<Extraction> extractions() {
        return this.extractions;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.page());
        hashCode = 31 * hashCode + Objects.hashCode(this.pageClassification());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasExtractions() ? this.extractions() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LendingResult)) {
            return false;
        }
        LendingResult other = (LendingResult)obj;
        return Objects.equals(this.page(), other.page()) && Objects.equals(this.pageClassification(), other.pageClassification()) && this.hasExtractions() == other.hasExtractions() && Objects.equals(this.extractions(), other.extractions());
    }

    public final String toString() {
        return ToString.builder((String)"LendingResult").add("Page", (Object)this.page()).add("PageClassification", (Object)this.pageClassification()).add("Extractions", this.hasExtractions() ? this.extractions() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Page": {
                return Optional.ofNullable(clazz.cast(this.page()));
            }
            case "PageClassification": {
                return Optional.ofNullable(clazz.cast(this.pageClassification()));
            }
            case "Extractions": {
                return Optional.ofNullable(clazz.cast(this.extractions()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Page", PAGE_FIELD);
        map.put("PageClassification", PAGE_CLASSIFICATION_FIELD);
        map.put("Extractions", EXTRACTIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<LendingResult, T> g) {
        return obj -> g.apply((LendingResult)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Integer page;
        private PageClassification pageClassification;
        private List<Extraction> extractions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(LendingResult model) {
            this.page(model.page);
            this.pageClassification(model.pageClassification);
            this.extractions(model.extractions);
        }

        public final Integer getPage() {
            return this.page;
        }

        public final void setPage(Integer page) {
            this.page = page;
        }

        @Override
        public final Builder page(Integer page) {
            this.page = page;
            return this;
        }

        public final PageClassification.Builder getPageClassification() {
            return this.pageClassification != null ? this.pageClassification.toBuilder() : null;
        }

        public final void setPageClassification(PageClassification.BuilderImpl pageClassification) {
            this.pageClassification = pageClassification != null ? pageClassification.build() : null;
        }

        @Override
        public final Builder pageClassification(PageClassification pageClassification) {
            this.pageClassification = pageClassification;
            return this;
        }

        public final List<Extraction.Builder> getExtractions() {
            List<Extraction.Builder> result = ExtractionListCopier.copyToBuilder(this.extractions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setExtractions(Collection<Extraction.BuilderImpl> extractions) {
            this.extractions = ExtractionListCopier.copyFromBuilder(extractions);
        }

        @Override
        public final Builder extractions(Collection<Extraction> extractions) {
            this.extractions = ExtractionListCopier.copy(extractions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder extractions(Extraction ... extractions) {
            this.extractions(Arrays.asList(extractions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder extractions(Consumer<Extraction.Builder> ... extractions) {
            this.extractions(Stream.of(extractions).map(c -> (Extraction)((Extraction.Builder)Extraction.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public LendingResult build() {
            return new LendingResult(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, LendingResult> {
        public Builder page(Integer var1);

        public Builder pageClassification(PageClassification var1);

        default public Builder pageClassification(Consumer<PageClassification.Builder> pageClassification) {
            return this.pageClassification((PageClassification)((PageClassification.Builder)PageClassification.builder().applyMutation(pageClassification)).build());
        }

        public Builder extractions(Collection<Extraction> var1);

        public Builder extractions(Extraction ... var1);

        public Builder extractions(Consumer<Extraction.Builder> ... var1);
    }
}

