/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.textract.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.textract.model.PageListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SplitDocument
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SplitDocument> {
    private static final SdkField<Integer> INDEX_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Index").getter(SplitDocument.getter(SplitDocument::index)).setter(SplitDocument.setter(Builder::index)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Index").build()}).build();
    private static final SdkField<List<Integer>> PAGES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Pages").getter(SplitDocument.getter(SplitDocument::pages)).setter(SplitDocument.setter(Builder::pages)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Pages").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.INTEGER).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INDEX_FIELD, PAGES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("Index", INDEX_FIELD);
            this.put("Pages", PAGES_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final Integer index;
    private final List<Integer> pages;

    private SplitDocument(BuilderImpl builder) {
        this.index = builder.index;
        this.pages = builder.pages;
    }

    public final Integer index() {
        return this.index;
    }

    public final boolean hasPages() {
        return this.pages != null && !(this.pages instanceof SdkAutoConstructList);
    }

    public final List<Integer> pages() {
        return this.pages;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.index());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPages() ? this.pages() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SplitDocument)) {
            return false;
        }
        SplitDocument other = (SplitDocument)obj;
        return Objects.equals(this.index(), other.index()) && this.hasPages() == other.hasPages() && Objects.equals(this.pages(), other.pages());
    }

    public final String toString() {
        return ToString.builder((String)"SplitDocument").add("Index", (Object)this.index()).add("Pages", this.hasPages() ? this.pages() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Index": {
                return Optional.ofNullable(clazz.cast(this.index()));
            }
            case "Pages": {
                return Optional.ofNullable(clazz.cast(this.pages()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<SplitDocument, T> g) {
        return obj -> g.apply((SplitDocument)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Integer index;
        private List<Integer> pages = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(SplitDocument model) {
            this.index(model.index);
            this.pages(model.pages);
        }

        public final Integer getIndex() {
            return this.index;
        }

        public final void setIndex(Integer index) {
            this.index = index;
        }

        @Override
        public final Builder index(Integer index) {
            this.index = index;
            return this;
        }

        public final Collection<Integer> getPages() {
            if (this.pages instanceof SdkAutoConstructList) {
                return null;
            }
            return this.pages;
        }

        public final void setPages(Collection<Integer> pages) {
            this.pages = PageListCopier.copy(pages);
        }

        @Override
        public final Builder pages(Collection<Integer> pages) {
            this.pages = PageListCopier.copy(pages);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder pages(Integer ... pages) {
            this.pages(Arrays.asList(pages));
            return this;
        }

        public SplitDocument build() {
            return new SplitDocument(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SplitDocument> {
        public Builder index(Integer var1);

        public Builder pages(Collection<Integer> var1);

        public Builder pages(Integer ... var1);
    }
}

