/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.textract.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ExpenseCurrency
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ExpenseCurrency> {
    private static final SdkField<String> CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Code").getter(ExpenseCurrency.getter(ExpenseCurrency::code)).setter(ExpenseCurrency.setter(Builder::code)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Code").build()}).build();
    private static final SdkField<Float> CONFIDENCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.FLOAT).memberName("Confidence").getter(ExpenseCurrency.getter(ExpenseCurrency::confidence)).setter(ExpenseCurrency.setter(Builder::confidence)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Confidence").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CODE_FIELD, CONFIDENCE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("Code", CODE_FIELD);
            this.put("Confidence", CONFIDENCE_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String code;
    private final Float confidence;

    private ExpenseCurrency(BuilderImpl builder) {
        this.code = builder.code;
        this.confidence = builder.confidence;
    }

    public final String code() {
        return this.code;
    }

    public final Float confidence() {
        return this.confidence;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.code());
        hashCode = 31 * hashCode + Objects.hashCode(this.confidence());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ExpenseCurrency)) {
            return false;
        }
        ExpenseCurrency other = (ExpenseCurrency)obj;
        return Objects.equals(this.code(), other.code()) && Objects.equals(this.confidence(), other.confidence());
    }

    public final String toString() {
        return ToString.builder((String)"ExpenseCurrency").add("Code", (Object)this.code()).add("Confidence", (Object)this.confidence()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Code": {
                return Optional.ofNullable(clazz.cast(this.code()));
            }
            case "Confidence": {
                return Optional.ofNullable(clazz.cast(this.confidence()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ExpenseCurrency, T> g) {
        return obj -> g.apply((ExpenseCurrency)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String code;
        private Float confidence;

        private BuilderImpl() {
        }

        private BuilderImpl(ExpenseCurrency model) {
            this.code(model.code);
            this.confidence(model.confidence);
        }

        public final String getCode() {
            return this.code;
        }

        public final void setCode(String code) {
            this.code = code;
        }

        @Override
        public final Builder code(String code) {
            this.code = code;
            return this;
        }

        public final Float getConfidence() {
            return this.confidence;
        }

        public final void setConfidence(Float confidence) {
            this.confidence = confidence;
        }

        @Override
        public final Builder confidence(Float confidence) {
            this.confidence = confidence;
            return this;
        }

        public ExpenseCurrency build() {
            return new ExpenseCurrency(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ExpenseCurrency> {
        public Builder code(String var1);

        public Builder confidence(Float var1);
    }
}

