/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.textract.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.textract.TextractAsyncClient;
import software.amazon.awssdk.services.textract.internal.UserAgentUtils;
import software.amazon.awssdk.services.textract.model.AdapterOverview;
import software.amazon.awssdk.services.textract.model.ListAdaptersRequest;
import software.amazon.awssdk.services.textract.model.ListAdaptersResponse;

public class ListAdaptersPublisher
implements SdkPublisher<ListAdaptersResponse> {
    private final TextractAsyncClient client;
    private final ListAdaptersRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListAdaptersPublisher(TextractAsyncClient client, ListAdaptersRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListAdaptersPublisher(TextractAsyncClient client, ListAdaptersRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListAdaptersResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListAdaptersResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<AdapterOverview> adapters() {
        Function<ListAdaptersResponse, Iterator> getIterator = response -> {
            if (response != null && response.adapters() != null) {
                return response.adapters().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListAdaptersResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListAdaptersResponseFetcher
    implements AsyncPageFetcher<ListAdaptersResponse> {
        private ListAdaptersResponseFetcher() {
        }

        public boolean hasNextPage(ListAdaptersResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListAdaptersResponse> nextPage(ListAdaptersResponse previousPage) {
            if (previousPage == null) {
                return ListAdaptersPublisher.this.client.listAdapters(ListAdaptersPublisher.this.firstRequest);
            }
            return ListAdaptersPublisher.this.client.listAdapters((ListAdaptersRequest)((Object)ListAdaptersPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

