/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.textract.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum SelectionStatus {
    SELECTED("SELECTED"),
    NOT_SELECTED("NOT_SELECTED"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, SelectionStatus> VALUE_MAP;
    private final String value;

    private SelectionStatus(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static SelectionStatus fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<SelectionStatus> knownValues() {
        EnumSet<SelectionStatus> knownValues = EnumSet.allOf(SelectionStatus.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(SelectionStatus.class, SelectionStatus::toString);
    }
}

