/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.textract.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.textract.model.NormalizedValue;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AnalyzeIDDetections
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AnalyzeIDDetections> {
    private static final SdkField<String> TEXT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Text").getter(AnalyzeIDDetections.getter(AnalyzeIDDetections::text)).setter(AnalyzeIDDetections.setter(Builder::text)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Text").build()}).build();
    private static final SdkField<NormalizedValue> NORMALIZED_VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("NormalizedValue").getter(AnalyzeIDDetections.getter(AnalyzeIDDetections::normalizedValue)).setter(AnalyzeIDDetections.setter(Builder::normalizedValue)).constructor(NormalizedValue::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NormalizedValue").build()}).build();
    private static final SdkField<Float> CONFIDENCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.FLOAT).memberName("Confidence").getter(AnalyzeIDDetections.getter(AnalyzeIDDetections::confidence)).setter(AnalyzeIDDetections.setter(Builder::confidence)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Confidence").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TEXT_FIELD, NORMALIZED_VALUE_FIELD, CONFIDENCE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String text;
    private final NormalizedValue normalizedValue;
    private final Float confidence;

    private AnalyzeIDDetections(BuilderImpl builder) {
        this.text = builder.text;
        this.normalizedValue = builder.normalizedValue;
        this.confidence = builder.confidence;
    }

    public final String text() {
        return this.text;
    }

    public final NormalizedValue normalizedValue() {
        return this.normalizedValue;
    }

    public final Float confidence() {
        return this.confidence;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.text());
        hashCode = 31 * hashCode + Objects.hashCode(this.normalizedValue());
        hashCode = 31 * hashCode + Objects.hashCode(this.confidence());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AnalyzeIDDetections)) {
            return false;
        }
        AnalyzeIDDetections other = (AnalyzeIDDetections)obj;
        return Objects.equals(this.text(), other.text()) && Objects.equals(this.normalizedValue(), other.normalizedValue()) && Objects.equals(this.confidence(), other.confidence());
    }

    public final String toString() {
        return ToString.builder((String)"AnalyzeIDDetections").add("Text", (Object)this.text()).add("NormalizedValue", (Object)this.normalizedValue()).add("Confidence", (Object)this.confidence()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Text": {
                return Optional.ofNullable(clazz.cast(this.text()));
            }
            case "NormalizedValue": {
                return Optional.ofNullable(clazz.cast(this.normalizedValue()));
            }
            case "Confidence": {
                return Optional.ofNullable(clazz.cast(this.confidence()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AnalyzeIDDetections, T> g) {
        return obj -> g.apply((AnalyzeIDDetections)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String text;
        private NormalizedValue normalizedValue;
        private Float confidence;

        private BuilderImpl() {
        }

        private BuilderImpl(AnalyzeIDDetections model) {
            this.text(model.text);
            this.normalizedValue(model.normalizedValue);
            this.confidence(model.confidence);
        }

        public final String getText() {
            return this.text;
        }

        public final void setText(String text) {
            this.text = text;
        }

        @Override
        public final Builder text(String text) {
            this.text = text;
            return this;
        }

        public final NormalizedValue.Builder getNormalizedValue() {
            return this.normalizedValue != null ? this.normalizedValue.toBuilder() : null;
        }

        public final void setNormalizedValue(NormalizedValue.BuilderImpl normalizedValue) {
            this.normalizedValue = normalizedValue != null ? normalizedValue.build() : null;
        }

        @Override
        public final Builder normalizedValue(NormalizedValue normalizedValue) {
            this.normalizedValue = normalizedValue;
            return this;
        }

        public final Float getConfidence() {
            return this.confidence;
        }

        public final void setConfidence(Float confidence) {
            this.confidence = confidence;
        }

        @Override
        public final Builder confidence(Float confidence) {
            this.confidence = confidence;
            return this;
        }

        public AnalyzeIDDetections build() {
            return new AnalyzeIDDetections(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AnalyzeIDDetections> {
        public Builder text(String var1);

        public Builder normalizedValue(NormalizedValue var1);

        default public Builder normalizedValue(Consumer<NormalizedValue.Builder> normalizedValue) {
            return this.normalizedValue((NormalizedValue)((NormalizedValue.Builder)NormalizedValue.builder().applyMutation(normalizedValue)).build());
        }

        public Builder confidence(Float var1);
    }
}

