/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.taxsettings.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.taxsettings.model.Industries;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TurkeyAdditionalInfo
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, TurkeyAdditionalInfo> {
    private static final SdkField<String> INDUSTRIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("industries").getter(TurkeyAdditionalInfo.getter(TurkeyAdditionalInfo::industriesAsString)).setter(TurkeyAdditionalInfo.setter(Builder::industries)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("industries").build()}).build();
    private static final SdkField<String> KEP_EMAIL_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("kepEmailId").getter(TurkeyAdditionalInfo.getter(TurkeyAdditionalInfo::kepEmailId)).setter(TurkeyAdditionalInfo.setter(Builder::kepEmailId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("kepEmailId").build()}).build();
    private static final SdkField<String> SECONDARY_TAX_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("secondaryTaxId").getter(TurkeyAdditionalInfo.getter(TurkeyAdditionalInfo::secondaryTaxId)).setter(TurkeyAdditionalInfo.setter(Builder::secondaryTaxId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("secondaryTaxId").build()}).build();
    private static final SdkField<String> TAX_OFFICE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("taxOffice").getter(TurkeyAdditionalInfo.getter(TurkeyAdditionalInfo::taxOffice)).setter(TurkeyAdditionalInfo.setter(Builder::taxOffice)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("taxOffice").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INDUSTRIES_FIELD, KEP_EMAIL_ID_FIELD, SECONDARY_TAX_ID_FIELD, TAX_OFFICE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = TurkeyAdditionalInfo.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String industries;
    private final String kepEmailId;
    private final String secondaryTaxId;
    private final String taxOffice;

    private TurkeyAdditionalInfo(BuilderImpl builder) {
        this.industries = builder.industries;
        this.kepEmailId = builder.kepEmailId;
        this.secondaryTaxId = builder.secondaryTaxId;
        this.taxOffice = builder.taxOffice;
    }

    public final Industries industries() {
        return Industries.fromValue(this.industries);
    }

    public final String industriesAsString() {
        return this.industries;
    }

    public final String kepEmailId() {
        return this.kepEmailId;
    }

    public final String secondaryTaxId() {
        return this.secondaryTaxId;
    }

    public final String taxOffice() {
        return this.taxOffice;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.industriesAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.kepEmailId());
        hashCode = 31 * hashCode + Objects.hashCode(this.secondaryTaxId());
        hashCode = 31 * hashCode + Objects.hashCode(this.taxOffice());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TurkeyAdditionalInfo)) {
            return false;
        }
        TurkeyAdditionalInfo other = (TurkeyAdditionalInfo)obj;
        return Objects.equals(this.industriesAsString(), other.industriesAsString()) && Objects.equals(this.kepEmailId(), other.kepEmailId()) && Objects.equals(this.secondaryTaxId(), other.secondaryTaxId()) && Objects.equals(this.taxOffice(), other.taxOffice());
    }

    public final String toString() {
        return ToString.builder((String)"TurkeyAdditionalInfo").add("Industries", (Object)this.industriesAsString()).add("KepEmailId", (Object)this.kepEmailId()).add("SecondaryTaxId", (Object)this.secondaryTaxId()).add("TaxOffice", (Object)this.taxOffice()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "industries": {
                return Optional.ofNullable(clazz.cast(this.industriesAsString()));
            }
            case "kepEmailId": {
                return Optional.ofNullable(clazz.cast(this.kepEmailId()));
            }
            case "secondaryTaxId": {
                return Optional.ofNullable(clazz.cast(this.secondaryTaxId()));
            }
            case "taxOffice": {
                return Optional.ofNullable(clazz.cast(this.taxOffice()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("industries", INDUSTRIES_FIELD);
        map.put("kepEmailId", KEP_EMAIL_ID_FIELD);
        map.put("secondaryTaxId", SECONDARY_TAX_ID_FIELD);
        map.put("taxOffice", TAX_OFFICE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<TurkeyAdditionalInfo, T> g) {
        return obj -> g.apply((TurkeyAdditionalInfo)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String industries;
        private String kepEmailId;
        private String secondaryTaxId;
        private String taxOffice;

        private BuilderImpl() {
        }

        private BuilderImpl(TurkeyAdditionalInfo model) {
            this.industries(model.industries);
            this.kepEmailId(model.kepEmailId);
            this.secondaryTaxId(model.secondaryTaxId);
            this.taxOffice(model.taxOffice);
        }

        public final String getIndustries() {
            return this.industries;
        }

        public final void setIndustries(String industries) {
            this.industries = industries;
        }

        @Override
        public final Builder industries(String industries) {
            this.industries = industries;
            return this;
        }

        @Override
        public final Builder industries(Industries industries) {
            this.industries(industries == null ? null : industries.toString());
            return this;
        }

        public final String getKepEmailId() {
            return this.kepEmailId;
        }

        public final void setKepEmailId(String kepEmailId) {
            this.kepEmailId = kepEmailId;
        }

        @Override
        public final Builder kepEmailId(String kepEmailId) {
            this.kepEmailId = kepEmailId;
            return this;
        }

        public final String getSecondaryTaxId() {
            return this.secondaryTaxId;
        }

        public final void setSecondaryTaxId(String secondaryTaxId) {
            this.secondaryTaxId = secondaryTaxId;
        }

        @Override
        public final Builder secondaryTaxId(String secondaryTaxId) {
            this.secondaryTaxId = secondaryTaxId;
            return this;
        }

        public final String getTaxOffice() {
            return this.taxOffice;
        }

        public final void setTaxOffice(String taxOffice) {
            this.taxOffice = taxOffice;
        }

        @Override
        public final Builder taxOffice(String taxOffice) {
            this.taxOffice = taxOffice;
            return this;
        }

        public TurkeyAdditionalInfo build() {
            return new TurkeyAdditionalInfo(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, TurkeyAdditionalInfo> {
        public Builder industries(String var1);

        public Builder industries(Industries var1);

        public Builder kepEmailId(String var1);

        public Builder secondaryTaxId(String var1);

        public Builder taxOffice(String var1);
    }
}

