/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.taxsettings.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum UkraineTrnType {
    BUSINESS("Business"),
    INDIVIDUAL("Individual"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, UkraineTrnType> VALUE_MAP;
    private final String value;

    private UkraineTrnType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static UkraineTrnType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<UkraineTrnType> knownValues() {
        EnumSet<UkraineTrnType> knownValues = EnumSet.allOf(UkraineTrnType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(UkraineTrnType.class, UkraineTrnType::toString);
    }
}

