/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.taxsettings.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum TaxRegistrationNumberType {
    TAX_REGISTRATION_NUMBER("TaxRegistrationNumber"),
    LOCAL_REGISTRATION_NUMBER("LocalRegistrationNumber"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, TaxRegistrationNumberType> VALUE_MAP;
    private final String value;

    private TaxRegistrationNumberType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static TaxRegistrationNumberType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<TaxRegistrationNumberType> knownValues() {
        EnumSet<TaxRegistrationNumberType> knownValues = EnumSet.allOf(TaxRegistrationNumberType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(TaxRegistrationNumberType.class, TaxRegistrationNumberType::toString);
    }
}

